/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public class CustomBalloonTip
extends BalloonTip {
    protected Rectangle offset = new Rectangle(0, 0, 1, 1);
    private JViewport viewport = null;
    private ComponentAdapter viewportListenerListener = new ComponentAdapter(){

        public void componentMoved(ComponentEvent e) {
            if (CustomBalloonTip.this.attachedComponent.isShowing()) {
                CustomBalloonTip.this.refreshLocation();
            }
        }

        public void componentResized(ComponentEvent e) {
            if (CustomBalloonTip.this.attachedComponent.isShowing()) {
                CustomBalloonTip.this.refreshLocation();
            }
        }
    };

    public CustomBalloonTip(JComponent attachedComponent, String text, Rectangle offset, BalloonTipStyle style, BalloonTip.Orientation alignment, BalloonTip.AttachLocation attachLocation, int horizontalOffset, int verticalOffset, boolean useCloseButton) {
        super(attachedComponent, text, style, alignment, attachLocation, horizontalOffset, verticalOffset, useCloseButton);
        this.offset = offset;
        this.refreshLocation();
    }

    public CustomBalloonTip(JComponent attachedComponent, String text, Rectangle offset, BalloonTipStyle style, BalloonTipPositioner positioner, boolean useCloseButton) {
        super(attachedComponent, text, style, positioner, useCloseButton);
        this.offset = offset;
        this.refreshLocation();
    }

    public void setOffset(Rectangle offset) {
        this.offset = offset;
        this.refreshLocation();
    }

    public void closeBalloon() {
        if (this.viewport != null) {
            this.viewport.removeComponentListener(this.viewportListenerListener);
        }
        super.closeBalloon();
    }

    public void setViewport(JViewport viewport) {
        this.viewport = viewport;
        viewport.addComponentListener(this.viewportListenerListener);
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void refreshLocation() {
        Point location = SwingUtilities.convertPoint(this.attachedComponent, this.getLocation(), this);
        try {
            this.positioner.determineAndSetLocation(new Rectangle(location.x + this.offset.x, location.y + this.offset.y, this.offset.width, this.offset.height));
            if (this.viewport != null) {
                Rectangle view = new Rectangle(SwingUtilities.convertPoint(this.viewport, this.viewport.getLocation(), this.getTopLevelContainer()), this.viewport.getSize());
                Point tipLocation = this.positioner.getTipLocation();
                if (tipLocation.y >= view.y - 1 && tipLocation.y <= view.y + view.height && tipLocation.x >= view.x && tipLocation.x <= view.x + view.width) {
                    this.setVisible(true);
                } else {
                    this.setVisible(false);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }
}

