/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.utils.FlipUtils;

public class EdgedBalloonStyle
extends BalloonTipStyle {
    private Color borderColor;
    private Color fillColor;

    public EdgedBalloonStyle(Color fillColor, Color borderColor) {
        this.borderColor = borderColor;
        this.fillColor = fillColor;
    }

    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + 1, 1, 1, 1);
        }
        return new Insets(1, 1, this.verticalOffset + 1, 1);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Point flippedPoint;
        int i;
        int flipAxis;
        int rectY = y;
        if (this.flipY) {
            rectY = y + this.verticalOffset;
        }
        g.setColor(this.fillColor);
        g.fillRect(x, rectY, width, height - this.verticalOffset);
        g.setColor(this.borderColor);
        g.drawRect(x, rectY, width - 1, height - this.verticalOffset - 1);
        int[] triangleX = new int[]{x + this.horizontalOffset, x + this.horizontalOffset + this.verticalOffset, x + this.horizontalOffset};
        int[] triangleY = new int[]{y + height - this.verticalOffset - 1, y + height - this.verticalOffset - 1, y + height - 1};
        if (this.flipY) {
            flipAxis = height - 1;
            for (i = 0; i < triangleX.length; ++i) {
                flippedPoint = FlipUtils.flipHorizontally(triangleX[i], triangleY[i], flipAxis);
                triangleX[i] = flippedPoint.x;
                triangleY[i] = flippedPoint.y;
            }
        }
        if (this.flipX) {
            flipAxis = width - 1;
            for (i = 0; i < triangleX.length; ++i) {
                flippedPoint = FlipUtils.flipVertically(triangleX[i], triangleY[i], flipAxis);
                triangleX[i] = flippedPoint.x;
                triangleY[i] = flippedPoint.y;
            }
        }
        g.setColor(this.fillColor);
        g.fillPolygon(triangleX, triangleY, 3);
        g.setColor(this.borderColor);
        g.drawLine(triangleX[0], triangleY[0], triangleX[2], triangleY[2]);
        g.drawLine(triangleX[1], triangleY[1], triangleX[2], triangleY[2]);
        g.setColor(this.fillColor);
        g.drawLine(triangleX[0], triangleY[0], triangleX[1], triangleY[1]);
        g.setColor(this.borderColor);
        g.drawLine(triangleX[0], triangleY[0], triangleX[0], triangleY[0]);
        g.drawLine(triangleX[1], triangleY[1], triangleX[1], triangleY[1]);
    }
}

