/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.styles;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import net.java.balloontip.styles.BalloonTipStyle;
import net.java.balloontip.utils.FlipUtils;
import net.java.balloontip.utils.ImageUtils;

public class TexturedBalloonStyle
extends BalloonTipStyle {
    private int arcWidth;
    private int arcHeight;
    private BufferedImage bg;
    private Rectangle bgBounds;
    private Color borderColor;

    public TexturedBalloonStyle(int arcWidth, int arcHeight, Image background, Color borderColor) {
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
        this.bg = ImageUtils.toBufferedImage(background);
        this.bgBounds = new Rectangle(0, 0, this.bg.getWidth(), this.bg.getHeight());
        this.borderColor = borderColor;
    }

    public Insets getBorderInsets(Component c) {
        if (this.flipY) {
            return new Insets(this.verticalOffset + this.arcHeight, this.arcWidth, this.arcHeight, this.arcWidth);
        }
        return new Insets(this.arcHeight, this.arcWidth, this.arcHeight + this.verticalOffset, this.arcWidth);
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int bWidth, int bHeight) {
        Point flippedPoint;
        int i;
        int flipAxis;
        Graphics2D g2d = (Graphics2D)g;
        int rectY = y;
        if (this.flipY) {
            rectY = y + this.verticalOffset;
        }
        g2d.setPaint(new TexturePaint(this.bg, this.bgBounds));
        g2d.fillRoundRect(x, rectY, bWidth, bHeight - this.verticalOffset, this.arcWidth * 2, this.arcHeight * 2);
        g2d.setColor(this.borderColor);
        g2d.drawRoundRect(x, rectY, bWidth - 1, bHeight - this.verticalOffset - 1, this.arcWidth * 2, this.arcHeight * 2);
        int[] triangleX = new int[]{x + this.horizontalOffset, x + this.horizontalOffset + this.verticalOffset, x + this.horizontalOffset};
        int[] triangleY = new int[]{y + bHeight - this.verticalOffset - 1, y + bHeight - this.verticalOffset - 1, y + bHeight - 1};
        if (this.flipY) {
            flipAxis = bHeight - 1;
            for (i = 0; i < triangleX.length; ++i) {
                flippedPoint = FlipUtils.flipHorizontally(triangleX[i], triangleY[i], flipAxis);
                triangleX[i] = flippedPoint.x;
                triangleY[i] = flippedPoint.y;
            }
        }
        if (this.flipX) {
            flipAxis = bWidth - 1;
            for (i = 0; i < triangleX.length; ++i) {
                flippedPoint = FlipUtils.flipVertically(triangleX[i], triangleY[i], flipAxis);
                triangleX[i] = flippedPoint.x;
                triangleY[i] = flippedPoint.y;
            }
        }
        g2d.setPaint(new TexturePaint(this.bg, this.bgBounds));
        g2d.fillPolygon(triangleX, triangleY, 3);
        g2d.setColor(this.borderColor);
        g2d.drawLine(triangleX[0], triangleY[0], triangleX[2], triangleY[2]);
        g2d.drawLine(triangleX[1], triangleY[1], triangleX[2], triangleY[2]);
        g2d.setPaint(new TexturePaint(this.bg, this.bgBounds));
        g2d.fillPolygon(triangleX, triangleY, 3);
        g2d.setColor(this.borderColor);
        g2d.drawLine(triangleX[0], triangleY[0], triangleX[2], triangleY[2]);
        g2d.drawLine(triangleX[1], triangleY[1], triangleX[2], triangleY[2]);
    }

    public int getMinimalHorizontalOffset() {
        return this.arcWidth + this.verticalOffset;
    }
}

