/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui;

import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.EVDocument;
import de.saring.exerciseviewer.gui.panels.DiagramPanel;
import de.saring.exerciseviewer.gui.panels.LapPanel;
import de.saring.exerciseviewer.gui.panels.MainPanel;
import de.saring.exerciseviewer.gui.panels.OptionalPanel;
import de.saring.exerciseviewer.gui.panels.SamplePanel;
import de.saring.exerciseviewer.gui.panels.TrackPanel;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class EVView
extends JDialog {
    private static final String APPLICATION_NAME = "ExerciseViewer";
    private static final String ACTION_CLOSE = "pv.view.close";
    private EVContext context;
    private EVDocument document;
    private MainPanel mainPanel;
    private OptionalPanel optionalPanel;
    private LapPanel lapPanel;
    private SamplePanel samplePanel;
    private DiagramPanel diagramPanel;
    private TrackPanel trackPanel;
    private JButton btClose;
    private JPanel pMain;
    private JTabbedPane tabbedPane;

    @Inject
    public EVView(EVContext context, MainPanel mainPanel, OptionalPanel optionalPanel, LapPanel lapPanel, SamplePanel samplePanel, DiagramPanel diagramPanel, TrackPanel trackPanel) {
        super(context.getMainFrame());
        this.context = context;
        this.mainPanel = mainPanel;
        this.optionalPanel = optionalPanel;
        this.lapPanel = lapPanel;
        this.samplePanel = samplePanel;
        this.diagramPanel = diagramPanel;
        this.trackPanel = trackPanel;
    }

    public void initView(EVDocument document) {
        this.initComponents();
        this.document = document;
        this.mainPanel.setDocument(document);
        this.optionalPanel.setDocument(document);
        this.lapPanel.setDocument(document);
        this.samplePanel.setDocument(document);
        this.diagramPanel.setDocument(document);
        this.trackPanel.setDocument(document);
        this.mainPanel.setDiagramPanel(this.diagramPanel);
        this.getRootPane().setDefaultButton(this.btClose);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.main", new Object[0]), this.mainPanel);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.optional", new Object[0]), this.optionalPanel);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.laps", new Object[0]), this.lapPanel);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.samples", new Object[0]), this.samplePanel);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.diagram", new Object[0]), this.diagramPanel);
        this.tabbedPane.add(this.context.getResReader().getString("pv.view.track", new Object[0]), this.trackPanel);
        this.context.getSAFContext().getResourceMap().injectComponents((Component)this);
        ApplicationActionMap actionMap = this.context.getSAFContext().getActionMap(this.getClass(), (Object)this);
        this.btClose.setAction(actionMap.get(ACTION_CLOSE));
    }

    @Override
    public void setVisible(boolean fVisible) {
        if (fVisible) {
            this.setMinimumSize(this.getPreferredSize());
        }
        super.setVisible(fVisible);
    }

    @Action(name="pv.view.close")
    public void close() {
        this.dispose();
    }

    public void displayExercise() {
        this.setTitle("ExerciseViewer - " + this.document.getExerciseFilename());
        this.mainPanel.displayExercise();
        this.optionalPanel.displayExercise();
        this.lapPanel.displayExercise();
        this.samplePanel.displayExercise();
        this.diagramPanel.displayExercise();
        this.trackPanel.displayExercise();
        this.pack();
    }

    private void initComponents() {
        this.pMain = new JPanel();
        this.btClose = new JButton();
        this.tabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.setTitle(APPLICATION_NAME);
        this.setName("pv.dialog");
        this.btClose.setText("_Close");
        GroupLayout pMainLayout = new GroupLayout(this.pMain);
        this.pMain.setLayout(pMainLayout);
        pMainLayout.setHorizontalGroup(pMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pMainLayout.createSequentialGroup().addContainerGap().addGroup(pMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tabbedPane, -1, 473, Short.MAX_VALUE).addComponent(this.btClose, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        pMainLayout.setVerticalGroup(pMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, pMainLayout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -1, 311, Short.MAX_VALUE).addGap(10, 10, 10).addComponent(this.btClose).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pMain, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.pMain, -1, -1, Short.MAX_VALUE));
        this.pack();
    }
}

