/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import de.saring.util.gui.ListUtils;
import de.saring.util.gui.TableCellRendererOddEven;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;

public class LapPanel
extends BasePanel {
    private static final int COLUMN_COUNT = 13;
    private static final int COLUMN_LAP = 0;
    private static final int COLUMN_LAP_TIME = 1;
    private static final int COLUMN_SPLIT_TIME = 2;
    private static final int COLUMN_HEARTRATE = 3;
    private static final int COLUMN_AVG_HEARTRATE = 4;
    private static final int COLUMN_MAX_HEARTRATE = 5;
    private static final int COLUMN_END_SPEED = 6;
    private static final int COLUMN_AVG_SPEED = 7;
    private static final int COLUMN_DISTANCE = 8;
    private static final int COLUMN_CADENCE = 9;
    private static final int COLUMN_ALTITUDE = 10;
    private static final int COLUMN_ASCENT = 11;
    private static final int COLUMN_TEMPERATURE = 12;
    private String[] columnNames;
    private JLabel laLaps;
    private JScrollPane spLaps;
    private JTable tbLaps;

    @Inject
    public LapPanel(EVContext context) {
        super(context);
        this.initComponents();
        this.columnNames = new String[13];
        this.columnNames[0] = this.getContext().getResReader().getString("pv.laps.lap", new Object[0]);
        this.columnNames[1] = this.getContext().getResReader().getString("pv.laps.lap_time", new Object[0]);
        this.columnNames[2] = this.getContext().getResReader().getString("pv.laps.split_time", new Object[0]);
        this.columnNames[3] = this.getContext().getResReader().getString("pv.laps.heartrate", new Object[0]);
        this.columnNames[4] = this.getContext().getResReader().getString("pv.laps.avg_heartrate", new Object[0]);
        this.columnNames[5] = this.getContext().getResReader().getString("pv.laps.max_heartrate", new Object[0]);
        this.columnNames[6] = this.getContext().getResReader().getString("pv.laps.end_speed", new Object[0]);
        this.columnNames[7] = this.getContext().getResReader().getString("pv.laps.avg_speed", new Object[0]);
        this.columnNames[8] = this.getContext().getResReader().getString("pv.laps.distance", new Object[0]);
        this.columnNames[9] = this.getContext().getResReader().getString("pv.laps.cadence", new Object[0]);
        this.columnNames[10] = this.getContext().getResReader().getString("pv.laps.altitude", new Object[0]);
        this.columnNames[11] = this.getContext().getResReader().getString("pv.laps.ascent", new Object[0]);
        this.columnNames[12] = this.getContext().getResReader().getString("pv.laps.temperature", new Object[0]);
        this.tbLaps.setSelectionMode(0);
        ListUtils.increaseTableRowHeight((JTable)this.tbLaps);
    }

    @Override
    public void displayExercise() {
        final EVExercise exercise = this.getDocument().getExercise();
        this.tbLaps.setModel(new AbstractTableModel(){

            @Override
            public String getColumnName(int col) {
                return LapPanel.this.columnNames[col];
            }

            @Override
            public int getRowCount() {
                if (exercise.getLapList() != null) {
                    return exercise.getLapList().length;
                }
                return 0;
            }

            @Override
            public int getColumnCount() {
                return LapPanel.this.columnNames.length;
            }

            @Override
            public Class<?> getColumnClass(int col) {
                switch (col) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 8: 
                    case 11: {
                        return Integer.class;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 9: 
                    case 10: 
                    case 12: {
                        return Short.class;
                    }
                    case 6: 
                    case 7: {
                        return Float.class;
                    }
                }
                return Object.class;
            }

            @Override
            public Object getValueAt(int row, int col) {
                Lap lap = exercise.getLapList()[row];
                switch (col) {
                    case 0: {
                        return row + 1;
                    }
                    case 1: {
                        int previousLapSplitTime = 0;
                        if (row > 0) {
                            previousLapSplitTime = exercise.getLapList()[row - 1].getTimeSplit();
                        }
                        return lap.getTimeSplit() - previousLapSplitTime;
                    }
                    case 2: {
                        return lap.getTimeSplit();
                    }
                    case 3: {
                        return lap.getHeartRateSplit();
                    }
                    case 4: {
                        return lap.getHeartRateAVG();
                    }
                    case 5: {
                        return lap.getHeartRateMax();
                    }
                    case 6: {
                        if (lap.getSpeed() == null) break;
                        return new Float(lap.getSpeed().getSpeedEnd());
                    }
                    case 7: {
                        if (lap.getSpeed() == null) break;
                        return new Float(lap.getSpeed().getSpeedAVG());
                    }
                    case 8: {
                        if (lap.getSpeed() == null) break;
                        return lap.getSpeed().getDistance();
                    }
                    case 9: {
                        if (lap.getSpeed() == null || !exercise.getRecordingMode().isCadence()) break;
                        return lap.getSpeed().getCadence();
                    }
                    case 10: {
                        if (lap.getAltitude() == null) break;
                        return lap.getAltitude().getAltitude();
                    }
                    case 11: {
                        if (lap.getAltitude() == null || exercise.getFileType() == EVExercise.ExerciseFileType.HRM) break;
                        return lap.getAltitude().getAscent();
                    }
                    case 12: {
                        if (lap.getTemperature() == null) break;
                        return lap.getTemperature().getTemperature();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }
        });
        LapCellRenderer cellRenderer = new LapCellRenderer();
        int i = 0;
        while (i < 13) {
            this.tbLaps.getColumnModel().getColumn(i).setCellRenderer((TableCellRenderer)((Object)cellRenderer));
            ++i;
        }
    }

    private void initComponents() {
        this.laLaps = new JLabel();
        this.spLaps = new JScrollPane();
        this.tbLaps = new JTable();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.laLaps.setFont(this.laLaps.getFont().deriveFont(this.laLaps.getFont().getStyle() | 1));
        this.laLaps.setText("_All Recorded Laps");
        this.laLaps.setName("pv.laps.recorded_laps");
        this.tbLaps.setAutoCreateRowSorter(true);
        this.tbLaps.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tbLaps.setAutoResizeMode(0);
        this.tbLaps.setIntercellSpacing(new Dimension(0, 0));
        this.tbLaps.setShowHorizontalLines(false);
        this.tbLaps.setShowVerticalLines(false);
        this.tbLaps.getTableHeader().setReorderingAllowed(false);
        this.spLaps.setViewportView(this.tbLaps);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laLaps).addContainerGap(403, Short.MAX_VALUE)).addComponent(this.spLaps, -1, 544, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laLaps).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spLaps, -1, 326, Short.MAX_VALUE)));
    }

    class LapCellRenderer
    extends TableCellRendererOddEven {
        final FormatUtils formatUtils;

        public LapCellRenderer() {
            super(LapPanel.this.getContext().getResReader().getColor("common.table.background_odd"), LapPanel.this.getContext().getResReader().getColor("common.table.background_even"));
            this.formatUtils = LapPanel.this.getContext().getFormatUtils();
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            String text = null;
            switch (vColIndex) {
                case 0: {
                    text = value.toString();
                    break;
                }
                case 1: 
                case 2: {
                    text = this.formatUtils.tenthSeconds2TimeString(((Integer)value).intValue());
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    text = this.formatUtils.heartRateToString((int)((Short)value).shortValue());
                    break;
                }
                case 6: 
                case 7: {
                    if (value == null) break;
                    text = this.formatUtils.speedToString(((Float)value).floatValue(), 2);
                    break;
                }
                case 8: {
                    if (value == null) break;
                    text = this.formatUtils.distanceToString((double)((float)((Integer)value).intValue() / 1000.0f), 3);
                    break;
                }
                case 9: {
                    if (value == null) break;
                    text = this.formatUtils.cadenceToString((int)((Short)value).shortValue());
                    break;
                }
                case 10: {
                    if (value == null) break;
                    text = this.formatUtils.heightToString((int)((Short)value).shortValue());
                    break;
                }
                case 11: {
                    if (value == null) break;
                    text = this.formatUtils.heightToString(((Integer)value).intValue());
                    break;
                }
                case 12: {
                    if (value == null) break;
                    text = this.formatUtils.temperatureToString(((Short)value).shortValue());
                }
            }
            this.setText(text);
            return component;
        }
    }
}

