/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.gui.panels;

import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.exerciseviewer.gui.panels.BasePanel;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;

public class OptionalPanel
extends BasePanel {
    private JLabel laAltitudeData;
    private JLabel laAscent;
    private JLabel laAscentValue;
    private JLabel laAvgAltitude;
    private JLabel laAvgAltitudeValue;
    private JLabel laAvgCadence;
    private JLabel laAvgCadenceValue;
    private JLabel laAvgSpeed;
    private JLabel laAvgSpeedValue;
    private JLabel laAvgTemperature;
    private JLabel laAvgTemperatureValue;
    private JLabel laBikeNr;
    private JLabel laBikeNrValue;
    private JLabel laCadenceData;
    private JLabel laDistance;
    private JLabel laDistanceValue;
    private JLabel laMaxAltitude;
    private JLabel laMaxAltitudeValue;
    private JLabel laMaxCadence;
    private JLabel laMaxCadenceValue;
    private JLabel laMaxSpeed;
    private JLabel laMaxSpeedValue;
    private JLabel laMaxTemperature;
    private JLabel laMaxTemperatureValue;
    private JLabel laMinAltitude;
    private JLabel laMinAltitudeValue;
    private JLabel laMinTemperature;
    private JLabel laMinTemperatureValue;
    private JLabel laSpeedData;
    private JLabel laTemperatureData;
    private JPanel pLeft;
    private JPanel pRight;

    @Inject
    public OptionalPanel(EVContext context) {
        super(context);
        this.initComponents();
    }

    @Override
    public void displayExercise() {
        EVExercise exercise = this.getDocument().getExercise();
        FormatUtils formatUtils = this.getContext().getFormatUtils();
        this.laAvgSpeedValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMaxSpeedValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laDistanceValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laBikeNrValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAvgCadenceValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMaxCadenceValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMinAltitudeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAvgAltitudeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMaxAltitudeValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAscentValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMinTemperatureValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laAvgTemperatureValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        this.laMaxTemperatureValue.setText(this.getContext().getResReader().getString("common.n_a_", new Object[0]));
        if (exercise.getSpeed() != null) {
            this.laAvgSpeedValue.setText(formatUtils.speedToString(exercise.getSpeed().getSpeedAVG(), 2));
            this.laMaxSpeedValue.setText(formatUtils.speedToString(exercise.getSpeed().getSpeedMax(), 2));
            this.laDistanceValue.setText(formatUtils.distanceToString((double)((float)exercise.getSpeed().getDistance() / 1000.0f), 2));
            if (exercise.getFileType() != EVExercise.ExerciseFileType.HRM) {
                this.laBikeNrValue.setText(String.valueOf(exercise.getRecordingMode().getBikeNumber()));
            }
        }
        if (exercise.getCadence() != null) {
            this.laAvgCadenceValue.setText(formatUtils.cadenceToString((int)exercise.getCadence().getCadenceAVG()));
            this.laMaxCadenceValue.setText(formatUtils.cadenceToString((int)exercise.getCadence().getCadenceMax()));
        }
        if (exercise.getAltitude() != null) {
            this.laMinAltitudeValue.setText(formatUtils.heightToString((int)exercise.getAltitude().getAltitudeMin()));
            this.laAvgAltitudeValue.setText(formatUtils.heightToString((int)exercise.getAltitude().getAltitudeAVG()));
            this.laMaxAltitudeValue.setText(formatUtils.heightToString((int)exercise.getAltitude().getAltitudeMax()));
            this.laAscentValue.setText(formatUtils.heightToString(exercise.getAltitude().getAscent()));
        }
        if (exercise.getTemperature() != null) {
            this.laMinTemperatureValue.setText(formatUtils.temperatureToString(exercise.getTemperature().getTemperatureMin()));
            this.laAvgTemperatureValue.setText(formatUtils.temperatureToString(exercise.getTemperature().getTemperatureAVG()));
            this.laMaxTemperatureValue.setText(formatUtils.temperatureToString(exercise.getTemperature().getTemperatureMax()));
        }
    }

    private void initComponents() {
        this.pLeft = new JPanel();
        this.laCadenceData = new JLabel();
        this.laBikeNr = new JLabel();
        this.laDistance = new JLabel();
        this.laMaxSpeed = new JLabel();
        this.laAvgSpeed = new JLabel();
        this.laMaxCadence = new JLabel();
        this.laAvgCadence = new JLabel();
        this.laAvgSpeedValue = new JLabel();
        this.laMaxSpeedValue = new JLabel();
        this.laDistanceValue = new JLabel();
        this.laBikeNrValue = new JLabel();
        this.laMaxCadenceValue = new JLabel();
        this.laAvgCadenceValue = new JLabel();
        this.laSpeedData = new JLabel();
        this.pRight = new JPanel();
        this.laAltitudeData = new JLabel();
        this.laMinAltitude = new JLabel();
        this.laAvgAltitude = new JLabel();
        this.laMaxAltitude = new JLabel();
        this.laAscent = new JLabel();
        this.laTemperatureData = new JLabel();
        this.laMinTemperature = new JLabel();
        this.laAvgTemperature = new JLabel();
        this.laMaxTemperature = new JLabel();
        this.laMinAltitudeValue = new JLabel();
        this.laAvgAltitudeValue = new JLabel();
        this.laMaxAltitudeValue = new JLabel();
        this.laAscentValue = new JLabel();
        this.laMinTemperatureValue = new JLabel();
        this.laAvgTemperatureValue = new JLabel();
        this.laMaxTemperatureValue = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(new GridLayout(1, 2, 20, 20));
        this.laCadenceData.setFont(this.laCadenceData.getFont().deriveFont(this.laCadenceData.getFont().getStyle() | 1));
        this.laCadenceData.setText("_Cadence Data");
        this.laCadenceData.setName("pv.opt.cadence_data");
        this.laBikeNr.setText("_Bike number:");
        this.laBikeNr.setName("pv.opt.bike_nr");
        this.laDistance.setText("_Distance:");
        this.laDistance.setName("pv.opt.distance");
        this.laMaxSpeed.setText("_Maximum:");
        this.laMaxSpeed.setName("pv.opt.maximum");
        this.laAvgSpeed.setText("_Average:");
        this.laAvgSpeed.setName("pv.opt.average");
        this.laMaxCadence.setText("_Maximum:");
        this.laMaxCadence.setName("pv.opt.maximum");
        this.laAvgCadence.setText("_Average:");
        this.laAvgCadence.setName("pv.opt.average");
        this.laAvgSpeedValue.setText("_n.a.");
        this.laMaxSpeedValue.setText("_n.a.");
        this.laDistanceValue.setText("_n.a.");
        this.laBikeNrValue.setText("_n.a.");
        this.laMaxCadenceValue.setText("_n.a.");
        this.laAvgCadenceValue.setText("_n.a.");
        this.laSpeedData.setFont(this.laSpeedData.getFont().deriveFont(this.laSpeedData.getFont().getStyle() | 1));
        this.laSpeedData.setText("_Speed Data");
        this.laSpeedData.setName("pv.opt.speed_data");
        GroupLayout pLeftLayout = new GroupLayout(this.pLeft);
        this.pLeft.setLayout(pLeftLayout);
        pLeftLayout.setHorizontalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAvgCadence).addComponent(this.laMaxCadence)).addContainerGap(164, Short.MAX_VALUE)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laCadenceData).addContainerGap(139, Short.MAX_VALUE)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laSpeedData).addContainerGap(156, Short.MAX_VALUE)).addGroup(pLeftLayout.createSequentialGroup().addContainerGap().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAvgSpeed).addComponent(this.laMaxSpeed).addComponent(this.laDistance).addComponent(this.laBikeNr)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.laBikeNrValue, GroupLayout.Alignment.LEADING, -1, 140, Short.MAX_VALUE).addComponent(this.laDistanceValue, GroupLayout.Alignment.LEADING, -1, 140, Short.MAX_VALUE).addComponent(this.laMaxSpeedValue, GroupLayout.Alignment.LEADING, -1, 140, Short.MAX_VALUE).addComponent(this.laAvgSpeedValue, GroupLayout.Alignment.LEADING, -1, 140, Short.MAX_VALUE).addComponent(this.laAvgCadenceValue, -1, 140, Short.MAX_VALUE).addComponent(this.laMaxCadenceValue, -1, 140, Short.MAX_VALUE))));
        pLeftLayout.setVerticalGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laSpeedData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laAvgSpeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laMaxSpeed).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDistance).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laBikeNr)).addGroup(pLeftLayout.createSequentialGroup().addComponent(this.laAvgSpeedValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laMaxSpeedValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laDistanceValue).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laBikeNrValue))).addGap(25, 25, 25).addComponent(this.laCadenceData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(pLeftLayout.createSequentialGroup().addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgCadence).addComponent(this.laAvgCadenceValue)).addGap(21, 21, 21)).addGroup(pLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxCadence).addComponent(this.laMaxCadenceValue))).addContainerGap(152, Short.MAX_VALUE)));
        this.add(this.pLeft);
        this.laAltitudeData.setFont(this.laAltitudeData.getFont().deriveFont(this.laAltitudeData.getFont().getStyle() | 1));
        this.laAltitudeData.setText("_Altitude Data");
        this.laAltitudeData.setName("pv.opt.altitude_data");
        this.laMinAltitude.setText("_Minimum:");
        this.laMinAltitude.setName("pv.opt.minimum");
        this.laAvgAltitude.setText("_Average:");
        this.laAvgAltitude.setName("pv.opt.average");
        this.laMaxAltitude.setText("_Maximum");
        this.laMaxAltitude.setName("pv.opt.maximum");
        this.laAscent.setText("_Ascent:");
        this.laAscent.setName("pv.opt.ascent");
        this.laTemperatureData.setFont(this.laTemperatureData.getFont().deriveFont(this.laTemperatureData.getFont().getStyle() | 1));
        this.laTemperatureData.setText("_Temperature Data");
        this.laTemperatureData.setName("pv.opt.temperature_data");
        this.laMinTemperature.setText("_Minimum:");
        this.laMinTemperature.setName("pv.opt.minimum");
        this.laAvgTemperature.setText("_Average:");
        this.laAvgTemperature.setName("pv.opt.average");
        this.laMaxTemperature.setText("_Maximum:");
        this.laMaxTemperature.setName("pv.opt.maximum");
        this.laMinAltitudeValue.setText("_n.a.");
        this.laAvgAltitudeValue.setText("_n.a.");
        this.laMaxAltitudeValue.setText("_n.a.");
        this.laAscentValue.setText("_n.a.");
        this.laMinTemperatureValue.setText("_n.a.");
        this.laAvgTemperatureValue.setText("_n.a.");
        this.laMaxTemperatureValue.setText("_n.a.");
        GroupLayout pRightLayout = new GroupLayout(this.pRight);
        this.pRight.setLayout(pRightLayout);
        pRightLayout.setHorizontalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTemperatureData).addGroup(pRightLayout.createSequentialGroup().addContainerGap().addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMinTemperature).addComponent(this.laAvgTemperature).addComponent(this.laMaxTemperature).addComponent(this.laMinAltitude).addComponent(this.laAvgAltitude).addComponent(this.laMaxAltitude).addComponent(this.laAscent)).addGap(7, 7, 7).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMinAltitudeValue, -1, 145, Short.MAX_VALUE).addComponent(this.laAvgAltitudeValue, -1, 145, Short.MAX_VALUE).addComponent(this.laMaxAltitudeValue, -1, 145, Short.MAX_VALUE).addComponent(this.laAscentValue, -1, 145, Short.MAX_VALUE).addComponent(this.laMinTemperatureValue, -1, 145, Short.MAX_VALUE).addComponent(this.laAvgTemperatureValue, -1, 145, Short.MAX_VALUE).addComponent(this.laMaxTemperatureValue, -1, 145, Short.MAX_VALUE))).addComponent(this.laAltitudeData)).addContainerGap()));
        pRightLayout.setVerticalGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pRightLayout.createSequentialGroup().addComponent(this.laAltitudeData, -2, 15, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinAltitude).addComponent(this.laMinAltitudeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgAltitude).addComponent(this.laAvgAltitudeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxAltitude).addComponent(this.laMaxAltitudeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAscent).addComponent(this.laAscentValue)).addGap(25, 25, 25).addComponent(this.laTemperatureData).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinTemperature).addComponent(this.laMinTemperatureValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgTemperature).addComponent(this.laAvgTemperatureValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxTemperature).addComponent(this.laMaxTemperatureValue)).addContainerGap(129, Short.MAX_VALUE)));
        this.add(this.pRight);
    }
}

