/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import java.util.Calendar;

public class PolarF6RawParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("Polar F6/F11", new String[]{"frd", "FRD"});
    private int[] fileContent;
    private static int F6ExerciseFileLength = 49;
    private static int F11ExerciseFileLength = 50;

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        this.fileContent = this.readFileToByteArray(filename);
        EVExercise exercise = new EVExercise();
        exercise.setFileType(EVExercise.ExerciseFileType.F6RAW);
        if (this.fileContent.length != F6ExerciseFileLength && this.fileContent.length != F11ExerciseFileLength) {
            throw new EVException("The exercise file is not valid, the file length is not correct ...");
        }
        StringBuilder exerciseName = new StringBuilder();
        int i = 0;
        while ((this.fileContent[i] & 0x80) != 128 && i < 8) {
            exerciseName.append(this.decodeChar(this.fileContent[i]));
            ++i;
        }
        exerciseName.append(String.valueOf(this.fileContent[i] - 128));
        exercise.setTypeLabel(exerciseName.toString());
        int dateDay = this.fileContent[8];
        int dateMonth = this.fileContent[9];
        int dateYear = 2000 + this.fileContent[10];
        int dateSeconds = this.decodeBCD(this.fileContent[11]);
        int dateMinutes = this.decodeBCD(this.fileContent[12]);
        int dateHours = this.decodeBCD(this.fileContent[13]);
        Calendar calDate = Calendar.getInstance();
        calDate.set(dateYear, dateMonth - 1, dateDay, dateHours, dateMinutes, dateSeconds);
        exercise.setDate(calDate.getTime());
        int durationSeconds = this.decodeBCD(this.fileContent[14]);
        int durationMinutes = this.decodeBCD(this.fileContent[15]);
        int durationHours = this.decodeBCD(this.fileContent[16]);
        exercise.setDuration(durationHours * 60 * 60 * 10 + durationMinutes * 60 * 10 + durationSeconds * 10);
        exercise.setHeartRateAVG((short)this.fileContent[17]);
        exercise.setHeartRateMax((short)this.fileContent[18]);
        RecordingMode recMode = new RecordingMode();
        exercise.setRecordingMode(recMode);
        exercise.setHeartRateLimits(new HeartRateLimit[4]);
        exercise.getHeartRateLimits()[0] = this.decodeHeartRateLimit(35, 23);
        exercise.getHeartRateLimits()[1] = this.decodeHeartRateLimit(37, 26);
        exercise.getHeartRateLimits()[1].setLowerHeartRate((short)60);
        exercise.getHeartRateLimits()[1].setUpperHeartRate((short)70);
        exercise.getHeartRateLimits()[1].setAbsoluteRange(false);
        exercise.getHeartRateLimits()[2] = this.decodeHeartRateLimit(39, 29);
        exercise.getHeartRateLimits()[2].setLowerHeartRate((short)71);
        exercise.getHeartRateLimits()[2].setUpperHeartRate((short)80);
        exercise.getHeartRateLimits()[2].setAbsoluteRange(false);
        exercise.getHeartRateLimits()[3] = this.decodeHeartRateLimit(41, 32);
        exercise.getHeartRateLimits()[3].setLowerHeartRate((short)81);
        exercise.getHeartRateLimits()[3].setUpperHeartRate((short)90);
        exercise.getHeartRateLimits()[3].setAbsoluteRange(false);
        int energyLowByte = this.fileContent[19];
        int energyHighByte = this.fileContent[20];
        exercise.setEnergy(energyLowByte + (energyHighByte << 8));
        exercise.setLapList(new Lap[0]);
        exercise.setSampleList(new ExerciseSample[0]);
        int offset = 0;
        if (this.fileContent.length == F11ExerciseFileLength) {
            offset = 1;
        }
        int cumWorkoutSeconds = this.decodeBCD(this.fileContent[43 + offset]);
        int cumWorkoutMinutes = this.decodeBCD(this.fileContent[44 + offset]);
        int cumWorkoutHours = this.decodeBCD(this.fileContent[45 + offset]);
        exercise.setSumExerciseTime(cumWorkoutHours * 60 + cumWorkoutMinutes + cumWorkoutSeconds / 60);
        int energyTotalPart1 = this.decodeBCD(this.fileContent[46 + offset]);
        int energyTotalPart2 = this.decodeBCD(this.fileContent[47 + offset]);
        int energyTotalPart3 = this.decodeBCD(this.fileContent[48 + offset]);
        exercise.setEnergyTotal(energyTotalPart3 * 10000 + energyTotalPart2 * 100 + energyTotalPart1);
        return exercise;
    }

    private char decodeChar(int value) {
        char cDecoded = '?';
        switch (value) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                cDecoded = (char)(48 + value);
                break;
            }
            case 10: {
                cDecoded = ' ';
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                cDecoded = (char)(65 + value - 11);
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                cDecoded = (char)(97 + value - 37);
                break;
            }
            case 63: {
                cDecoded = '-';
                break;
            }
            case 64: {
                cDecoded = '%';
                break;
            }
            case 65: {
                cDecoded = '/';
                break;
            }
            case 66: {
                cDecoded = '(';
                break;
            }
            case 67: {
                cDecoded = ')';
                break;
            }
            case 68: {
                cDecoded = '*';
                break;
            }
            case 69: {
                cDecoded = '+';
                break;
            }
            case 70: {
                cDecoded = '.';
                break;
            }
            case 71: {
                cDecoded = ':';
                break;
            }
            case 72: {
                cDecoded = '?';
                break;
            }
        }
        return cDecoded;
    }

    private int decodeBCD(int value) {
        return (value >> 4) * 10 + (value & 0xF);
    }

    private HeartRateLimit decodeHeartRateLimit(int offsetLimits, int offsetTimes) {
        HeartRateLimit hrLimit = new HeartRateLimit();
        hrLimit.setLowerHeartRate((short)this.fileContent[offsetLimits + 0]);
        hrLimit.setUpperHeartRate((short)this.fileContent[offsetLimits + 1]);
        int hrLimitWithinSecs = this.decodeBCD(this.fileContent[offsetTimes]);
        hrLimitWithinSecs += this.decodeBCD(this.fileContent[offsetTimes + 1]) * 60;
        hrLimit.setTimeWithin(hrLimitWithinSecs += this.decodeBCD(this.fileContent[offsetTimes + 2]) * 60 * 60);
        return hrLimit;
    }
}

