/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui;

import de.saring.exerciseviewer.gui.EVMain;
import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STController;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.STView;
import de.saring.sportstracker.gui.dialogs.AboutDialog;
import de.saring.sportstracker.gui.dialogs.ExerciseDialog;
import de.saring.sportstracker.gui.dialogs.FilterDialog;
import de.saring.sportstracker.gui.dialogs.HRMFileOpenDialog;
import de.saring.sportstracker.gui.dialogs.NoteDialog;
import de.saring.sportstracker.gui.dialogs.OptionsDialog;
import de.saring.sportstracker.gui.dialogs.OverviewDialog;
import de.saring.sportstracker.gui.dialogs.SportTypeListDialog;
import de.saring.sportstracker.gui.dialogs.StatisticDialog;
import de.saring.sportstracker.gui.dialogs.WeightDialog;
import de.saring.sportstracker.gui.views.EntryView;
import de.saring.util.data.IdDateObjectList;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.ActionMap;
import org.jdesktop.application.Action;
import org.jdesktop.application.Task;

@Singleton
public class STControllerImpl
implements STController {
    private static final Logger LOGGER = Logger.getLogger(STControllerImpl.class.getName());
    private STContext context;
    private STDocument document;
    private STView view;
    @Inject
    private Provider<ExerciseDialog> prExerciseDialog;
    @Inject
    private Provider<NoteDialog> prNoteDialog;
    @Inject
    private Provider<WeightDialog> prWeightDialog;
    @Inject
    private Provider<OptionsDialog> prOptionsDialog;
    @Inject
    private Provider<FilterDialog> prFilterDialog;
    @Inject
    private Provider<SportTypeListDialog> prSportTypeListDialog;
    @Inject
    private Provider<StatisticDialog> prStatisticDialog;
    @Inject
    private Provider<OverviewDialog> prOverviewDialog;
    @Inject
    private Provider<AboutDialog> prAboutDialog;
    @Inject
    private Provider<HRMFileOpenDialog> prHRMFileOpenDialog;
    @Inject
    private Provider<EVMain> prExerciseViewer;
    private ActionMap actionMap;
    private Date dateForNewEntries;

    @Inject
    public STControllerImpl(STContext context, STDocument document, STView view) {
        this.context = context;
        this.document = document;
        this.view = view;
    }

    @Override
    public ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = this.context.getSAFContext().getActionMap(STControllerImpl.class, this);
        }
        return this.actionMap;
    }

    @Action(name="st.view.load", block=Task.BlockingScope.WINDOW)
    public Task<Void, Void> load() {
        return new LoadTask();
    }

    @Action(name="st.view.save", block=Task.BlockingScope.WINDOW)
    public Task<Void, Void> save() {
        return new SaveTask();
    }

    private boolean executeSave() {
        try {
            this.document.storeApplicationData();
            return true;
        }
        catch (STException se) {
            LOGGER.log(Level.SEVERE, "Failed to store application data!", se);
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.save_data", new Object[0]);
            return false;
        }
        finally {
            this.view.updateSaveAction();
        }
    }

    @Action(name="st.view.open_exerciseviewer")
    public void openExerciseViewer() {
        File selectedFile = this.prHRMFileOpenDialog.get().selectHRMFile(this.document.getOptions(), null);
        if (selectedFile != null) {
            EVMain pv = this.prExerciseViewer.get();
            pv.showExercise(selectedFile.getAbsolutePath(), this.document.getOptions(), false);
        }
    }

    @Override
    @Action(name="st.view.print")
    public void print() {
        try {
            this.view.getCurrentView().print();
        }
        catch (STException se) {
            LOGGER.log(Level.WARNING, "Failed to print current view!", se);
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.print_view", new Object[0]);
        }
    }

    @Action(name="st.view.quit")
    public void quitApplication() {
        this.context.getSAFContext().getApplication().exit();
    }

    @Override
    @Action(name="st.view.exercise_add")
    public void addExercise() {
        if (!this.checkForExistingSportTypes()) {
            return;
        }
        Exercise newExercise = this.createNewExercise(this.dateForNewEntries);
        ExerciseDialog dlg = this.prExerciseDialog.get();
        dlg.setExercise(newExercise);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    @Action(name="st.view.note_add")
    public void addNote() {
        Note newNote = new Note(this.document.getNoteList().getNewID());
        newNote.setDate(this.setTimeForDate(this.dateForNewEntries));
        NoteDialog dlg = this.prNoteDialog.get();
        dlg.setNote(newNote);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    @Action(name="st.view.weight_add")
    public void addWeight() {
        Weight newWeight = new Weight(this.document.getWeightList().getNewID());
        newWeight.setDate(this.setTimeForDate(this.dateForNewEntries));
        int weightCount = this.document.getWeightList().size();
        if (weightCount > 0) {
            Weight lastWeight = (Weight)this.document.getWeightList().getAt(weightCount - 1);
            newWeight.setValue(lastWeight.getValue());
        }
        WeightDialog dlg = this.prWeightDialog.get();
        dlg.setWeight(newWeight);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    @Override
    public void setDateForNewEntries(Date date) {
        this.dateForNewEntries = date;
    }

    @Override
    @Action(name="st.view.entry_delete")
    public void deleteEntry() {
        int[] selectedEntryIDs = null;
        IdDateObjectList entryList = null;
        if (this.view.getCurrentView().getSelectedExerciseCount() > 0) {
            selectedEntryIDs = this.view.getCurrentView().getSelectedExerciseIDs();
            entryList = this.document.getExerciseList();
        } else if (this.view.getCurrentView().getSelectedNoteCount() > 0) {
            selectedEntryIDs = this.view.getCurrentView().getSelectedNoteIDs();
            entryList = this.document.getNoteList();
        } else if (this.view.getCurrentView().getSelectedWeightCount() > 0) {
            selectedEntryIDs = this.view.getCurrentView().getSelectedWeightIDs();
            entryList = this.document.getWeightList();
        }
        if (selectedEntryIDs == null || selectedEntryIDs.length == 0) {
            return;
        }
        if (this.context.showConfirmDialog(this.context.getMainFrame(), "st.view.confirm.delete.title", "st.view.confirm.delete.text") != 0) {
            return;
        }
        int[] nArray = selectedEntryIDs;
        int n = selectedEntryIDs.length;
        int n2 = 0;
        while (n2 < n) {
            int id = nArray[n2];
            entryList.removeByID(id);
            ++n2;
        }
        this.view.updateView();
    }

    @Override
    @Action(name="st.view.entry_edit")
    public void editEntry() {
        if (this.view.getCurrentView().getSelectedExerciseCount() == 1) {
            this.editExercise(this.view.getCurrentView().getSelectedExerciseIDs()[0]);
        } else if (this.view.getCurrentView().getSelectedNoteCount() == 1) {
            this.editNote(this.view.getCurrentView().getSelectedNoteIDs()[0]);
        } else if (this.view.getCurrentView().getSelectedWeightCount() == 1) {
            this.editWeight(this.view.getCurrentView().getSelectedWeightIDs()[0]);
        }
    }

    private void editExercise(int exerciseID) {
        Exercise selExercise = (Exercise)this.document.getExerciseList().getByID(exerciseID);
        ExerciseDialog dlg = this.prExerciseDialog.get();
        dlg.setExercise(selExercise);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    private void editNote(int noteID) {
        Note selNote = (Note)this.document.getNoteList().getByID(noteID);
        NoteDialog dlg = this.prNoteDialog.get();
        dlg.setNote(selNote);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    private void editWeight(int weightID) {
        Weight selWeight = (Weight)this.document.getWeightList().getByID(weightID);
        WeightDialog dlg = this.prWeightDialog.get();
        dlg.setWeight(selWeight);
        this.context.showDialog(dlg);
        this.view.updateView();
    }

    @Action(name="st.view.view_hrm")
    public void viewHRMFile() {
        int exerciseID = this.view.getCurrentView().getSelectedExerciseIDs()[0];
        Exercise exercise = (Exercise)this.document.getExerciseList().getByID(exerciseID);
        EVMain pv = this.prExerciseViewer.get();
        pv.showExercise(exercise.getHrmFile(), this.document.getOptions(), false);
    }

    @Action(name="st.view.preferences")
    public void editPreferences() {
        this.context.showDialog(this.prOptionsDialog.get());
        this.view.updateView();
    }

    @Action(name="st.view.calendar_view")
    public void showCalendarView() {
        this.view.switchToView(EntryView.ViewType.CALENDAR);
    }

    @Action(name="st.view.exercise_list_view")
    public void showExerciseListView() {
        this.view.switchToView(EntryView.ViewType.EXERCISE_LIST);
    }

    @Action(name="st.view.note_list_view")
    public void showNoteListView() {
        this.view.switchToView(EntryView.ViewType.NOTE_LIST);
    }

    @Action(name="st.view.weight_list_view")
    public void showWeightListView() {
        this.view.switchToView(EntryView.ViewType.WEIGHT_LIST);
    }

    @Action(name="st.view.filter_exercises")
    public void filterExercises() {
        FilterDialog dlg = this.prFilterDialog.get();
        dlg.setInitialFilter(this.document.getCurrentFilter());
        this.context.showDialog(dlg);
        if (dlg.getSelectedFilter() != null) {
            this.document.setCurrentFilter(dlg.getSelectedFilter());
            this.document.setFilterEnabled(true);
            this.view.updateView();
        }
    }

    @Action(name="st.view.filter_disable")
    public void disableFilter() {
        this.document.setFilterEnabled(false);
        this.view.updateView();
    }

    @Action(name="st.view.sporttype_editor")
    public void showSportTypeEditor() {
        this.context.showDialog(this.prSportTypeListDialog.get());
        SportTypeList stList = this.document.getSportTypeList();
        this.document.getExerciseList().updateSportTypes(stList);
        this.document.getCurrentFilter().updateSportTypes(stList);
        this.view.updateView();
    }

    @Action(name="st.view.statistics")
    public void showStatistics() {
        if (!this.checkForExistingExercises()) {
            return;
        }
        this.context.showDialog(this.prStatisticDialog.get());
    }

    @Action(name="st.view.overview_diagram")
    public void showOverviewDiagram() {
        if (!this.checkForExistingExercises()) {
            return;
        }
        this.context.showDialog(this.prOverviewDialog.get());
    }

    @Action(name="st.view.about")
    public void showAboutDialog() {
        this.context.showDialog(this.prAboutDialog.get());
    }

    @Override
    public boolean dropHrmFile(String filename, Exercise exercise) {
        if (!this.checkForExistingExercises()) {
            return false;
        }
        if (exercise != null) {
            exercise.setHrmFile(filename);
            this.document.getExerciseList().set(exercise);
            this.context.showMessageDialog(this.context.getMainFrame(), 1, "common.info", "st.calview.draganddrop.assigned", new Object[0]);
        } else {
            Exercise newExercise = this.createNewExercise(null);
            newExercise.setHrmFile(filename);
            ExerciseDialog dlg = this.prExerciseDialog.get();
            dlg.setExercise(newExercise);
            dlg.importHRMFile();
            this.context.showDialog(dlg);
        }
        this.view.updateView();
        return true;
    }

    @Override
    public boolean checkForExistingSportTypes() {
        if (this.document.getSportTypeList().size() == 0) {
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.no_sporttype", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForExistingExercises() {
        if (this.document.getExerciseList().size() == 0) {
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.no_exercise", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForExistingNotes() {
        if (this.document.getNoteList().size() == 0) {
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.no_note", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean checkForExistingWeights() {
        if (this.document.getWeightList().size() == 0) {
            this.context.showMessageDialog(this.context.getMainFrame(), 0, "common.error", "st.main.error.no_weight", new Object[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean saveBeforeExit() {
        if (!this.document.isDirtyData()) {
            return true;
        }
        if (!this.document.getOptions().isSaveOnExit() && this.context.showConfirmDialog(this.context.getMainFrame(), "st.main.confirm.save_exit.title", "st.main.confirm.save_exit.text") != 0) {
            return true;
        }
        return this.executeSave();
    }

    @Override
    public void startActionManually(String actionName) {
        this.getActionMap().get(actionName).actionPerformed(new ActionEvent(this.context.getMainFrame(), 1001, actionName));
    }

    private void askForDefiningSportTypes() {
        if (this.document.getSportTypeList().size() == 0 && this.context.showConfirmDialog(this.context.getMainFrame(), "common.info", "st.main.confirm.define_first_sporttype") == 0) {
            this.showSportTypeEditor();
        }
    }

    private Exercise createNewExercise(Date date) {
        Exercise exercise = new Exercise(this.document.getExerciseList().getNewID());
        exercise.setDate(this.setTimeForDate(date));
        return exercise;
    }

    private Date setTimeForDate(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(11, 12);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    class LoadTask
    extends Task<Void, Void> {
        public LoadTask() {
            super(STControllerImpl.this.context.getSAFContext().getApplication());
            this.setUserCanCancel(false);
        }

        @Override
        protected Void doInBackground() throws Exception {
            STControllerImpl.this.document.readApplicationData();
            return null;
        }

        @Override
        protected void failed(Throwable cause) {
            super.failed(cause);
            STControllerImpl.this.context.showMessageDialog(STControllerImpl.this.context.getMainFrame(), 0, "common.error", "st.main.error.load_data", new Object[0]);
        }

        @Override
        protected void finished() {
            STControllerImpl.this.view.updateView();
            STControllerImpl.this.askForDefiningSportTypes();
        }
    }

    class SaveTask
    extends Task<Void, Void> {
        public SaveTask() {
            super(STControllerImpl.this.context.getSAFContext().getApplication());
            this.setUserCanCancel(false);
        }

        @Override
        protected Void doInBackground() throws Exception {
            STControllerImpl.this.executeSave();
            return null;
        }
    }
}

