/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import de.saring.exerciseviewer.gui.EVContext;
import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STContextImpl;
import de.saring.sportstracker.gui.STController;
import de.saring.sportstracker.gui.STControllerImpl;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.STDocumentImpl;
import de.saring.sportstracker.gui.STView;
import de.saring.sportstracker.gui.STViewImpl;
import de.saring.sportstracker.gui.SportsTracker;
import java.util.EventObject;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import org.jdesktop.application.Application;
import org.jdesktop.application.View;

public class STMain
extends SportsTracker {
    private static final Logger LOGGER = Logger.getLogger(STMain.class.getName());
    private STContext context;
    private STDocument document;
    private STView view;
    private STController controller;
    private String[] cmdLineParameters;

    @Override
    protected void initialize(String[] args) {
        super.initialize(args);
        this.cmdLineParameters = args;
    }

    @Override
    protected void startup() {
        Injector injector = Guice.createInjector(new AbstractModule(){

            @Override
            public void configure() {
                STMain.this.context = new STContextImpl(STMain.this.getContext());
                this.bind(STContext.class).toInstance(STMain.this.context);
                this.bind(EVContext.class).toInstance(STMain.this.context);
                this.bind(STDocument.class).to(STDocumentImpl.class);
                this.bind(STView.class).to(STViewImpl.class);
                this.bind(STController.class).to(STControllerImpl.class);
            }
        });
        this.document = injector.getInstance(STDocument.class);
        this.document.evaluateCommandLineParameters(this.cmdLineParameters);
        this.document.loadOptions();
        this.initLookAndFeel(this.document.getOptions().getLookAndFeelClassName());
        this.controller = injector.getInstance(STController.class);
        this.addExitListener(new Application.ExitListener(){

            @Override
            public boolean canExit(EventObject e) {
                return STMain.this.controller.saveBeforeExit();
            }

            @Override
            public void willExit(EventObject e) {
            }
        });
        this.view = injector.getInstance(STView.class);
        this.view.initView();
        this.show((View)((Object)this.view));
    }

    @Override
    protected void ready() {
        this.view.postInit();
        try {
            this.document.createApplicationDirectory();
        }
        catch (STException se) {
            LOGGER.log(Level.SEVERE, "Failed to create the application directory!", se);
            this.context.showMessageDialog(this.getMainFrame(), 0, "common.error", "st.main.error.create_dir", new Object[0]);
        }
        this.controller.startActionManually("st.view.load");
    }

    @Override
    protected void shutdown() {
        this.document.storeOptions();
        super.shutdown();
    }

    private void initLookAndFeel(String lookAndFeelClassName) {
        if (lookAndFeelClassName == null) {
            lookAndFeelClassName = UIManager.getSystemLookAndFeelClassName();
        }
        try {
            UIManager.setLookAndFeel(lookAndFeelClassName);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to set look&feel to " + lookAndFeelClassName + "!", e);
        }
    }

    public static void main(String[] args) {
        STViewImpl.preInit();
        STMain.launch(STMain.class, args);
    }
}

