/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.ListCellRendererOddEven;
import de.saring.util.gui.ListUtils;
import java.awt.Color;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class SportTypeDialog
extends JDialog {
    private static final String ACTION_SELECT = "st.dlg.sporttype.select";
    private static final String ACTION_ADD_SUBTYPE = "st.dlg.sporttype.add_subtype";
    private static final String ACTION_EDIT_SUBTYPE = "st.dlg.sporttype.edit_subtype";
    private static final String ACTION_DELETE_SUBTYPE = "st.dlg.sporttype.delete_subtype";
    private static final String ACTION_ADD_EQUIPMENT = "st.dlg.sporttype.add_equipment";
    private static final String ACTION_EDIT_EQUIPMENT = "st.dlg.sporttype.edit_equipment";
    private static final String ACTION_DELETE_EQUIPMENT = "st.dlg.sporttype.delete_equipment";
    private static final String ACTION_OK = "st.dlg.sporttype.ok";
    private static final String ACTION_CANCEL = "st.dlg.sporttype.cancel";
    private static final String PROPERTY_SPORTSUBTYPE_SELECTED = "sportSubtypeSelected";
    private static final String PROPERTY_EQUIPMENT_SELECTED = "equipmentSelected";
    private STContext context;
    private STDocument document;
    private SportType sportType;
    private JButton btAddEquipment;
    private JButton btAddSubtype;
    private JButton btCancel;
    private JButton btDeleteEquipment;
    private JButton btDeleteSubtype;
    private JButton btEditEquipment;
    private JButton btEditSubtype;
    private JButton btOK;
    private JButton btSelect;
    private JCheckBox cbDistance;
    private JLabel laColor;
    private JLabel laDistance;
    private JLabel laEquipmentList;
    private JLabel laName;
    private JLabel laProperties;
    private JLabel laSubtypes;
    private JList liEquipment;
    private JList liSubtypes;
    private JSeparator separator;
    private JScrollPane spEquipment;
    private JScrollPane spSubtypes;
    private JTextField tfName;

    @Inject
    public SportTypeDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btOK);
        this.liSubtypes.setCellRenderer(new ListCellRendererOddEven(context.getResReader().getColor("common.table.background_odd"), context.getResReader().getColor("common.table.background_even")));
        this.liEquipment.setCellRenderer(new ListCellRendererOddEven(context.getResReader().getColor("common.table.background_odd"), context.getResReader().getColor("common.table.background_even")));
        ListUtils.increaseListCellHeight(this.liSubtypes);
        ListUtils.increaseListCellHeight(this.liEquipment);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btSelect.setAction(actionMap.get(ACTION_SELECT));
        this.btAddSubtype.setAction(actionMap.get(ACTION_ADD_SUBTYPE));
        this.btEditSubtype.setAction(actionMap.get(ACTION_EDIT_SUBTYPE));
        this.btDeleteSubtype.setAction(actionMap.get(ACTION_DELETE_SUBTYPE));
        this.btAddEquipment.setAction(actionMap.get(ACTION_ADD_EQUIPMENT));
        this.btEditEquipment.setAction(actionMap.get(ACTION_EDIT_EQUIPMENT));
        this.btDeleteEquipment.setAction(actionMap.get(ACTION_DELETE_EQUIPMENT));
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
        this.liSubtypes.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SportTypeDialog.this.firePropertyChange(SportTypeDialog.PROPERTY_SPORTSUBTYPE_SELECTED, true, false);
            }
        });
        this.liEquipment.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SportTypeDialog.this.firePropertyChange(SportTypeDialog.PROPERTY_EQUIPMENT_SELECTED, true, false);
            }
        });
        this.liSubtypes.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SportTypeDialog.this.liSubtypes.getSelectedIndex() != -1) {
                    SportTypeDialog.this.editSportSubtype();
                }
            }
        });
        this.liEquipment.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && SportTypeDialog.this.liEquipment.getSelectedIndex() != -1) {
                    SportTypeDialog.this.editEquipment();
                }
            }
        });
    }

    public void setSportType(SportType sportType) {
        this.sportType = sportType.clone();
        this.tfName.setText(this.sportType.getName());
        this.cbDistance.setSelected(this.sportType.isRecordDistance());
        for (Exercise exercise : this.document.getExerciseList()) {
            if (exercise.getSportType().getId() != this.sportType.getId()) continue;
            this.cbDistance.setEnabled(false);
            break;
        }
        this.btSelect.setForeground(this.sportType.getColor());
        this.updateSportSubtypeList();
        this.updateEquipmentList();
    }

    @Override
    public void setTitle(String title) {
        if (this.sportType.getName() == null) {
            super.setTitle(this.context.getResReader().getString("st.dlg.sporttype.title.add", new Object[0]));
        } else {
            super.setTitle(title);
        }
    }

    private void updateSportSubtypeList() {
        String[] sportSubtypeNames = new String[this.sportType.getSportSubTypeList().size()];
        int i = 0;
        while (i < sportSubtypeNames.length) {
            sportSubtypeNames[i] = this.sportType.getSportSubTypeList().getAt(i).getName();
            ++i;
        }
        this.liSubtypes.setListData(sportSubtypeNames);
    }

    private void updateEquipmentList() {
        String[] equipmentNames = new String[this.sportType.getEquipmentList().size()];
        int i = 0;
        while (i < equipmentNames.length) {
            equipmentNames[i] = this.sportType.getEquipmentList().getAt(i).getName();
            ++i;
        }
        this.liEquipment.setListData(equipmentNames);
    }

    @Action(name="st.dlg.sporttype.select")
    public void selectColor() {
        Color newColor = JColorChooser.showDialog(this, this.context.getResReader().getString("st.dlg.sporttype.colorchooser.title", new Object[0]), this.sportType.getColor());
        if (newColor != null) {
            this.sportType.setColor(newColor);
            this.btSelect.setForeground(newColor);
        }
    }

    @Action(name="st.dlg.sporttype.add_subtype")
    public void addSportSubtype() {
        SportSubType newSubType = new SportSubType(this.sportType.getSportSubTypeList().getNewID());
        this.editSportSubType(newSubType);
    }

    @Action(name="st.dlg.sporttype.edit_subtype", enabledProperty="sportSubtypeSelected")
    public void editSportSubtype() {
        SportSubType subType = this.sportType.getSportSubTypeList().getAt(this.liSubtypes.getSelectedIndex());
        this.editSportSubType(subType);
    }

    @Action(name="st.dlg.sporttype.delete_subtype", enabledProperty="sportSubtypeSelected")
    public void deleteSportSubtype() {
        if (this.context.showConfirmDialog(this, "st.dlg.sporttype.confirm.delete_subtype.title", "st.dlg.sporttype.confirm.delete_subtype.text") != 0) {
            return;
        }
        SportSubType selSubType = this.sportType.getSportSubTypeList().getAt(this.liSubtypes.getSelectedIndex());
        ArrayList<Integer> lRefExerciseIDs = new ArrayList<Integer>();
        for (Exercise exercise : this.document.getExerciseList()) {
            if (exercise.getSportType().getId() != this.sportType.getId() || exercise.getSportSubType().getId() != selSubType.getId()) continue;
            lRefExerciseIDs.add(exercise.getId());
        }
        if (lRefExerciseIDs.size() > 0) {
            if (this.context.showConfirmDialog(this, "st.dlg.sporttype.confirm.delete_subtype.title", "st.dlg.sporttype.confirm.delete_subtype_existing.text") != 0) {
                return;
            }
            Iterator<Object> iterator = lRefExerciseIDs.iterator();
            while (iterator.hasNext()) {
                int refExerciseID = (Integer)iterator.next();
                this.document.getExerciseList().removeByID(refExerciseID);
            }
        }
        this.sportType.getSportSubTypeList().removeByID(selSubType.getId());
        this.updateSportSubtypeList();
    }

    @Action(name="st.dlg.sporttype.add_equipment")
    public void addEquipment() {
        Equipment newEquipment = new Equipment(this.sportType.getEquipmentList().getNewID());
        this.editEquipment(newEquipment);
    }

    @Action(name="st.dlg.sporttype.edit_equipment", enabledProperty="equipmentSelected")
    public void editEquipment() {
        Equipment equipment = this.sportType.getEquipmentList().getAt(this.liEquipment.getSelectedIndex());
        this.editEquipment(equipment);
    }

    @Action(name="st.dlg.sporttype.delete_equipment", enabledProperty="equipmentSelected")
    public void deleteEquipment() {
        if (this.context.showConfirmDialog(this, "st.dlg.sporttype.confirm.delete_equipment.title", "st.dlg.sporttype.confirm.delete_equipment.text") != 0) {
            return;
        }
        Equipment selEquipment = this.sportType.getEquipmentList().getAt(this.liEquipment.getSelectedIndex());
        ArrayList<Integer> lRefExerciseIDs = new ArrayList<Integer>();
        for (Exercise exercise : this.document.getExerciseList()) {
            if (exercise.getSportType().getId() != this.sportType.getId() || exercise.getEquipment() == null || exercise.getEquipment().getId() != selEquipment.getId()) continue;
            lRefExerciseIDs.add(exercise.getId());
        }
        if (lRefExerciseIDs.size() > 0) {
            if (this.context.showConfirmDialog(this, "st.dlg.sporttype.confirm.delete_equipment.title", "st.dlg.sporttype.confirm.delete_equipment_existing.text") != 0) {
                return;
            }
            Iterator<Object> iterator = lRefExerciseIDs.iterator();
            while (iterator.hasNext()) {
                int refExerciseID = (Integer)iterator.next();
                ((Exercise)this.document.getExerciseList().getByID(refExerciseID)).setEquipment(null);
            }
        }
        this.sportType.getEquipmentList().removeByID(selEquipment.getId());
        this.updateEquipmentList();
    }

    @Action(name="st.dlg.sporttype.ok")
    public void ok() {
        String strName = this.tfName.getText().trim();
        if (strName.length() == 0) {
            this.tfName.selectAll();
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.sporttype.error.no_name", new Object[0]);
            this.tfName.requestFocus();
            return;
        }
        for (SportType stTemp : this.document.getSportTypeList()) {
            if (stTemp.getId() == this.sportType.getId() || !stTemp.getName().equals(strName)) continue;
            this.tfName.selectAll();
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.sporttype.error.name_in_use", new Object[0]);
            this.tfName.requestFocus();
            return;
        }
        this.sportType.setName(strName);
        this.sportType.setRecordDistance(this.cbDistance.isSelected());
        if (this.sportType.getSportSubTypeList().size() == 0) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.sporttype.error.no_subtype", new Object[0]);
            return;
        }
        this.document.getSportTypeList().set(this.sportType);
        this.dispose();
    }

    @Action(name="st.dlg.sporttype.cancel")
    public void cancel() {
        this.dispose();
    }

    public boolean isSportSubtypeSelected() {
        return !this.liSubtypes.isSelectionEmpty();
    }

    public boolean isEquipmentSelected() {
        return !this.liEquipment.isSelectionEmpty();
    }

    private void editSportSubType(SportSubType subType) {
        String dlgTitle;
        String strName = subType.getName();
        String string = dlgTitle = strName == null ? "st.dlg.sportsubtype.add.title" : "st.dlg.sportsubtype.edit.title";
        while (true) {
            if ((strName = (String)JOptionPane.showInputDialog(this, this.context.getResReader().getString("st.dlg.sportsubtype.name", new Object[0]), this.context.getResReader().getString(dlgTitle, new Object[0]), 3, null, null, strName)) == null) {
                return;
            }
            if ((strName = strName.trim()).length() == 0) {
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.sportsubtype.error.no_name", new Object[0]);
                continue;
            }
            boolean fInUse = false;
            for (SportSubType sstTemp : this.sportType.getSportSubTypeList()) {
                if (sstTemp.getId() == subType.getId() || !sstTemp.getName().equals(strName)) continue;
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.sportsubtype.error.in_use", new Object[0]);
                fInUse = true;
                break;
            }
            if (!fInUse) break;
        }
        subType.setName(strName);
        this.sportType.getSportSubTypeList().set(subType);
        this.updateSportSubtypeList();
    }

    private void editEquipment(Equipment equipment) {
        String dlgTitle;
        String strName = equipment.getName();
        String string = dlgTitle = strName == null ? "st.dlg.equipment.add.title" : "st.dlg.equipment.edit.title";
        while (true) {
            if ((strName = (String)JOptionPane.showInputDialog(this, this.context.getResReader().getString("st.dlg.equipment.name", new Object[0]), this.context.getResReader().getString(dlgTitle, new Object[0]), 3, null, null, strName)) == null) {
                return;
            }
            if ((strName = strName.trim()).length() == 0) {
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.equipment.error.no_name", new Object[0]);
                continue;
            }
            boolean fInUse = false;
            for (Equipment eqTemp : this.sportType.getEquipmentList()) {
                if (eqTemp.getId() == equipment.getId() || !eqTemp.getName().equals(strName)) continue;
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.equipment.error.in_use", new Object[0]);
                fInUse = true;
                break;
            }
            if (!fInUse) break;
        }
        equipment.setName(strName);
        this.sportType.getEquipmentList().set(equipment);
        this.updateEquipmentList();
    }

    private void initComponents() {
        this.laProperties = new JLabel();
        this.laName = new JLabel();
        this.tfName = new JTextField();
        this.laDistance = new JLabel();
        this.cbDistance = new JCheckBox();
        this.laColor = new JLabel();
        this.btSelect = new JButton();
        this.laSubtypes = new JLabel();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.separator = new JSeparator();
        this.spSubtypes = new JScrollPane();
        this.liSubtypes = new JList();
        this.btAddSubtype = new JButton();
        this.btEditSubtype = new JButton();
        this.btDeleteSubtype = new JButton();
        this.laEquipmentList = new JLabel();
        this.btAddEquipment = new JButton();
        this.btEditEquipment = new JButton();
        this.btDeleteEquipment = new JButton();
        this.spEquipment = new JScrollPane();
        this.liEquipment = new JList();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.sporttype");
        this.setResizable(false);
        this.laProperties.setFont(this.laProperties.getFont().deriveFont(this.laProperties.getFont().getStyle() | 1));
        this.laProperties.setText("_Sport Type Properties");
        this.laProperties.setName("st.dlg.sporttype.properties");
        this.laName.setText("_Name:");
        this.laName.setName("st.dlg.sporttype.name");
        this.laDistance.setText("_Distance:");
        this.laDistance.setName("st.dlg.sporttype.distance");
        this.cbDistance.setText("_Record Distance and Average Speed");
        this.cbDistance.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbDistance.setName("st.dlg.sporttype.record_distance");
        this.laColor.setText("_Color:");
        this.laColor.setName("st.dlg.sporttype.color");
        this.btSelect.setText("_Select");
        this.laSubtypes.setFont(this.laSubtypes.getFont().deriveFont(this.laSubtypes.getFont().getStyle() | 1));
        this.laSubtypes.setText("_Sport Subtype List");
        this.laSubtypes.setName("st.dlg.sporttype.subtypes");
        this.btOK.setText("_OK");
        this.btCancel.setText("_Cancel");
        this.spSubtypes.setVerticalScrollBarPolicy(22);
        this.liSubtypes.setVisibleRowCount(7);
        this.spSubtypes.setViewportView(this.liSubtypes);
        this.btAddSubtype.setText("_Add");
        this.btEditSubtype.setText("_Edit");
        this.btDeleteSubtype.setText("_Delete");
        this.laEquipmentList.setFont(this.laEquipmentList.getFont().deriveFont(this.laEquipmentList.getFont().getStyle() | 1));
        this.laEquipmentList.setText("_Equipment List (Optional)");
        this.laEquipmentList.setName("st.dlg.sporttype.equipment");
        this.btAddEquipment.setText("_Add");
        this.btEditEquipment.setText("_Edit");
        this.btDeleteEquipment.setText("_Delete");
        this.spEquipment.setVerticalScrollBarPolicy(22);
        this.liEquipment.setVisibleRowCount(7);
        this.spEquipment.setViewportView(this.liEquipment);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.laProperties)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laName).addComponent(this.laDistance).addComponent(this.laColor)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfName, -1, 313, Short.MAX_VALUE).addComponent(this.cbDistance).addComponent(this.btSelect))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(292, Short.MAX_VALUE).addComponent(this.btCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btOK)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.spSubtypes, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btAddSubtype).addComponent(this.btEditSubtype).addComponent(this.btDeleteSubtype))).addComponent(this.laSubtypes)))).addContainerGap()).addComponent(this.separator, GroupLayout.Alignment.TRAILING, -1, 434, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laEquipmentList).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.spEquipment, -1, 325, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.btAddEquipment).addComponent(this.btEditEquipment).addComponent(this.btDeleteEquipment)))).addContainerGap()));
        layout.linkSize(0, this.btCancel, this.btOK);
        layout.linkSize(0, this.btAddSubtype, this.btDeleteSubtype, this.btEditSubtype);
        layout.linkSize(0, this.btAddEquipment, this.btDeleteEquipment, this.btEditEquipment);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.laProperties).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laDistance).addComponent(this.cbDistance)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laColor).addComponent(this.btSelect)).addGap(18, 18, 18).addComponent(this.laSubtypes).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btAddSubtype).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btEditSubtype).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btDeleteSubtype)).addComponent(this.spSubtypes, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.laEquipmentList).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btAddEquipment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btEditEquipment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btDeleteEquipment)).addComponent(this.spEquipment, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btOK).addComponent(this.btCancel)).addContainerGap()));
        this.pack();
    }
}

