/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseFilter;
import de.saring.sportstracker.data.statistic.StatisticCalculator;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.dialogs.FilterDialog;
import de.saring.sportstracker.gui.dialogs.StatisticResultsDialog;
import de.saring.util.data.IdDateObjectList;
import de.saring.util.gui.DialogUtils;
import java.awt.Frame;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class StatisticDialog
extends JDialog {
    private STContext context;
    private STDocument document;
    @Inject
    private Provider<FilterDialog> prFilterDialog;
    @Inject
    private Provider<StatisticResultsDialog> prStatisticResultsDialog;
    private ExerciseFilter statFilter;
    private static final String ACTION_CHANGE_FILTER = "st.dlg.statistic.change_filter";
    private static final String ACTION_CALCULATE = "st.dlg.statistic.calculate";
    private static final String ACTION_CLOSE = "st.dlg.statistic.close";
    private JButton btCalculate;
    private JButton btChange;
    private JButton btClose;
    private JLabel laComment;
    private JLabel laCommentValue;
    private JLabel laCurrentFilter;
    private JLabel laEquipment;
    private JLabel laEquipmentValue;
    private JLabel laIntensity;
    private JLabel laIntensityValue;
    private JLabel laSportSubType;
    private JLabel laSportSubTypeValue;
    private JLabel laSportType;
    private JLabel laSportTypeValue;
    private JLabel laTimespan;
    private JLabel laTimespanValue;
    private JSeparator separator;

    @Inject
    public StatisticDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btClose);
        this.btClose.requestFocus();
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btChange.setAction(actionMap.get(ACTION_CHANGE_FILTER));
        this.btCalculate.setAction(actionMap.get(ACTION_CALCULATE));
        javax.swing.Action aClose = actionMap.get(ACTION_CLOSE);
        this.btClose.setAction(aClose);
        DialogUtils.setDialogEscapeKeyAction(this, aClose);
        this.statFilter = document.getCurrentFilter();
        this.setFilterValues();
    }

    private void setFilterValues() {
        DateFormat sdFormat = SimpleDateFormat.getDateInstance(2);
        String strTimeSpan = String.valueOf(sdFormat.format(this.statFilter.getDateStart())) + " - " + sdFormat.format(this.statFilter.getDateEnd());
        String strSportType = this.context.getResReader().getString("st.dlg.statistic.all.text", new Object[0]);
        if (this.statFilter.getSportType() != null) {
            strSportType = this.statFilter.getSportType().getName();
        }
        String strSportSubtype = this.context.getResReader().getString("st.dlg.statistic.all.text", new Object[0]);
        if (this.statFilter.getSportSubType() != null) {
            strSportSubtype = this.statFilter.getSportSubType().getName();
        }
        String strIntensity = this.context.getResReader().getString("st.dlg.statistic.all.text", new Object[0]);
        if (this.statFilter.getIntensity() != null) {
            strIntensity = this.statFilter.getIntensity().toString();
        }
        String strEquipment = this.context.getResReader().getString("st.dlg.statistic.all.text", new Object[0]);
        if (this.statFilter.getEquipment() != null) {
            strEquipment = this.statFilter.getEquipment().getName();
        }
        String strComment = this.context.getResReader().getString("st.dlg.statistic.no_comment.text", new Object[0]);
        if (this.statFilter.getCommentSubString() != null && this.statFilter.getCommentSubString().trim().length() > 0) {
            strComment = this.statFilter.getCommentSubString();
            if (this.statFilter.isRegularExpressionMode()) {
                strComment = String.valueOf(strComment) + " " + this.context.getResReader().getString("st.dlg.statistic.reg_expression.text", new Object[0]);
            }
        }
        this.laTimespanValue.setText(strTimeSpan);
        this.laSportTypeValue.setText(strSportType);
        this.laSportSubTypeValue.setText(strSportSubtype);
        this.laIntensityValue.setText(strIntensity);
        this.laEquipmentValue.setText(strEquipment);
        this.laCommentValue.setText(strComment);
    }

    @Action(name="st.dlg.statistic.change_filter")
    public void changeFilter() {
        FilterDialog dlg = this.prFilterDialog.get();
        dlg.setInitialFilter(this.statFilter);
        this.context.showDialog(dlg);
        if (dlg.getSelectedFilter() != null) {
            this.statFilter = dlg.getSelectedFilter();
            this.setFilterValues();
        }
    }

    @Action(name="st.dlg.statistic.calculate")
    public void calculate() {
        IdDateObjectList<Exercise> lFoundExercises = this.document.getExerciseList().getExercisesForFilter(this.statFilter);
        if (lFoundExercises.size() == 0) {
            this.context.showMessageDialog(this, 1, "common.info", "st.dlg.statistic.info.no_exercises_found", new Object[0]);
            return;
        }
        StatisticCalculator statistic = new StatisticCalculator(lFoundExercises);
        StatisticResultsDialog dlg = this.prStatisticResultsDialog.get();
        dlg.setStatisticResults(statistic);
        this.context.showDialog(dlg);
    }

    @Action(name="st.dlg.statistic.close")
    public void close() {
        this.dispose();
    }

    private void initComponents() {
        this.btClose = new JButton();
        this.btCalculate = new JButton();
        this.laCurrentFilter = new JLabel();
        this.laTimespan = new JLabel();
        this.laSportType = new JLabel();
        this.laSportSubType = new JLabel();
        this.laIntensity = new JLabel();
        this.laComment = new JLabel();
        this.laTimespanValue = new JLabel();
        this.laSportTypeValue = new JLabel();
        this.laSportSubTypeValue = new JLabel();
        this.laIntensityValue = new JLabel();
        this.laCommentValue = new JLabel();
        this.btChange = new JButton();
        this.separator = new JSeparator();
        this.laEquipment = new JLabel();
        this.laEquipmentValue = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.statistic");
        this.setResizable(false);
        this.btClose.setText("_Close");
        this.btClose.setName("btClose");
        this.btCalculate.setText("_Calculate");
        this.btCalculate.setName("btCalculate");
        this.laCurrentFilter.setFont(this.laCurrentFilter.getFont().deriveFont(this.laCurrentFilter.getFont().getStyle() | 1));
        this.laCurrentFilter.setText("_Current Filter");
        this.laCurrentFilter.setName("st.dlg.statistic.current_filter");
        this.laTimespan.setText("_Timespan:");
        this.laTimespan.setName("st.dlg.statistic.timespan");
        this.laSportType.setText("_Sport type:");
        this.laSportType.setName("st.dlg.statistic.sport_type");
        this.laSportSubType.setText("_Sport subtype:");
        this.laSportSubType.setName("st.dlg.statistic.sport_subtype");
        this.laIntensity.setText("_Intensity:");
        this.laIntensity.setName("st.dlg.statistic.intensity");
        this.laComment.setText("_Comment text:");
        this.laComment.setName("st.dlg.statistic.comment");
        this.laTimespanValue.setText("_ - ");
        this.laSportTypeValue.setText("_all");
        this.laSportSubTypeValue.setText("_all");
        this.laIntensityValue.setText("_all");
        this.laCommentValue.setText("_(none)");
        this.btChange.setText("_Change");
        this.btChange.setName("btChange");
        this.separator.setName("separator");
        this.laEquipment.setText("_Equipment:");
        this.laEquipment.setName("st.dlg.statistic.equipment");
        this.laEquipmentValue.setText("_all");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btCalculate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btClose)).addGroup(layout.createSequentialGroup().addComponent(this.laCurrentFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 220, Short.MAX_VALUE).addComponent(this.btChange)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laSportType).addComponent(this.laTimespan).addComponent(this.laSportSubType).addComponent(this.laIntensity).addComponent(this.laComment).addComponent(this.laEquipment)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laEquipmentValue, -1, 261, Short.MAX_VALUE).addComponent(this.laTimespanValue, -1, 261, Short.MAX_VALUE).addComponent(this.laSportTypeValue, -1, 261, Short.MAX_VALUE).addComponent(this.laSportSubTypeValue, -1, 261, Short.MAX_VALUE).addComponent(this.laIntensityValue, -1, 261, Short.MAX_VALUE).addComponent(this.laCommentValue, -2, 261, -2)))).addContainerGap()).addComponent(this.separator, -1, 417, Short.MAX_VALUE));
        layout.linkSize(0, this.btCalculate, this.btClose);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laCurrentFilter).addComponent(this.btChange)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTimespan).addComponent(this.laTimespanValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laSportType).addComponent(this.laSportTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laSportSubType).addComponent(this.laSportSubTypeValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laIntensity).addComponent(this.laIntensityValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laEquipment).addComponent(this.laEquipmentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laComment).addComponent(this.laCommentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btClose).addComponent(this.btCalculate)).addContainerGap()));
        this.pack();
    }
}

