/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.statistic.StatisticCalculator;
import de.saring.sportstracker.gui.STContext;
import de.saring.util.gui.DialogUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Frame;
import java.awt.GridLayout;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.jdesktop.application.ApplicationActionMap;

public class StatisticResultsDialog
extends JDialog {
    private static final String ACTION_CLOSE = "st.dlg.statistic_results.close";
    private STContext context;
    private JButton btClose;
    private JLabel laAverage;
    private JLabel laAvgAscent;
    private JLabel laAvgAscentValue;
    private JLabel laAvgAvgHeartrate;
    private JLabel laAvgAvgHeartrateValue;
    private JLabel laAvgAvgSpeed;
    private JLabel laAvgAvgSpeedValue;
    private JLabel laAvgCalories;
    private JLabel laAvgCaloriesValue;
    private JLabel laAvgDistance;
    private JLabel laAvgDistanceValue;
    private JLabel laAvgDuration;
    private JLabel laAvgDurationValue;
    private JLabel laMaxAscent;
    private JLabel laMaxAscentValue;
    private JLabel laMaxAvgHeartrate;
    private JLabel laMaxAvgHeartrateValue;
    private JLabel laMaxAvgSpeed;
    private JLabel laMaxAvgSpeedValue;
    private JLabel laMaxCalories;
    private JLabel laMaxCaloriesValue;
    private JLabel laMaxDistance;
    private JLabel laMaxDistanceValue;
    private JLabel laMaxDuration;
    private JLabel laMaxDurationValue;
    private JLabel laMaximum;
    private JLabel laMinAscent;
    private JLabel laMinAscentValue;
    private JLabel laMinAvgHeartrate;
    private JLabel laMinAvgHeartrateValue;
    private JLabel laMinAvgSpeed;
    private JLabel laMinAvgSpeedValue;
    private JLabel laMinCalories;
    private JLabel laMinCaloriesValue;
    private JLabel laMinDistance;
    private JLabel laMinDistanceValue;
    private JLabel laMinDuration;
    private JLabel laMinDurationValue;
    private JLabel laMinimum;
    private JLabel laSpacer;
    private JLabel laTotal;
    private JLabel laTotalAscent;
    private JLabel laTotalAscentValue;
    private JLabel laTotalCalories;
    private JLabel laTotalCaloriesValue;
    private JLabel laTotalDistance;
    private JLabel laTotalDistanceValue;
    private JLabel laTotalDuration;
    private JLabel laTotalDurationValue;
    private JLabel laTotalExercises;
    private JLabel laTotalExercisesValue;
    private JPanel pData;
    private JPanel pDataLeft;
    private JPanel pDataRight;
    private JSeparator separator;

    @Inject
    public StatisticResultsDialog(STContext context) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btClose);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        Action aClose = actionMap.get(ACTION_CLOSE);
        this.btClose.setAction(aClose);
        DialogUtils.setDialogEscapeKeyAction(this, aClose);
    }

    public void setStatisticResults(StatisticCalculator statistic) {
        FormatUtils formatUtils = this.context.getFormatUtils();
        this.laTotalExercisesValue.setText(String.valueOf(statistic.getExerciseCount()));
        this.laTotalDistanceValue.setText(formatUtils.distanceToString(statistic.getTotalDistance(), 2));
        this.laTotalDurationValue.setText(String.valueOf(formatUtils.seconds2TimeString(statistic.getTotalDuration())) + " (hh:mm:ss)");
        this.laTotalAscentValue.setText(formatUtils.heightToString(statistic.getTotalAscent()));
        if (statistic.getTotalCalories() > 0) {
            this.laTotalCaloriesValue.setText(formatUtils.caloriesToString(statistic.getTotalCalories()));
        } else {
            this.laTotalCaloriesValue.setText(" ");
        }
        this.laAvgDistanceValue.setText(formatUtils.distanceToString(statistic.getAvgDistance(), 2));
        this.laAvgAvgSpeedValue.setText(formatUtils.speedToString(statistic.getAvgSpeed(), 2));
        this.laAvgDurationValue.setText(String.valueOf(formatUtils.seconds2TimeString(statistic.getAvgDuration())) + " (hh:mm:ss)");
        this.laAvgAscentValue.setText(formatUtils.heightToString(statistic.getAvgAscent()));
        if (statistic.getAvgHeartRate() > 0) {
            this.laAvgAvgHeartrateValue.setText(formatUtils.heartRateToString(statistic.getAvgHeartRate()));
        } else {
            this.laAvgAvgHeartrateValue.setText(" ");
        }
        if (statistic.getAvgCalories() > 0) {
            this.laAvgCaloriesValue.setText(formatUtils.caloriesToString(statistic.getAvgCalories()));
        } else {
            this.laAvgCaloriesValue.setText(" ");
        }
        this.laMinDistanceValue.setText(formatUtils.distanceToString(statistic.getMinDistance(), 2));
        this.laMinAvgSpeedValue.setText(formatUtils.speedToString(statistic.getMinAvgSpeed(), 2));
        this.laMinDurationValue.setText(String.valueOf(formatUtils.seconds2TimeString(statistic.getMinDuration())) + " (hh:mm:ss)");
        this.laMinAscentValue.setText(formatUtils.heightToString(statistic.getMinAscent()));
        if (statistic.getMinAvgHeartRate() > 0) {
            this.laMinAvgHeartrateValue.setText(formatUtils.heartRateToString(statistic.getMinAvgHeartRate()));
        } else {
            this.laMinAvgHeartrateValue.setText(" ");
        }
        if (statistic.getMinCalories() > 0) {
            this.laMinCaloriesValue.setText(formatUtils.caloriesToString(statistic.getMinCalories()));
        } else {
            this.laMinCaloriesValue.setText(" ");
        }
        this.laMaxDistanceValue.setText(formatUtils.distanceToString(statistic.getMaxDistance(), 2));
        this.laMaxAvgSpeedValue.setText(formatUtils.speedToString(statistic.getMaxAvgSpeed(), 2));
        this.laMaxDurationValue.setText(String.valueOf(formatUtils.seconds2TimeString(statistic.getMaxDuration())) + " (hh:mm:ss)");
        this.laMaxAscentValue.setText(formatUtils.heightToString(statistic.getMaxAscent()));
        if (statistic.getMaxAvgHeartRate() > 0) {
            this.laMaxAvgHeartrateValue.setText(formatUtils.heartRateToString(statistic.getMaxAvgHeartRate()));
        } else {
            this.laMaxAvgHeartrateValue.setText(" ");
        }
        if (statistic.getMaxCalories() > 0) {
            this.laMaxCaloriesValue.setText(formatUtils.caloriesToString(statistic.getMaxCalories()));
        } else {
            this.laMaxCaloriesValue.setText(" ");
        }
    }

    @Override
    public void setVisible(boolean fVisible) {
        if (fVisible) {
            this.pack();
        }
        super.setVisible(fVisible);
    }

    @org.jdesktop.application.Action(name="st.dlg.statistic_results.close")
    public void close() {
        this.dispose();
    }

    private void initComponents() {
        this.btClose = new JButton();
        this.pData = new JPanel();
        this.pDataLeft = new JPanel();
        this.laTotal = new JLabel();
        this.laTotalExercises = new JLabel();
        this.laTotalDistance = new JLabel();
        this.laTotalDuration = new JLabel();
        this.laTotalAscent = new JLabel();
        this.laTotalCalories = new JLabel();
        this.laTotalExercisesValue = new JLabel();
        this.laTotalDistanceValue = new JLabel();
        this.laTotalDurationValue = new JLabel();
        this.laTotalAscentValue = new JLabel();
        this.laTotalCaloriesValue = new JLabel();
        this.laSpacer = new JLabel();
        this.laMinimum = new JLabel();
        this.laMinDistance = new JLabel();
        this.laMinAvgSpeed = new JLabel();
        this.laMinDuration = new JLabel();
        this.laMinAscent = new JLabel();
        this.laMinAvgHeartrate = new JLabel();
        this.laMinCalories = new JLabel();
        this.laMinDistanceValue = new JLabel();
        this.laMinAvgSpeedValue = new JLabel();
        this.laMinDurationValue = new JLabel();
        this.laMinAscentValue = new JLabel();
        this.laMinAvgHeartrateValue = new JLabel();
        this.laMinCaloriesValue = new JLabel();
        this.pDataRight = new JPanel();
        this.laAverage = new JLabel();
        this.laAvgDistance = new JLabel();
        this.laAvgAvgSpeed = new JLabel();
        this.laAvgDuration = new JLabel();
        this.laAvgAscent = new JLabel();
        this.laAvgAvgHeartrate = new JLabel();
        this.laAvgCalories = new JLabel();
        this.laAvgDistanceValue = new JLabel();
        this.laAvgAvgSpeedValue = new JLabel();
        this.laAvgDurationValue = new JLabel();
        this.laAvgAscentValue = new JLabel();
        this.laAvgAvgHeartrateValue = new JLabel();
        this.laAvgCaloriesValue = new JLabel();
        this.laMaximum = new JLabel();
        this.laMaxDistance = new JLabel();
        this.laMaxAvgSpeed = new JLabel();
        this.laMaxDuration = new JLabel();
        this.laMaxAscent = new JLabel();
        this.laMaxAvgHeartrate = new JLabel();
        this.laMaxCalories = new JLabel();
        this.laMaxDistanceValue = new JLabel();
        this.laMaxAvgSpeedValue = new JLabel();
        this.laMaxDurationValue = new JLabel();
        this.laMaxAscentValue = new JLabel();
        this.laMaxAvgHeartrateValue = new JLabel();
        this.laMaxCaloriesValue = new JLabel();
        this.separator = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.statistic_results");
        this.setResizable(false);
        this.btClose.setText("_Close");
        this.btClose.setName("btClose");
        this.pData.setName("pData");
        this.pData.setLayout(new GridLayout(1, 2, 30, 20));
        this.pDataLeft.setName("pDataLeft");
        this.laTotal.setFont(this.laTotal.getFont().deriveFont(this.laTotal.getFont().getStyle() | 1));
        this.laTotal.setText("_Total");
        this.laTotal.setName("st.dlg.statistic_results.total");
        this.laTotalExercises.setText("_Exercises:");
        this.laTotalExercises.setName("st.dlg.statistic_results.total_exercises");
        this.laTotalDistance.setText("_Total distance:");
        this.laTotalDistance.setName("st.dlg.statistic_results.total_distance");
        this.laTotalDuration.setText("_Total duration:");
        this.laTotalDuration.setName("st.dlg.statistic_results.total_duration");
        this.laTotalAscent.setText("_Total ascent:");
        this.laTotalAscent.setName("st.dlg.statistic_results.total_ascent");
        this.laTotalCalories.setText("_Calorie cons.:");
        this.laTotalCalories.setName("st.dlg.statistic_results.calories");
        this.laTotalExercisesValue.setText("_n.a.");
        this.laTotalDistanceValue.setText("_n.a.");
        this.laTotalDistanceValue.setName("");
        this.laTotalDurationValue.setText("_n.a.");
        this.laTotalDurationValue.setName("");
        this.laTotalAscentValue.setText("_n.a.");
        this.laTotalAscentValue.setName("");
        this.laTotalCaloriesValue.setText("_n.a.");
        this.laTotalCaloriesValue.setName("");
        this.laSpacer.setText("   ");
        this.laSpacer.setName("laSpacer");
        this.laMinimum.setFont(this.laMinimum.getFont().deriveFont(this.laMinimum.getFont().getStyle() | 1));
        this.laMinimum.setText("_Minimum");
        this.laMinimum.setName("st.dlg.statistic_results.minimum");
        this.laMinDistance.setText("_Distance:");
        this.laMinDistance.setName("st.dlg.statistic_results.distance");
        this.laMinAvgSpeed.setText("_Avg. speed:");
        this.laMinAvgSpeed.setName("st.dlg.statistic_results.avg_speed");
        this.laMinDuration.setText("_Duration:");
        this.laMinDuration.setName("st.dlg.statistic_results.duration");
        this.laMinAscent.setText("_Ascent:");
        this.laMinAscent.setName("st.dlg.statistic_results.ascent");
        this.laMinAvgHeartrate.setText("_Avg. heart rate:");
        this.laMinAvgHeartrate.setName("st.dlg.statistic_results.avg_heartrate");
        this.laMinCalories.setText("_Calorie cons.:");
        this.laMinCalories.setName("st.dlg.statistic_results.calories");
        this.laMinDistanceValue.setText("_n.a.");
        this.laMinDistanceValue.setName("laMinDistanceValue");
        this.laMinAvgSpeedValue.setText("_n.a.");
        this.laMinAvgSpeedValue.setName("laMinAvgSpeedValue");
        this.laMinDurationValue.setText("_n.a.");
        this.laMinDurationValue.setName("laMinDurationValue");
        this.laMinAscentValue.setText("_n.a.");
        this.laMinAscentValue.setName("laMinAscentValue");
        this.laMinAvgHeartrateValue.setText("_n.a.");
        this.laMinAvgHeartrateValue.setName("laMinAvgHeartrateValue");
        this.laMinCaloriesValue.setText("_n.a.");
        this.laMinCaloriesValue.setName("laMinCaloriesValue");
        GroupLayout pDataLeftLayout = new GroupLayout(this.pDataLeft);
        this.pDataLeft.setLayout(pDataLeftLayout);
        pDataLeftLayout.setHorizontalGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataLeftLayout.createSequentialGroup().addContainerGap().addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMinDistance).addComponent(this.laMinAvgSpeed).addComponent(this.laMinDuration).addComponent(this.laMinAscent).addComponent(this.laMinAvgHeartrate).addComponent(this.laMinCalories)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMinDistanceValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMinAvgSpeedValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMinDurationValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMinAscentValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMinAvgHeartrateValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMinCaloriesValue, -1, 126, Short.MAX_VALUE)).addContainerGap()).addGroup(pDataLeftLayout.createSequentialGroup().addComponent(this.laMinimum).addContainerGap(195, Short.MAX_VALUE)).addGroup(pDataLeftLayout.createSequentialGroup().addContainerGap().addComponent(this.laSpacer).addContainerGap(245, Short.MAX_VALUE)).addGroup(pDataLeftLayout.createSequentialGroup().addComponent(this.laTotal).addContainerGap(226, Short.MAX_VALUE)).addGroup(pDataLeftLayout.createSequentialGroup().addContainerGap().addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTotalDistance).addComponent(this.laTotalDuration).addComponent(this.laTotalAscent).addComponent(this.laTotalCalories).addComponent(this.laTotalExercises)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTotalExercisesValue, -1, 133, Short.MAX_VALUE).addComponent(this.laTotalDistanceValue, -1, 133, Short.MAX_VALUE).addComponent(this.laTotalAscentValue, -1, 133, Short.MAX_VALUE).addComponent(this.laTotalCaloriesValue, -1, 133, Short.MAX_VALUE).addComponent(this.laTotalDurationValue, -1, 133, Short.MAX_VALUE)).addGap(12, 12, 12)));
        pDataLeftLayout.setVerticalGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataLeftLayout.createSequentialGroup().addComponent(this.laTotal).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTotalExercisesValue).addComponent(this.laTotalExercises)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalDistance).addComponent(this.laTotalDistanceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalDuration).addComponent(this.laTotalDurationValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalAscent).addComponent(this.laTotalAscentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laTotalCalories).addComponent(this.laTotalCaloriesValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.laSpacer).addGap(18, 18, 18).addComponent(this.laMinimum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinDistance).addComponent(this.laMinDistanceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinAvgSpeed).addComponent(this.laMinAvgSpeedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinDuration).addComponent(this.laMinDurationValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinAscent).addComponent(this.laMinAscentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinAvgHeartrate).addComponent(this.laMinAvgHeartrateValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMinCalories).addComponent(this.laMinCaloriesValue)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pData.add(this.pDataLeft);
        this.pDataRight.setName("pDataRight");
        this.laAverage.setFont(this.laAverage.getFont().deriveFont(this.laAverage.getFont().getStyle() | 1));
        this.laAverage.setText("_Average");
        this.laAverage.setName("st.dlg.statistic_results.average");
        this.laAvgDistance.setText("_Distance:");
        this.laAvgDistance.setName("st.dlg.statistic_results.distance");
        this.laAvgAvgSpeed.setText("_Avg. speed:");
        this.laAvgAvgSpeed.setName("st.dlg.statistic_results.avg_speed");
        this.laAvgDuration.setText("_Duration:");
        this.laAvgDuration.setName("st.dlg.statistic_results.duration");
        this.laAvgAscent.setText("_Ascent:");
        this.laAvgAscent.setName("st.dlg.statistic_results.ascent");
        this.laAvgAvgHeartrate.setText("_Avg. heart rate:");
        this.laAvgAvgHeartrate.setName("st.dlg.statistic_results.avg_heartrate");
        this.laAvgCalories.setText("_Calorie cons.:");
        this.laAvgCalories.setName("st.dlg.statistic_results.calories");
        this.laAvgDistanceValue.setText("_n.a.");
        this.laAvgDistanceValue.setName("laAvgDistanceValue");
        this.laAvgAvgSpeedValue.setText("_n.a.");
        this.laAvgAvgSpeedValue.setName("laAvgAvgSpeedValue");
        this.laAvgDurationValue.setText("_n.a.");
        this.laAvgDurationValue.setName("laAvgDurationValue");
        this.laAvgAscentValue.setText("_n.a.");
        this.laAvgAscentValue.setName("laAvgAscentValue");
        this.laAvgAvgHeartrateValue.setText("_n.a.");
        this.laAvgAvgHeartrateValue.setName("laAvgAvgHeartrateValue");
        this.laAvgCaloriesValue.setText("_n.a.");
        this.laAvgCaloriesValue.setName("laAvgCaloriesValue");
        this.laMaximum.setFont(this.laMaximum.getFont().deriveFont(this.laMaximum.getFont().getStyle() | 1));
        this.laMaximum.setText("_Maximum");
        this.laMaximum.setName("st.dlg.statistic_results.maximum");
        this.laMaxDistance.setText("_Distance:");
        this.laMaxDistance.setName("st.dlg.statistic_results.distance");
        this.laMaxAvgSpeed.setText("_Avg. speed:");
        this.laMaxAvgSpeed.setName("st.dlg.statistic_results.avg_speed");
        this.laMaxDuration.setText("_Duration:");
        this.laMaxDuration.setName("st.dlg.statistic_results.duration");
        this.laMaxAscent.setText("_Ascent:");
        this.laMaxAscent.setName("st.dlg.statistic_results.ascent");
        this.laMaxAvgHeartrate.setText("_Avg. heart rate:");
        this.laMaxAvgHeartrate.setName("st.dlg.statistic_results.avg_heartrate");
        this.laMaxCalories.setText("_Calorie cons.:");
        this.laMaxCalories.setName("st.dlg.statistic_results.calories");
        this.laMaxDistanceValue.setText("_n.a.");
        this.laMaxDistanceValue.setName("laMaxDistanceValue");
        this.laMaxAvgSpeedValue.setText("_n.a.");
        this.laMaxAvgSpeedValue.setName("laMaxAvgSpeedValue");
        this.laMaxDurationValue.setText("_n.a.");
        this.laMaxDurationValue.setName("laMaxDurationValue");
        this.laMaxAscentValue.setText("_n.a.");
        this.laMaxAscentValue.setName("laMaxAscentValue");
        this.laMaxAvgHeartrateValue.setText("_n.a.");
        this.laMaxAvgHeartrateValue.setName("laMaxAvgHeartrateValue");
        this.laMaxCaloriesValue.setText("_n.a.");
        this.laMaxCaloriesValue.setName("laMaxCaloriesValue");
        GroupLayout pDataRightLayout = new GroupLayout(this.pDataRight);
        this.pDataRight.setLayout(pDataRightLayout);
        pDataRightLayout.setHorizontalGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataRightLayout.createSequentialGroup().addContainerGap().addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMaxDistance).addComponent(this.laMaxAvgSpeed).addComponent(this.laMaxDuration).addComponent(this.laMaxAscent).addComponent(this.laMaxAvgHeartrate).addComponent(this.laMaxCalories)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laMaxDistanceValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMaxAvgSpeedValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMaxDurationValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMaxAscentValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMaxAvgHeartrateValue, -1, 126, Short.MAX_VALUE).addComponent(this.laMaxCaloriesValue, -1, 126, Short.MAX_VALUE)).addContainerGap()).addGroup(pDataRightLayout.createSequentialGroup().addComponent(this.laMaximum).addContainerGap(191, Short.MAX_VALUE)).addGroup(pDataRightLayout.createSequentialGroup().addComponent(this.laAverage).addContainerGap(201, Short.MAX_VALUE)).addGroup(pDataRightLayout.createSequentialGroup().addContainerGap().addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAvgDistance).addComponent(this.laAvgAvgSpeed).addComponent(this.laAvgDuration).addComponent(this.laAvgAscent).addComponent(this.laAvgAvgHeartrate).addComponent(this.laAvgCalories)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laAvgDistanceValue, -1, 126, Short.MAX_VALUE).addComponent(this.laAvgAvgSpeedValue, -1, 126, Short.MAX_VALUE).addComponent(this.laAvgDurationValue, -1, 126, Short.MAX_VALUE).addComponent(this.laAvgAscentValue, -1, 126, Short.MAX_VALUE).addComponent(this.laAvgAvgHeartrateValue, -1, 126, Short.MAX_VALUE).addComponent(this.laAvgCaloriesValue, -1, 126, Short.MAX_VALUE)).addGap(12, 12, 12)));
        pDataRightLayout.setVerticalGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataRightLayout.createSequentialGroup().addComponent(this.laAverage).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgDistance).addComponent(this.laAvgDistanceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgAvgSpeed).addComponent(this.laAvgAvgSpeedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgDuration).addComponent(this.laAvgDurationValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgAscent).addComponent(this.laAvgAscentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgAvgHeartrate).addComponent(this.laAvgAvgHeartrateValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laAvgCalories).addComponent(this.laAvgCaloriesValue)).addGap(18, 18, 18).addComponent(this.laMaximum).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxDistance).addComponent(this.laMaxDistanceValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxAvgSpeed).addComponent(this.laMaxAvgSpeedValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxDuration).addComponent(this.laMaxDurationValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxAscent).addComponent(this.laMaxAscentValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxAvgHeartrate).addComponent(this.laMaxAvgHeartrateValue)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laMaxCalories).addComponent(this.laMaxCaloriesValue)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pData.add(this.pDataRight);
        this.separator.setName("separator");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.separator, -1, 593, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.pData, GroupLayout.Alignment.LEADING, -1, 569, Short.MAX_VALUE).addComponent(this.btClose)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.pData, -1, 338, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btClose).addContainerGap()));
        this.pack();
    }
}

