/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.calendarview;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.data.Weight;
import de.saring.sportstracker.gui.views.BaseView;
import de.saring.sportstracker.gui.views.calendarview.CalendarDay;
import de.saring.sportstracker.gui.views.calendarview.CalendarEntry;
import de.saring.sportstracker.gui.views.calendarview.CalendarWidget;
import de.saring.util.data.IdDateObject;
import de.saring.util.data.IdDateObjectList;
import de.saring.util.gui.RolloverButton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Calendar;
import java.util.Date;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

@Singleton
public class CalendarView
extends BaseView {
    private static final String ACTION_PREVIOUS_MONTH = "st.calview.previousMonth";
    private static final String ACTION_NEXT_MONTH = "st.calview.nextMonth";
    private static final String ACTION_PREVIOUS_YEAR = "st.calview.previousYear";
    private static final String ACTION_NEXT_YEAR = "st.calview.nextYear";
    private static final String ACTION_TODAY = "st.calview.today";
    private CalendarWidget calendarWidget;
    private String[] arMonthNames;
    private int currentMonth;
    private int currentYear;
    private CalendarPopupMenu popupMenu;
    private RolloverButton btNextMonth;
    private RolloverButton btNextYear;
    private RolloverButton btPreviousMonth;
    private RolloverButton btPreviousYear;
    private RolloverButton btToday;
    private JLabel laMonth;
    private JLabel laYear;
    private JPanel paCalendar;

    @Inject
    public CalendarView(CalendarWidget calendarWidget) {
        this.calendarWidget = calendarWidget;
    }

    @Override
    public void initView() {
        this.initComponents();
        this.arMonthNames = new String[12];
        int i = 0;
        while (i < 12) {
            this.arMonthNames[i] = this.getContext().getResReader().getString("st.calview.months." + (i + 1), new Object[0]);
            ++i;
        }
        Calendar calToday = Calendar.getInstance();
        this.currentMonth = calToday.get(2) + 1;
        this.currentYear = calToday.get(1);
        ApplicationActionMap actionMap = this.getContext().getSAFContext().getActionMap(this.getClass(), this);
        this.btPreviousMonth.setAction(actionMap.get(ACTION_PREVIOUS_MONTH));
        this.btNextMonth.setAction(actionMap.get(ACTION_NEXT_MONTH));
        this.btPreviousYear.setAction(actionMap.get(ACTION_PREVIOUS_YEAR));
        this.btNextYear.setAction(actionMap.get(ACTION_NEXT_YEAR));
        this.btToday.setAction(actionMap.get(ACTION_TODAY));
        this.paCalendar.add((Component)this.calendarWidget, "Center");
        this.popupMenu = new CalendarPopupMenu();
        this.popupMenu.add(this.getController().getActionMap().get("st.view.exercise_add"));
        this.popupMenu.add(this.getController().getActionMap().get("st.view.note_add"));
        this.popupMenu.add(this.getController().getActionMap().get("st.view.weight_add"));
        this.popupMenu.add(this.getController().getActionMap().get("st.view.entry_delete"));
        this.popupMenu.add(this.getController().getActionMap().get("st.view.entry_edit"));
        this.calendarWidget.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                CalendarView.this.onCalendarClicked(me);
            }
        });
        this.calendarWidget.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                if (mwe.getWheelRotation() < 0) {
                    CalendarView.this.displayPreviousMonth();
                }
                if (mwe.getWheelRotation() > 0) {
                    CalendarView.this.displayNextMonth();
                }
            }
        });
    }

    @Override
    public void updateView() {
        this.updateCalendar();
    }

    @Override
    public int getSelectedExerciseCount() {
        return this.getSelectedExerciseIDs().length;
    }

    @Override
    public int[] getSelectedExerciseIDs() {
        return this.getSelectedEntryIDsOfClass(Exercise.class);
    }

    @Override
    public int getSelectedNoteCount() {
        return this.getSelectedNoteIDs().length;
    }

    @Override
    public int[] getSelectedNoteIDs() {
        return this.getSelectedEntryIDsOfClass(Note.class);
    }

    @Override
    public int getSelectedWeightCount() {
        return this.getSelectedWeightIDs().length;
    }

    @Override
    public int[] getSelectedWeightIDs() {
        return this.getSelectedEntryIDsOfClass(Weight.class);
    }

    private int[] getSelectedEntryIDsOfClass(Class<? extends IdDateObject> clazz) {
        CalendarEntry selectedCalendarEntry = this.calendarWidget.getSelectedCalendarEntry();
        if (selectedCalendarEntry == null || selectedCalendarEntry.getEntry().getClass() != clazz) {
            return new int[0];
        }
        return new int[]{selectedCalendarEntry.getEntry().getId()};
    }

    @Override
    public void removeSelection() {
        this.calendarWidget.removeSelection();
        this.getView().updateEntryActions();
    }

    @Action(name="st.calview.previousMonth")
    public void displayPreviousMonth() {
        if (this.currentMonth > 1) {
            --this.currentMonth;
        } else {
            this.currentMonth = 12;
            --this.currentYear;
        }
        this.removeSelection();
        this.updateCalendar();
    }

    @Action(name="st.calview.nextMonth")
    public void displayNextMonth() {
        if (this.currentMonth < 12) {
            ++this.currentMonth;
        } else {
            this.currentMonth = 1;
            ++this.currentYear;
        }
        this.removeSelection();
        this.updateCalendar();
    }

    @Action(name="st.calview.previousYear")
    public void displayPreviousYear() {
        --this.currentYear;
        this.removeSelection();
        this.updateCalendar();
    }

    @Action(name="st.calview.nextYear")
    public void displayNextYear() {
        ++this.currentYear;
        this.removeSelection();
        this.updateCalendar();
    }

    @Action(name="st.calview.today")
    public void selectToday() {
        Calendar calToday = Calendar.getInstance();
        this.currentMonth = calToday.get(2) + 1;
        this.currentYear = calToday.get(1);
        this.updateCalendar();
    }

    private void updateCalendar() {
        this.laMonth.setText(this.arMonthNames[this.currentMonth - 1]);
        this.laYear.setText(String.valueOf(this.currentYear));
        Calendar cMonthStart = Calendar.getInstance();
        cMonthStart.clear();
        boolean isWeekStartSunday = this.getDocument().getOptions().isWeekStartSunday();
        cMonthStart.setFirstDayOfWeek(isWeekStartSunday ? 1 : 2);
        cMonthStart.set(this.currentYear, this.currentMonth - 1, 1, 0, 0, 0);
        Calendar cCalendarStart = (Calendar)cMonthStart.clone();
        if (isWeekStartSunday) {
            switch (cMonthStart.get(7)) {
                case 2: {
                    cCalendarStart.add(5, -1);
                    break;
                }
                case 3: {
                    cCalendarStart.add(5, -2);
                    break;
                }
                case 4: {
                    cCalendarStart.add(5, -3);
                    break;
                }
                case 5: {
                    cCalendarStart.add(5, -4);
                    break;
                }
                case 6: {
                    cCalendarStart.add(5, -5);
                    break;
                }
                case 7: {
                    cCalendarStart.add(5, -6);
                }
            }
        } else {
            switch (cMonthStart.get(7)) {
                case 3: {
                    cCalendarStart.add(5, -1);
                    break;
                }
                case 4: {
                    cCalendarStart.add(5, -2);
                    break;
                }
                case 5: {
                    cCalendarStart.add(5, -3);
                    break;
                }
                case 6: {
                    cCalendarStart.add(5, -4);
                    break;
                }
                case 7: {
                    cCalendarStart.add(5, -5);
                    break;
                }
                case 1: {
                    cCalendarStart.add(5, -6);
                }
            }
        }
        CalendarDay[] arCalendarDays = new CalendarDay[42];
        int i = 0;
        while (i < arCalendarDays.length) {
            Calendar cTemp = (Calendar)cCalendarStart.clone();
            cTemp.add(5, i);
            arCalendarDays[i] = new CalendarDay(cTemp);
            ++i;
        }
        this.setEntriesInCalendarDays(arCalendarDays, this.getDocument().getNoteList());
        this.setEntriesInCalendarDays(arCalendarDays, this.getDocument().getWeightList());
        this.setEntriesInCalendarDays(arCalendarDays, this.getView().getDisplayedExercises());
        this.calendarWidget.setCalendarDays(arCalendarDays, this.currentMonth, this.currentYear);
        this.calendarWidget.repaint();
    }

    private void setEntriesInCalendarDays(CalendarDay[] arCalendarDays, IdDateObjectList<? extends IdDateObject> dateObjectList) {
        Date calendarStart = arCalendarDays[0].getDate().getTime();
        for (IdDateObject idDateObject : dateObjectList) {
            int diffDays;
            long diffMillis = idDateObject.getDate().getTime() - calendarStart.getTime();
            if (diffMillis < 0L || (diffDays = (int)(diffMillis / 86400000L)) >= arCalendarDays.length) continue;
            CalendarEntry tempEntry = new CalendarEntry(idDateObject);
            arCalendarDays[diffDays].getCalendarEntries().add(tempEntry);
        }
    }

    private void onCalendarClicked(MouseEvent me) {
        CalendarDay calDay = this.calendarWidget.getCalendarDayForPoint(me.getPoint());
        if (calDay == null) {
            return;
        }
        this.getController().setDateForNewEntries(calDay.getDate().getTime());
        if (me.getButton() == 1) {
            if (me.getClickCount() == 1) {
                this.selectCelendarWidgetEntryAtPoint(me.getPoint());
            } else if (me.getClickCount() == 2) {
                if (this.getSelectedExerciseCount() > 0 || this.getSelectedNoteCount() > 0 || this.getSelectedWeightCount() > 0) {
                    this.getController().editEntry();
                } else {
                    this.getController().addExercise();
                }
            }
            this.getController().setDateForNewEntries(null);
        } else if (me.getButton() == 3) {
            this.selectCelendarWidgetEntryAtPoint(me.getPoint());
            this.popupMenu.show(this.calendarWidget, me.getX(), me.getY());
        }
    }

    private void selectCelendarWidgetEntryAtPoint(Point point) {
        this.calendarWidget.selectCalendarEntryAtPoint(point);
        this.getView().updateEntryActions();
    }

    @Override
    public void print() throws STException {
        PrinterJob job = PrinterJob.getPrinterJob();
        job.setPrintable(new Printable(){

            @Override
            public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
                if (pageIndex > 0) {
                    return 1;
                }
                CalendarView.this.printPageContent((Graphics2D)graphics, pageFormat);
                return 0;
            }
        });
        HashPrintRequestAttributeSet praSet = new HashPrintRequestAttributeSet();
        praSet.add(OrientationRequested.LANDSCAPE);
        if (job.printDialog(praSet)) {
            try {
                job.print(praSet);
            }
            catch (PrinterException e) {
                throw new STException(STExceptionID.GUI_PRINT_VIEW_FAILED, "Failed to print the calendar view ...", e);
            }
        }
    }

    private void printPageContent(Graphics2D g2, PageFormat pageFormat) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY() + 45.0);
        double scale = this.calculateScaleFactor(pageFormat, 45);
        g2.scale(scale, scale);
        this.calendarWidget.paint(g2);
        g2.setColor(Color.BLACK);
        g2.setFont(new Font("Dialog", 1, (int)Math.round(15.0 / scale)));
        g2.drawString(this.getPrintPageTitle(), 0.0f, -((float)(22.0 / scale)));
    }

    private double calculateScaleFactor(PageFormat pageFormat, int titleHeight) {
        double calWidth = this.calendarWidget.getSize().width + 10;
        double calHeight = this.calendarWidget.getSize().height + titleHeight + 10;
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        double scaleX = pageWidth / calWidth;
        double scaleY = pageHeight / calHeight;
        return Math.min(scaleX, scaleY);
    }

    private String getPrintPageTitle() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getContext().getResReader().getString("st.calview.print.title", new Object[0]));
        sb.append(" - ");
        sb.append(this.laMonth.getText());
        sb.append(" ");
        sb.append(this.laYear.getText());
        return sb.toString();
    }

    private void initComponents() {
        this.btPreviousMonth = new RolloverButton();
        this.laMonth = new JLabel();
        this.btNextMonth = new RolloverButton();
        this.btToday = new RolloverButton();
        this.btPreviousYear = new RolloverButton();
        this.laYear = new JLabel();
        this.btNextYear = new RolloverButton();
        this.paCalendar = new JPanel();
        this.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 10));
        this.btPreviousMonth.setText("_PM");
        this.laMonth.setHorizontalAlignment(0);
        this.laMonth.setText("_Month");
        this.laMonth.setHorizontalTextPosition(0);
        this.btNextMonth.setText("_NM");
        this.btToday.setText("_TD");
        this.btPreviousYear.setText("_PY");
        this.laYear.setHorizontalAlignment(0);
        this.laYear.setText("_Year");
        this.btNextYear.setText("_NY");
        this.paCalendar.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btPreviousMonth, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.laMonth, -2, 100, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btNextMonth, -2, -1, -2).addGap(50, 50, 50).addComponent(this.btPreviousYear, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.laYear, -2, 50, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.btNextYear, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 101, Short.MAX_VALUE).addComponent(this.btToday, -2, -1, -2)).addComponent(this.paCalendar, -1, 533, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.btNextMonth, -2, -1, -2).addComponent(this.laMonth).addComponent(this.btPreviousMonth, -2, -1, -2).addComponent(this.btPreviousYear, -2, -1, -2).addComponent(this.laYear).addComponent(this.btNextYear, -2, -1, -2).addComponent(this.btToday, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.paCalendar, -1, 296, Short.MAX_VALUE)));
        layout.linkSize(1, this.laMonth, this.laYear);
    }

    class CalendarPopupMenu
    extends JPopupMenu {
        CalendarPopupMenu() {
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            if (!visible) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CalendarView.this.getController().setDateForNewEntries(null);
                    }
                });
            }
        }
    }
}

