/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.listview;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.gui.views.listview.BaseListView;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import javax.inject.Singleton;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

@Singleton
public class ExerciseListView
extends BaseListView {
    private static final int MAX_COLUMN_COUNT = 12;
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_TYPE = 1;
    private static final int COLUMN_SUBTYPE = 2;
    private static final int COLUMN_DURATION = 3;
    private static final int COLUMN_INTENSITY = 4;
    private static final int COLUMN_DISTANCE = 5;
    private static final int COLUMN_AVG_SPEED = 6;
    private static final int COLUMN_AVG_HEARTRATE = 7;
    private static final int COLUMN_ASCENT = 8;
    private static final int COLUMN_ENERGY = 9;
    private static final int COLUMN_EQUIPMENT = 10;
    private static final int COLUMN_COMMENT = 11;
    private static final int HIDDEN_COLUMN_ID = 99;
    private String[] columnNames;
    private ArrayList<TableColumn> removedColumns;
    private ExercisesTableModel tmExercises;

    @Override
    public void initView() {
        this.columnNames = new String[12];
        this.columnNames[0] = this.getContext().getResReader().getString("st.exerciselistview.date", new Object[0]);
        this.columnNames[1] = this.getContext().getResReader().getString("st.exerciselistview.type", new Object[0]);
        this.columnNames[2] = this.getContext().getResReader().getString("st.exerciselistview.subtype", new Object[0]);
        this.columnNames[3] = this.getContext().getResReader().getString("st.exerciselistview.duration", new Object[0]);
        this.columnNames[4] = this.getContext().getResReader().getString("st.exerciselistview.intensity", new Object[0]);
        this.columnNames[5] = this.getContext().getResReader().getString("st.exerciselistview.distance", new Object[0]);
        this.columnNames[6] = this.getContext().getResReader().getString("st.exerciselistview.avg_speed", new Object[0]);
        this.columnNames[7] = this.getContext().getResReader().getString("st.exerciselistview.avg_heartrate", new Object[0]);
        this.columnNames[8] = this.getContext().getResReader().getString("st.exerciselistview.ascent", new Object[0]);
        this.columnNames[9] = this.getContext().getResReader().getString("st.exerciselistview.energy", new Object[0]);
        this.columnNames[10] = this.getContext().getResReader().getString("st.exerciselistview.equipment", new Object[0]);
        this.columnNames[11] = this.getContext().getResReader().getString("st.exerciselistview.comment", new Object[0]);
        this.tmExercises = new ExercisesTableModel();
        this.createTable();
        this.getTable().getTableHeader().setReorderingAllowed(true);
        this.getTable().setAutoResizeMode(0);
        TableColumnModel tcModel = this.getTable().getColumnModel();
        tcModel.getColumn(0).setPreferredWidth(90);
        tcModel.getColumn(1).setPreferredWidth(100);
        tcModel.getColumn(2).setPreferredWidth(100);
        tcModel.getColumn(3).setPreferredWidth(80);
        tcModel.getColumn(4).setPreferredWidth(90);
        tcModel.getColumn(5).setPreferredWidth(90);
        tcModel.getColumn(6).setPreferredWidth(90);
        tcModel.getColumn(7).setPreferredWidth(90);
        tcModel.getColumn(8).setPreferredWidth(90);
        tcModel.getColumn(9).setPreferredWidth(90);
        tcModel.getColumn(10).setPreferredWidth(90);
        tcModel.getColumn(11).setPreferredWidth(500);
        this.removedColumns = new ArrayList();
    }

    @Override
    public void updateView() {
        this.addOrRemoveColumn(7, this.getDocument().getOptions().isListViewShowAvgHeartrate());
        this.addOrRemoveColumn(8, this.getDocument().getOptions().isListViewShowAscent());
        this.addOrRemoveColumn(9, this.getDocument().getOptions().isListViewShowEnergy());
        this.addOrRemoveColumn(10, this.getDocument().getOptions().isListViewShowEquipment());
        this.addOrRemoveColumn(11, this.getDocument().getOptions().isListViewShowComment());
        super.updateView();
    }

    private void addOrRemoveColumn(int columnIndex, boolean addOrRemove) {
        if (addOrRemove) {
            this.addColumnByIndex(columnIndex);
        } else {
            this.removeColumnByIndex(columnIndex);
        }
    }

    private void removeColumnByIndex(int index) {
        try {
            TableColumn column = this.getTable().getColumn(this.columnNames[index]);
            this.removedColumns.add(column);
            this.getTable().removeColumn(column);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    /*
     * Unable to fully structure code
     */
    private void addColumnByIndex(int index) {
        try {
            this.getTable().getColumn(this.columnNames[index]);
            return;
        }
        catch (IllegalArgumentException v0) {
            ** for (removedColumn : this.removedColumns)
        }
lbl-1000:
        // 1 sources

        {
            if (!removedColumn.getIdentifier().equals(this.columnNames[index])) continue;
            newColumnIndex = this.getTable().getColumnCount();
            i = 0;
            while (i < this.getTable().getColumnCount()) {
                tempColumnName = this.getTable().getColumnName(i);
                if (this.getIndexForColumnName(tempColumnName) > index) {
                    newColumnIndex = i;
                    break;
                }
                ++i;
            }
            this.getTable().addColumn(removedColumn);
            this.getTable().moveColumn(this.getTable().getColumnCount() - 1, newColumnIndex);
            this.removedColumns.remove(removedColumn);
            return;
        }
lbl22:
        // 1 sources

    }

    private int getIndexForColumnName(String columnName) {
        int i = 0;
        while (i < this.columnNames.length) {
            if (columnName.equals(this.columnNames[i])) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("Unknown column name: " + columnName);
    }

    @Override
    protected String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    protected AbstractTableModel getTableModel() {
        return this.tmExercises;
    }

    @Override
    protected DefaultTableCellRenderer getTableCellRender() {
        return new ExercisesCellRenderer();
    }

    @Override
    public int getSelectedExerciseCount() {
        return this.getTable().getSelectedRowCount();
    }

    @Override
    public int[] getSelectedExerciseIDs() {
        int[] selectedRows = this.getTable().getSelectedRows();
        int[] selectedIDs = new int[selectedRows.length];
        int i = 0;
        while (i < selectedIDs.length) {
            int modelRow = this.getTable().convertRowIndexToModel(selectedRows[i]);
            selectedIDs[i] = (Integer)this.tmExercises.getValueAt(modelRow, 99);
            ++i;
        }
        return selectedIDs;
    }

    @Override
    public void print() throws STException {
        if (!this.getController().checkForExistingExercises()) {
            return;
        }
        if (this.getTable().getRowCount() > 100 && this.getContext().showConfirmDialog(this.getContext().getMainFrame(), "st.exerciselistview.confirm.print_many_exercises.title", "st.exerciselistview.confirm.print_many_exercises.text") != 0) {
            return;
        }
        this.printList(this.getContext().getResReader().getString("st.exerciselistview.print.title", new Object[0]), this.getContext().getResReader().getString("st.exerciselistview.print.page", new Object[0]));
    }

    class ExercisesCellRenderer
    extends BaseListView.BaseListCellRenderer {
        ExercisesCellRenderer() {
            super(ExerciseListView.this);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            int modelRow = ExerciseListView.this.getTable().convertRowIndexToModel(rowIndex);
            Exercise exercise = (Exercise)ExerciseListView.this.getView().getDisplayedExercises().getAt(modelRow);
            this.setForeground(exercise.getSportType().getColor());
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
        }

        @Override
        protected String formatText(Object value, int rowIndex, int columnIndex) {
            String colName = ExerciseListView.this.getTable().getColumnName(columnIndex);
            FormatUtils formatUtils = ExerciseListView.this.getContext().getFormatUtils();
            if (colName.equals(ExerciseListView.this.columnNames[3])) {
                return formatUtils.seconds2TimeString((Integer)value);
            }
            if (colName.equals(ExerciseListView.this.columnNames[5])) {
                return formatUtils.distanceToString(((Float)value).floatValue(), 2);
            }
            if (colName.equals(ExerciseListView.this.columnNames[6])) {
                return formatUtils.speedToString(((Float)value).floatValue(), 2);
            }
            if (colName.equals(ExerciseListView.this.columnNames[7])) {
                return formatUtils.heartRateToString((Integer)value);
            }
            if (colName.equals(ExerciseListView.this.columnNames[8])) {
                return formatUtils.heightToString((Integer)value);
            }
            if (colName.equals(ExerciseListView.this.columnNames[9])) {
                return formatUtils.caloriesToString((Integer)value);
            }
            return super.formatText(value, rowIndex, columnIndex);
        }
    }

    class ExercisesTableModel
    extends BaseListView.BaseListTableModel {
        ExercisesTableModel() {
            super(ExerciseListView.this);
        }

        @Override
        public int getRowCount() {
            return ExerciseListView.this.getView().getDisplayedExercises().size();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Date.class;
                }
                case 3: 
                case 7: 
                case 8: 
                case 9: {
                    return Integer.class;
                }
                case 4: {
                    return Exercise.IntensityType.class;
                }
                case 5: {
                    return Float.class;
                }
                case 6: {
                    return Float.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Exercise exercise = (Exercise)ExerciseListView.this.getView().getDisplayedExercises().getAt(row);
            switch (col) {
                case 0: {
                    return exercise.getDate();
                }
                case 1: {
                    return exercise.getSportType().getName();
                }
                case 2: {
                    return exercise.getSportSubType().getName();
                }
                case 3: {
                    return exercise.getDuration();
                }
                case 4: {
                    return exercise.getIntensity();
                }
                case 5: {
                    return Float.valueOf(exercise.getDistance());
                }
                case 6: {
                    return Float.valueOf(exercise.getAvgSpeed());
                }
                case 7: {
                    return exercise.getAvgHeartRate();
                }
                case 11: {
                    return exercise.getComment();
                }
                case 8: {
                    return exercise.getAscent();
                }
                case 9: {
                    return exercise.getCalories();
                }
                case 10: {
                    return exercise.getEquipment() != null ? exercise.getEquipment().getName() : null;
                }
                case 99: {
                    return exercise.getId();
                }
            }
            return null;
        }
    }
}

