/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.storage;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseList;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.storage.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class XMLExerciseList {
    private static final String XSD_EXERCISES = "exercises.xsd";
    private SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public ExerciseList readExerciseList(String source, SportTypeList sportTypeList) throws STException {
        try {
            ExerciseList exerciseList = new ExerciseList();
            File fSource = new File(source);
            if (!fSource.exists()) {
                return exerciseList;
            }
            Document document = XMLUtils.getJDOMDocument(fSource, XSD_EXERCISES);
            Element eExerciseList = document.getRootElement();
            List lExercises = eExerciseList.getChildren("exercise");
            for (Element eExercise : lExercises) {
                Exercise exercise = this.readExercise(eExercise, sportTypeList);
                exerciseList.set(exercise);
            }
            return exerciseList;
        }
        catch (Exception e) {
            throw new STException(STExceptionID.XMLSTORAGE_READ_EXERCISE_LIST, "Failed to read exercise list from XML file '" + source + "' ...", e);
        }
    }

    private Exercise readExercise(Element eExercise, SportTypeList sportTypeList) throws Exception {
        String strCalories;
        String strAscent;
        Exercise exercise = new Exercise(Integer.parseInt(eExercise.getChildText("id")));
        int sportTypeID = Integer.parseInt(eExercise.getChildText("sport-type-id"));
        SportType sportType = (SportType)sportTypeList.getByID(sportTypeID);
        if (sportType == null) {
            throw new Exception("Failed to parse exercise with ID '" + exercise.getId() + "', the sport type ID '" + sportTypeID + "' is unknown!");
        }
        exercise.setSportType(sportType);
        int sportSubTypeID = Integer.parseInt(eExercise.getChildText("sport-subtype-id"));
        SportSubType sportSubType = sportType.getSportSubTypeList().getByID(sportSubTypeID);
        if (sportSubType == null) {
            throw new Exception("Failed to parse exercise with ID '" + exercise.getId() + "', the sport subtype ID '" + sportSubTypeID + "' is unknown!");
        }
        exercise.setSportSubType(sportSubType);
        String strDate = eExercise.getChildText("date");
        try {
            exercise.setDate(this.sdFormat.parse(strDate));
        }
        catch (Exception exception) {
            throw new Exception("Failed to parse exercise with ID '" + exercise.getId() + "', the date format '" + strDate + "' is not valid!");
        }
        exercise.setDuration(Integer.parseInt(eExercise.getChildText("duration")));
        exercise.setDistance(Float.parseFloat(eExercise.getChildText("distance")));
        exercise.setAvgSpeed(Float.parseFloat(eExercise.getChildText("avg-speed")));
        String strIntensity = eExercise.getChildText("intensity");
        try {
            exercise.setIntensity(Exercise.IntensityType.valueOf(strIntensity));
        }
        catch (Exception exception) {
            throw new Exception("Failed to parse exercise with ID '" + exercise.getId() + "', the intensity '" + strIntensity + "' is not valid!");
        }
        String strAvgHeartRate = eExercise.getChildText("avg-heartrate");
        if (strAvgHeartRate != null) {
            exercise.setAvgHeartRate(Integer.parseInt(strAvgHeartRate));
        }
        if ((strAscent = eExercise.getChildText("ascent")) != null) {
            exercise.setAscent(Integer.parseInt(strAscent));
        }
        if ((strCalories = eExercise.getChildText("calories")) != null) {
            exercise.setCalories(Integer.parseInt(strCalories));
        }
        exercise.setHrmFile(eExercise.getChildText("hrm-file"));
        exercise.setComment(eExercise.getChildText("comment"));
        String strEquipmentID = eExercise.getChildText("equipment-id");
        if (strEquipmentID != null) {
            int equipmentID = Integer.parseInt(strEquipmentID);
            Equipment equipment = sportType.getEquipmentList().getByID(equipmentID);
            if (equipment == null) {
                throw new Exception("Failed to parse exercise with ID '" + exercise.getId() + "', the equipment ID '" + equipmentID + "' is unknown!");
            }
            exercise.setEquipment(equipment);
        }
        return exercise;
    }

    public void storeExerciseList(ExerciseList exerciseList, String destination) throws STException {
        Element eExerciseList = this.createExerciseListElement(exerciseList);
        try {
            XMLUtils.writeXMLFile(eExerciseList, destination);
        }
        catch (IOException e) {
            throw new STException(STExceptionID.XMLSTORAGE_STORE_EXERCISE_LIST, "Failed to write exercise list to XML file '" + destination + "' ...", e);
        }
    }

    private Element createExerciseListElement(ExerciseList exerciseList) {
        Element eExerciseList = new Element("exercise-list");
        for (Exercise exercise : exerciseList) {
            Element eExercise = new Element("exercise");
            eExerciseList.addContent(eExercise);
            XMLUtils.addElement(eExercise, "id", String.valueOf(exercise.getId()));
            XMLUtils.addElement(eExercise, "sport-type-id", String.valueOf(exercise.getSportType().getId()));
            XMLUtils.addElement(eExercise, "sport-subtype-id", String.valueOf(exercise.getSportSubType().getId()));
            XMLUtils.addElement(eExercise, "date", this.sdFormat.format(exercise.getDate()));
            XMLUtils.addElement(eExercise, "duration", String.valueOf(exercise.getDuration()));
            XMLUtils.addElement(eExercise, "intensity", exercise.getIntensity().toStringEnum());
            XMLUtils.addElement(eExercise, "distance", String.valueOf(exercise.getDistance()));
            XMLUtils.addElement(eExercise, "avg-speed", String.valueOf(exercise.getAvgSpeed()));
            if (exercise.getAvgHeartRate() != 0) {
                XMLUtils.addElement(eExercise, "avg-heartrate", String.valueOf(exercise.getAvgHeartRate()));
            }
            if (exercise.getAscent() != 0) {
                XMLUtils.addElement(eExercise, "ascent", String.valueOf(exercise.getAscent()));
            }
            if (exercise.getCalories() != 0) {
                XMLUtils.addElement(eExercise, "calories", String.valueOf(exercise.getCalories()));
            }
            if (exercise.getHrmFile() != null) {
                XMLUtils.addElement(eExercise, "hrm-file", exercise.getHrmFile());
            }
            if (exercise.getEquipment() != null) {
                XMLUtils.addElement(eExercise, "equipment-id", String.valueOf(exercise.getEquipment().getId()));
            }
            if (exercise.getComment() == null) continue;
            XMLUtils.addElement(eExercise, "comment", exercise.getComment());
        }
        return eExerciseList;
    }
}

