/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.storage;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.data.NoteList;
import de.saring.sportstracker.storage.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;

public class XMLNoteList {
    private static final String XSD_NOTES = "notes.xsd";
    private SimpleDateFormat sdFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public NoteList readNoteList(String source) throws STException {
        try {
            NoteList noteList = new NoteList();
            File fSource = new File(source);
            if (!fSource.exists()) {
                return noteList;
            }
            Document document = XMLUtils.getJDOMDocument(fSource, XSD_NOTES);
            Element eNoteList = document.getRootElement();
            List lNotes = eNoteList.getChildren("note");
            for (Element eNote : lNotes) {
                noteList.set(this.readNote(eNote));
            }
            return noteList;
        }
        catch (Exception e) {
            throw new STException(STExceptionID.XMLSTORAGE_READ_NOTE_LIST, "Failed to read note list from XML file '" + source + "' ...", e);
        }
    }

    private Note readNote(Element eNote) throws Exception {
        Note note = new Note(Integer.parseInt(eNote.getChildText("id")));
        note.setText(eNote.getChildText("text"));
        String strDate = eNote.getChildText("date");
        try {
            note.setDate(this.sdFormat.parse(strDate));
        }
        catch (Exception exception) {
            throw new Exception("Failed to parse note with ID '" + note.getId() + "', the date format '" + strDate + "' is not valid!");
        }
        return note;
    }

    public void storeNoteList(NoteList noteList, String destination) throws STException {
        Element eNoteList = this.createNoteListElement(noteList);
        try {
            XMLUtils.writeXMLFile(eNoteList, destination);
        }
        catch (IOException e) {
            throw new STException(STExceptionID.XMLSTORAGE_STORE_NOTE_LIST, "Failed to write note list to XML file '" + destination + "' ...", e);
        }
    }

    private Element createNoteListElement(NoteList noteList) {
        Element eNoteList = new Element("note-list");
        for (Note note : noteList) {
            Element eNote = new Element("note");
            eNoteList.addContent(eNote);
            XMLUtils.addElement(eNote, "id", String.valueOf(note.getId()));
            XMLUtils.addElement(eNote, "date", this.sdFormat.format(note.getDate()));
            XMLUtils.addElement(eNote, "text", note.getText());
        }
        return eNoteList;
    }
}

