/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.storage;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUtils {
    private XMLUtils() {
    }

    public static Document getJDOMDocument(File xmlFile, final String xsdFilename) throws IOException, JDOMException {
        SAXBuilder builder = new SAXBuilder(true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        builder.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", "file://" + xsdFilename);
        builder.setEntityResolver(new EntityResolver(){

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (systemId.toLowerCase().endsWith(xsdFilename)) {
                    return new InputSource(this.getClass().getResourceAsStream("/xml/" + xsdFilename));
                }
                return null;
            }
        });
        return builder.build(xmlFile);
    }

    public static void addElement(Element eParent, String name, String text) {
        Element element = new Element(name);
        element.setText(text);
        eParent.addContent(element);
    }

    public static void writeXMLFile(Element eRoot, String filename) throws IOException {
        OutputStreamWriter osWriter = null;
        try {
            Document document = new Document(eRoot);
            XMLOutputter outputter = new XMLOutputter();
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setIndent("    ");
            outputter.setFormat(format);
            osWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(filename), "UTF-8");
            outputter.output(document, (Writer)osWriter);
            osWriter.flush();
        }
        finally {
            if (osWriter != null) {
                osWriter.close();
            }
        }
    }
}

