/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.data;

import de.saring.util.data.IdDateObject;
import de.saring.util.data.IdObject;
import de.saring.util.data.IdObjectList;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class IdDateObjectList<T extends IdDateObject>
extends IdObjectList<T> {
    @Override
    public void set(T t) {
        if (t == null) {
            throw new IllegalArgumentException("Must not be null!");
        }
        if (((IdObject)t).getId() <= 0) {
            throw new IllegalArgumentException("ID must be a positive integer > 0!");
        }
        if (((IdDateObject)t).getDate() == null) {
            throw new IllegalArgumentException("Date must not be null!");
        }
        if (this.getIDObjects().contains(t)) {
            this.getIDObjects().remove(t);
        }
        try {
            int i = 0;
            while (i < this.getIDObjects().size()) {
                IdDateObject temp = (IdDateObject)this.getIDObjects().get(i);
                if (((IdDateObject)t).getDate().before(temp.getDate())) {
                    this.getIDObjects().add(i, t);
                    return;
                }
                ++i;
            }
            this.getIDObjects().add(t);
        }
        finally {
            this.notifyAllListChangelisteners();
        }
    }

    public List<T> getEntriesInTimeRange(Date dtStart, Date dtEnd) {
        if (dtStart == null || dtEnd == null) {
            throw new IllegalArgumentException("Dates of the time range must not be null!");
        }
        if (dtStart.after(dtEnd)) {
            throw new IllegalArgumentException("Start date is after end date!");
        }
        ArrayList<IdDateObject> lFound = new ArrayList<IdDateObject>();
        for (IdDateObject t : this) {
            if (t.getDate().before(dtStart) || t.getDate().after(dtEnd)) continue;
            lFound.add(t);
        }
        return lFound;
    }
}

