/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JButton;

public class RolloverButton
extends JButton {
    private static final AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.5f);
    private boolean revalidateBlocked;

    public RolloverButton() {
        this.addMouseListener(new MouseOverHandler());
    }

    public RolloverButton(Icon icon) {
        this();
        this.setIcon(icon);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setBorderPainted(false);
        this.setRequestFocusEnabled(false);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.setBorderPainted(false);
        this.repaint();
    }

    @Override
    public void setBorderPainted(boolean b) {
        try {
            this.revalidateBlocked = true;
            super.setBorderPainted(b);
            this.setContentAreaFilled(b);
        }
        finally {
            this.revalidateBlocked = false;
        }
    }

    @Override
    public void revalidate() {
        if (!this.revalidateBlocked) {
            super.revalidate();
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isEnabled()) {
            super.paint(g);
        } else {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(alphaComposite);
            super.paint(g2);
        }
    }

    class MouseOverHandler
    extends MouseAdapter {
        MouseOverHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            RolloverButton.this.setContentAreaFilled(true);
            RolloverButton.this.setBorderPainted(RolloverButton.this.isEnabled());
        }

        @Override
        public void mouseExited(MouseEvent e) {
            RolloverButton.this.setContentAreaFilled(false);
            RolloverButton.this.setBorderPainted(false);
        }
    }
}

