/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.jfreechart;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer2;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.chart.urls.XYURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;

public class StackedRenderer
extends StackedXYAreaRenderer2 {
    protected float areaAlpha = 0.5f;
    private boolean roundXCoordinates = super.getRoundXCoordinates();

    public StackedRenderer() {
        this(null, null);
    }

    public StackedRenderer(XYToolTipGenerator labelGenerator, XYURLGenerator urlGenerator) {
        super(labelGenerator, urlGenerator);
    }

    public void setAreaAlpha(float areaAlpha) {
        this.areaAlpha = areaAlpha;
    }

    public float getAreaAlpha() {
        return this.areaAlpha;
    }

    public void setRoundXCoordinates(boolean round) {
        this.roundXCoordinates = round;
        super.setRoundXCoordinates(true);
    }

    public Range findRangeBounds(XYDataset dataset) {
        if (dataset == null) {
            return null;
        }
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        TableXYDataset d = (TableXYDataset)dataset;
        int itemCount = d.getItemCount();
        int i = 0;
        while (i < itemCount) {
            double[] stackValues = this.getStackValues((TableXYDataset)dataset, d.getSeriesCount(), i);
            min = Math.min(min, stackValues[0]);
            max = Math.max(max, stackValues[1]);
            ++i;
        }
        if (min == Double.POSITIVE_INFINITY) {
            return null;
        }
        return new Range(min, max);
    }

    public int getPassCount() {
        return 2;
    }

    public void drawItem(Graphics2D g2, XYItemRendererState state, Rectangle2D dataArea, PlotRenderingInfo info, XYPlot plot, ValueAxis domainAxis, ValueAxis rangeAxis, XYDataset dataset, int series, int item, CrosshairState crosshairState, int pass) {
        float transYRight;
        double yright;
        float transStackRight;
        float transStackLeft;
        float transStack1;
        float transY1;
        GeneralPath entityArea = null;
        EntityCollection entities = null;
        if (info != null) {
            entities = info.getOwner().getEntityCollection();
        }
        TableXYDataset tdataset = (TableXYDataset)dataset;
        double x1 = dataset.getXValue(series, item);
        double y1 = dataset.getYValue(series, item);
        if (Double.isNaN(y1)) {
            y1 = 0.0;
        }
        double[] stack1 = this.getStackValues(tdataset, series, item);
        double x0 = dataset.getXValue(series, Math.max(item - 1, 0));
        double y0 = dataset.getYValue(series, Math.max(item - 1, 0));
        if (Double.isNaN(y0)) {
            y0 = 0.0;
        }
        double[] stack0 = this.getStackValues(tdataset, series, Math.max(item - 1, 0));
        int itemCount = dataset.getItemCount(series);
        double x2 = dataset.getXValue(series, Math.min(item + 1, itemCount - 1));
        double y2 = dataset.getYValue(series, Math.min(item + 1, itemCount - 1));
        if (Double.isNaN(y2)) {
            y2 = 0.0;
        }
        double[] stack2 = this.getStackValues(tdataset, series, Math.min(item + 1, itemCount - 1));
        double xleft = (x0 + x1) / 2.0;
        double xright = (x1 + x2) / 2.0;
        double[] stackLeft = this.averageStackValues(stack0, stack1);
        double[] stackRight = this.averageStackValues(stack1, stack2);
        double[] adjStackLeft = this.adjustedStackValues(stack0, stack1);
        double[] adjStackRight = this.adjustedStackValues(stack1, stack2);
        RectangleEdge edge0 = plot.getDomainAxisEdge();
        float transX1 = (float)domainAxis.valueToJava2D(x1, dataArea, edge0);
        float transXLeft = (float)domainAxis.valueToJava2D(xleft, dataArea, edge0);
        float transXRight = (float)domainAxis.valueToJava2D(xright, dataArea, edge0);
        if (this.roundXCoordinates) {
            transX1 = Math.round(transX1);
            transXLeft = Math.round(transXLeft);
            transXRight = Math.round(transXRight);
        }
        RectangleEdge edge1 = plot.getRangeAxisEdge();
        GeneralPath left = new GeneralPath();
        GeneralPath right = new GeneralPath();
        if (y1 >= 0.0) {
            transY1 = (float)rangeAxis.valueToJava2D(y1 + stack1[1], dataArea, edge1);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[1], dataArea, edge1);
            transStackLeft = (float)rangeAxis.valueToJava2D(stackLeft[1], dataArea, edge1);
            if (y0 >= 0.0) {
                double yleft = (y0 + y1) / 2.0 + stackLeft[1];
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, edge1);
                left.moveTo(transX1, transY1);
                left.lineTo(transX1, transStack1);
                left.lineTo(transXLeft, transStackLeft);
                left.lineTo(transXLeft, transYLeft);
                left.closePath();
            } else {
                left.moveTo(transX1, transStack1);
                left.lineTo(transX1, transY1);
                left.lineTo(transXLeft, transStackLeft);
                left.closePath();
            }
            transStackRight = (float)rangeAxis.valueToJava2D(stackRight[1], dataArea, edge1);
            if (y2 >= 0.0) {
                yright = (y1 + y2) / 2.0 + stackRight[1];
                transYRight = (float)rangeAxis.valueToJava2D(yright, dataArea, edge1);
                right.moveTo(transX1, transStack1);
                right.lineTo(transX1, transY1);
                right.lineTo(transXRight, transYRight);
                right.lineTo(transXRight, transStackRight);
                right.closePath();
            } else {
                right.moveTo(transX1, transStack1);
                right.lineTo(transX1, transY1);
                right.lineTo(transXRight, transStackRight);
                right.closePath();
            }
        } else {
            transY1 = (float)rangeAxis.valueToJava2D(y1 + stack1[0], dataArea, edge1);
            transStack1 = (float)rangeAxis.valueToJava2D(stack1[0], dataArea, edge1);
            transStackLeft = (float)rangeAxis.valueToJava2D(adjStackLeft[0], dataArea, edge1);
            if (y0 >= 0.0) {
                left.moveTo(transX1, transStack1);
                left.lineTo(transX1, transY1);
                left.lineTo(transXLeft, transStackLeft);
                left.clone();
            } else {
                double yleft = (y0 + y1) / 2.0 + stackLeft[0];
                float transYLeft = (float)rangeAxis.valueToJava2D(yleft, dataArea, edge1);
                left.moveTo(transX1, transY1);
                left.lineTo(transX1, transStack1);
                left.lineTo(transXLeft, transStackLeft);
                left.lineTo(transXLeft, transYLeft);
                left.closePath();
            }
            transStackRight = (float)rangeAxis.valueToJava2D(adjStackRight[0], dataArea, edge1);
            if (y2 >= 0.0) {
                right.moveTo(transX1, transStack1);
                right.lineTo(transX1, transY1);
                right.lineTo(transXRight, transStackRight);
                right.closePath();
            } else {
                yright = (y1 + y2) / 2.0 + stackRight[0];
                transYRight = (float)rangeAxis.valueToJava2D(yright, dataArea, edge1);
                right.moveTo(transX1, transStack1);
                right.lineTo(transX1, transY1);
                right.lineTo(transXRight, transYRight);
                right.lineTo(transXRight, transStackRight);
                right.closePath();
            }
        }
        Paint itemPaint = this.getItemPaint(series, item);
        if (pass == 0) {
            g2.setPaint(itemPaint);
            g2.fill(left);
            g2.fill(right);
        } else if (pass == 1) {
            if (item == 0 || y1 == 0.0 && y0 == 0.0) {
                return;
            }
            if (Double.isNaN(y1) || Double.isNaN(x1)) {
                return;
            }
            if (Double.isNaN(y0) || Double.isNaN(x0)) {
                return;
            }
            RectangleEdge xAxisLocation = plot.getDomainAxisEdge();
            RectangleEdge yAxisLocation = plot.getRangeAxisEdge();
            double transX0 = domainAxis.valueToJava2D(x0, dataArea, xAxisLocation);
            double transY0 = rangeAxis.valueToJava2D(y0 + stack0[1], dataArea, yAxisLocation);
            if (Double.isNaN(transX0) || Double.isNaN(transY0) || Double.isNaN(transX1) || Double.isNaN(transY1)) {
                return;
            }
            state.workingLine.setLine(transX0, transY0, transX1, transY1);
            if (state.workingLine.intersects(dataArea)) {
                g2.setStroke(this.getItemStroke(series, item));
                g2.setPaint(super.lookupSeriesPaint(series));
                g2.draw(state.workingLine);
            }
            return;
        }
        if (entities != null) {
            GeneralPath gp = new GeneralPath(left);
            gp.append(right, false);
            entityArea = gp;
            this.addEntity(entities, entityArea, dataset, series, item, transX1, transY1);
        }
    }

    private double[] getStackValues(TableXYDataset dataset, int series, int index) {
        double[] result = new double[2];
        int i = 0;
        while (i < series) {
            double v = dataset.getYValue(i, index);
            if (!Double.isNaN(v)) {
                if (v >= 0.0) {
                    result[1] = result[1] + v;
                } else {
                    result[0] = result[0] + v;
                }
            }
            ++i;
        }
        return result;
    }

    private double[] averageStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{(stack1[0] + stack2[0]) / 2.0, (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    private double[] adjustedStackValues(double[] stack1, double[] stack2) {
        double[] result = new double[]{stack1[0] == 0.0 || stack2[0] == 0.0 ? 0.0 : (stack1[0] + stack2[0]) / 2.0, stack1[1] == 0.0 || stack2[1] == 0.0 ? 0.0 : (stack1[1] + stack2[1]) / 2.0};
        return result;
    }

    public Paint lookupSeriesPaint(int series) {
        Paint paint = super.lookupSeriesPaint(series);
        if (paint instanceof Color) {
            Color color = (Color)paint;
            paint = new Color(color.getColorSpace(), color.getColorComponents(null), this.areaAlpha);
        }
        return paint;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StackedRenderer)) {
            return false;
        }
        StackedRenderer that = (StackedRenderer)((Object)obj);
        if (this.roundXCoordinates != that.roundXCoordinates) {
            return false;
        }
        if (this.areaAlpha != that.areaAlpha) {
            return false;
        }
        return super.equals(obj);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

