/*
 * Decompiled with CFR 0.152.
 */
package de.saring.util.gui.mac;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.swing.Action;

public final class MacSpecials {
    private Object eawtApp = null;
    private Action aboutAction = null;
    private Action prefsAction = null;
    private Action quitAction = null;

    private MacSpecials() {
        try {
            Class<?> eawtAppClass = Class.forName("com.apple.eawt.Application");
            Method getAppMethod = eawtAppClass.getDeclaredMethod("getApplication", null);
            this.eawtApp = getAppMethod.invoke(null, null);
            Class<?> eawtAppListenerClass = Class.forName("com.apple.eawt.ApplicationListener");
            Object appListenerProxy = Proxy.newProxyInstance(AppListenerProxy.class.getClassLoader(), new Class[]{eawtAppListenerClass}, (InvocationHandler)new AppListenerProxy());
            Class<?> c = this.eawtApp.getClass();
            Method m = c.getDeclaredMethod("addApplicationListener", eawtAppListenerClass);
            m.invoke(this.eawtApp, appListenerProxy);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static MacSpecials getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public static boolean isMacOSX() {
        String os = System.getProperty("os.name").toUpperCase();
        return os.startsWith("MAC OS X");
    }

    public static void setApplicationMenuName(String name) {
        System.setProperty("com.apple.mrj.application.apple.menu.about.name", name);
    }

    public static void useScreenMenuBar(boolean use) {
        System.setProperty("apple.laf.useScreenMenuBar", String.valueOf(use));
    }

    public void setDockIcon(Image dockIcon) {
        try {
            Class<?> c = this.eawtApp.getClass();
            Method m = c.getDeclaredMethod("setDockIconImage", Image.class);
            m.invoke(this.eawtApp, dockIcon);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAboutMenuItemEnabled(boolean enable) {
        try {
            Class<?> c = this.eawtApp.getClass();
            Method m = c.getDeclaredMethod("setEnabledAboutMenu", Boolean.TYPE);
            m.invoke(this.eawtApp, enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setAboutAction(Action action) {
        this.aboutAction = action;
        if (this.aboutAction != null) {
            this.setAboutMenuItemEnabled(true);
        } else {
            this.setAboutMenuItemEnabled(false);
        }
    }

    public void setPreferencesMenuItemEnabled(boolean enable) {
        try {
            Class<?> c = this.eawtApp.getClass();
            Method m = c.getDeclaredMethod("setEnabledPreferencesMenu", Boolean.TYPE);
            m.invoke(this.eawtApp, enable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setPreferencesAction(Action action) {
        this.prefsAction = action;
        if (this.prefsAction != null) {
            this.setPreferencesMenuItemEnabled(true);
        } else {
            this.setPreferencesMenuItemEnabled(false);
        }
    }

    public void setQuitAction(Action action) {
        this.quitAction = action;
    }

    /* synthetic */ MacSpecials(MacSpecials macSpecials) {
        this();
    }

    public class AppListenerProxy
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            try {
                boolean eventHandled = true;
                String methodName = method.getName();
                if (MacSpecials.this.aboutAction != null && methodName.equals("handleAbout")) {
                    MacSpecials.this.aboutAction.actionPerformed(new ActionEvent(MacSpecials.this.eawtApp, 1001, ""));
                } else if (MacSpecials.this.prefsAction != null && methodName.equals("handlePreferences")) {
                    MacSpecials.this.prefsAction.actionPerformed(new ActionEvent(MacSpecials.this.eawtApp, 1001, ""));
                } else if (MacSpecials.this.quitAction != null && methodName.equals("handleQuit")) {
                    MacSpecials.this.quitAction.actionPerformed(new ActionEvent(MacSpecials.this.eawtApp, 1001, ""));
                } else {
                    eventHandled = false;
                }
                Object eawtAppEvent = args[0];
                if (eawtAppEvent != null) {
                    Class<?> c = eawtAppEvent.getClass();
                    Method m = c.getDeclaredMethod("setHandled", Boolean.TYPE);
                    m.invoke(eawtAppEvent, eventHandled);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static final class InstanceHolder {
        private static final MacSpecials INSTANCE = new MacSpecials(null);

        private InstanceHolder() {
        }
    }
}

