/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.ActivityMesg;
import com.garmin.fit.BloodPressureMesg;
import com.garmin.fit.CapabilitiesMesg;
import com.garmin.fit.DeviceInfoMesg;
import com.garmin.fit.DeviceSettingsMesg;
import com.garmin.fit.EventMesg;
import com.garmin.fit.Field;
import com.garmin.fit.FieldCapabilitiesMesg;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FileCapabilitiesMesg;
import com.garmin.fit.FileCreatorMesg;
import com.garmin.fit.FileIdMesg;
import com.garmin.fit.HrZoneMesg;
import com.garmin.fit.HrmProfileMesg;
import com.garmin.fit.LapMesg;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgCapabilitiesMesg;
import com.garmin.fit.MesgNum;
import com.garmin.fit.MesgSubFieldMap;
import com.garmin.fit.MetZoneMesg;
import com.garmin.fit.PowerZoneMesg;
import com.garmin.fit.RecordMesg;
import com.garmin.fit.SessionMesg;
import com.garmin.fit.SoftwareMesg;
import com.garmin.fit.SportMesg;
import com.garmin.fit.TotalsMesg;
import com.garmin.fit.TrainingGoalsMesg;
import com.garmin.fit.UserProfileMesg;
import com.garmin.fit.WeightScaleMesg;
import com.garmin.fit.WorkoutMesg;
import com.garmin.fit.WorkoutStepMesg;
import com.garmin.fit.ZonesTargetMesg;
import java.util.ArrayList;

public class Factory {
    private static final Mesg[] mesgs = new Mesg[27];
    private static final MesgSubFieldMap[] mesgSubFieldMaps = new MesgSubFieldMap[27];

    public static Mesg createMesg(Mesg mesg) {
        switch (mesg.getNum()) {
            case 0: {
                return new FileIdMesg(mesg);
            }
            case 49: {
                return new FileCreatorMesg(mesg);
            }
            case 35: {
                return new SoftwareMesg(mesg);
            }
            case 1: {
                return new CapabilitiesMesg(mesg);
            }
            case 37: {
                return new FileCapabilitiesMesg(mesg);
            }
            case 38: {
                return new MesgCapabilitiesMesg(mesg);
            }
            case 39: {
                return new FieldCapabilitiesMesg(mesg);
            }
            case 2: {
                return new DeviceSettingsMesg(mesg);
            }
            case 3: {
                return new UserProfileMesg(mesg);
            }
            case 4: {
                return new HrmProfileMesg(mesg);
            }
            case 7: {
                return new ZonesTargetMesg(mesg);
            }
            case 12: {
                return new SportMesg(mesg);
            }
            case 8: {
                return new HrZoneMesg(mesg);
            }
            case 9: {
                return new PowerZoneMesg(mesg);
            }
            case 10: {
                return new MetZoneMesg(mesg);
            }
            case 15: {
                return new TrainingGoalsMesg(mesg);
            }
            case 34: {
                return new ActivityMesg(mesg);
            }
            case 18: {
                return new SessionMesg(mesg);
            }
            case 19: {
                return new LapMesg(mesg);
            }
            case 20: {
                return new RecordMesg(mesg);
            }
            case 21: {
                return new EventMesg(mesg);
            }
            case 23: {
                return new DeviceInfoMesg(mesg);
            }
            case 26: {
                return new WorkoutMesg(mesg);
            }
            case 27: {
                return new WorkoutStepMesg(mesg);
            }
            case 33: {
                return new TotalsMesg(mesg);
            }
            case 30: {
                return new WeightScaleMesg(mesg);
            }
            case 51: {
                return new BloodPressureMesg(mesg);
            }
        }
        return new Mesg("unknown", MesgNum.INVALID);
    }

    public static Mesg createMesg(int n) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Mesg(mesgs[i]);
        }
        return new Mesg("unknown", n);
    }

    public static Mesg createMesg(String string) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Mesg(mesgs[i]);
        }
        return new Mesg(string, MesgNum.INVALID);
    }

    public static Field createField(String string, String string2) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Field(mesgs[i].getField(string2));
        }
        return new Field(string2, 255, 0, 1.0, 0.0, "");
    }

    public static Field createField(String string, int n) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (!Factory.mesgs[i].name.equals(string)) continue;
            return new Field(mesgs[i].getField(n));
        }
        return new Field("unknown", n, 0, 1.0, 0.0, "");
    }

    public static Field createField(int n, int n2) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Field(mesgs[i].getField(n2));
        }
        return new Field("unknown", n2, 0, 1.0, 0.0, "");
    }

    public static Field createField(int n, String string) {
        for (int i = 0; i < mesgs.length; ++i) {
            if (Factory.mesgs[i].num != n) continue;
            return new Field(mesgs[i].getField(string));
        }
        return new Field(string, 255, 0, 1.0, 0.0, "");
    }

    public static Field createField(String string, String string2, ArrayList<Object> arrayList) {
        Field field = Factory.createField(string, string2);
        field.values = arrayList;
        return field;
    }

    public static void mapSubFields(Mesg mesg) {
        for (MesgSubFieldMap mesgSubFieldMap : mesgSubFieldMaps) {
            mesgSubFieldMap.map(mesg);
        }
    }

    static {
        int n = 0;
        int n2 = 0;
        Factory.mesgs[n] = new Mesg("file_id", 0);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(0);
        mesgs[n].addField(new Field("type", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("manufacturer", 1, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("product", 2, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("garmin_product", 2, 132, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("garmin_product", 2, 1, 1L);
        mesgSubFieldMaps[n].add("garmin_product", 2, 1, 15L);
        mesgSubFieldMaps[n].add("garmin_product", 2, 1, 13L);
        mesgs[n].addField(new Field("serial_number", 3, 140, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("time_created", 4, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("number", 5, 132, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("file_creator", 49);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(49);
        mesgs[n].addField(new Field("software_version", 0, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("hardware_version", 1, 2, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("software", 35);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(35);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("version", 3, 132, 100.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("part_number", 5, 7, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("capabilities", 1);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(1);
        mesgs[n].addField(new Field("workouts_supported", 21, 140, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("file_capabilities", 37);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(37);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("type", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("flags", 1, 10, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("directory", 2, 7, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("max_count", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("max_size", 4, 134, 1.0, 0.0, "bytes"));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("mesg_capabilities", 38);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(38);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("file", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("mesg_num", 1, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("count_type", 2, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("count", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("num_per_file", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("num_per_file", 3, 2, 0L);
        mesgs[n].addField(new Field("max_per_file", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("max_per_file", 3, 2, 1L);
        mesgs[n].addField(new Field("max_per_file_type", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("max_per_file_type", 3, 2, 2L);
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("field_capabilities", 39);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(39);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("file", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("mesg_num", 1, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("field_num", 2, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("count", 3, 132, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("device_settings", 2);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(2);
        mesgs[n].addField(new Field("utc_offset", 1, 134, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("user_profile", 3);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(3);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("friendly_name", 0, 7, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("gender", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("age", 2, 2, 1.0, 0.0, "years"));
        ++n2;
        mesgs[n].addField(new Field("height", 3, 2, 100.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("weight", 4, 132, 10.0, 0.0, "kg"));
        ++n2;
        mesgs[n].addField(new Field("language", 5, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("elev_setting", 6, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("weight_setting", 7, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("resting_heart_rate", 8, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("default_max_running_heart_rate", 9, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("default_max_biking_heart_rate", 10, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("default_max_heart_rate", 11, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("hr_setting", 12, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("speed_setting", 13, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("dist_setting", 14, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("power_setting", 16, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("activity_class", 17, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("position_setting", 18, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("temperature_setting", 21, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("local_id", 22, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("global_id", 23, 13, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("hrm_profile", 4);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(4);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("enabled", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("hrm_ant_id", 1, 139, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("zones_target", 7);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(7);
        mesgs[n].addField(new Field("max_heart_rate", 1, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("threshold_heart_rate", 2, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("functional_threshold_power", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("hr_calc_type", 5, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("pwr_calc_type", 7, 0, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("sport", 12);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(12);
        mesgs[n].addField(new Field("sport", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("sub_sport", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("name", 3, 7, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("hr_zone", 8);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(8);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("high_bpm", 1, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("name", 2, 7, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("power_zone", 9);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(9);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("high_value", 1, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgs[n].addField(new Field("name", 2, 7, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("met_zone", 10);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(10);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("high_bpm", 1, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("calories", 2, 132, 10.0, 0.0, "kcal / min"));
        ++n2;
        mesgs[n].addField(new Field("fat_calories", 3, 2, 10.0, 0.0, "kcal / min"));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("training_goals", 15);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(15);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("sport", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("sub_sport", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("start_date", 2, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("end_date", 3, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("type", 4, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("value", 5, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("repeat", 6, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("target_value", 7, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("recurrence", 8, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("recurrence_value", 9, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("enabled", 10, 0, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("activity", 34);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(34);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("total_timer_time", 0, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("num_sessions", 1, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("type", 2, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event", 3, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_type", 4, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("local_timestamp", 5, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_group", 6, 2, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("session", 18);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(18);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("event", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_type", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("start_time", 2, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("start_position_lat", 3, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("start_position_long", 4, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("sport", 5, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("sub_sport", 6, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("total_elapsed_time", 7, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("total_timer_time", 8, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("total_distance", 9, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("total_cycles", 10, 134, 1.0, 0.0, "cycles"));
        ++n2;
        mesgs[n].addField(new Field("total_strides", 10, 134, 1.0, 0.0, "strides"));
        ++n2;
        mesgSubFieldMaps[n].add("total_strides", 10, 5, 1L);
        mesgs[n].addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal"));
        ++n2;
        mesgs[n].addField(new Field("total_fat_calories", 13, 132, 1.0, 0.0, "kcal"));
        ++n2;
        mesgs[n].addField(new Field("avg_speed", 14, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgs[n].addField(new Field("max_speed", 15, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgs[n].addField(new Field("avg_heart_rate", 16, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("max_heart_rate", 17, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("avg_cadence", 18, 2, 1.0, 0.0, "rpm"));
        ++n2;
        mesgs[n].addField(new Field("avg_running_cadence", 18, 2, 1.0, 0.0, "strides/min"));
        ++n2;
        mesgSubFieldMaps[n].add("avg_running_cadence", 18, 5, 1L);
        mesgs[n].addField(new Field("max_cadence", 19, 2, 1.0, 0.0, "rpm"));
        ++n2;
        mesgs[n].addField(new Field("max_running_cadence", 19, 2, 1.0, 0.0, "strides/min"));
        ++n2;
        mesgSubFieldMaps[n].add("max_running_cadence", 19, 5, 1L);
        mesgs[n].addField(new Field("avg_power", 20, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgs[n].addField(new Field("max_power", 21, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgs[n].addField(new Field("total_ascent", 22, 132, 1.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("total_descent", 23, 132, 1.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("total_training_effect", 24, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("first_lap_index", 25, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("num_laps", 26, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_group", 27, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("trigger", 28, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("nec_lat", 29, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("nec_long", 30, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("swc_lat", 31, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("swc_long", 32, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("lap", 19);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(19);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("event", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_type", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("start_time", 2, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("start_position_lat", 3, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("start_position_long", 4, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("end_position_lat", 5, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("end_position_long", 6, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("total_elapsed_time", 7, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("total_timer_time", 8, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("total_distance", 9, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("total_cycles", 10, 134, 1.0, 0.0, "cycles"));
        ++n2;
        mesgs[n].addField(new Field("total_strides", 10, 134, 1.0, 0.0, "strides"));
        ++n2;
        mesgSubFieldMaps[n].add("total_strides", 10, 25, 1L);
        mesgs[n].addField(new Field("total_calories", 11, 132, 1.0, 0.0, "kcal"));
        ++n2;
        mesgs[n].addField(new Field("total_fat_calories", 12, 132, 1.0, 0.0, "kcal"));
        ++n2;
        mesgs[n].addField(new Field("avg_speed", 13, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgs[n].addField(new Field("max_speed", 14, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgs[n].addField(new Field("avg_heart_rate", 15, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("max_heart_rate", 16, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("avg_cadence", 17, 2, 1.0, 0.0, "rpm"));
        ++n2;
        mesgs[n].addField(new Field("avg_running_cadence", 17, 2, 1.0, 0.0, "strides/min"));
        ++n2;
        mesgSubFieldMaps[n].add("avg_running_cadence", 17, 25, 1L);
        mesgs[n].addField(new Field("max_cadence", 18, 2, 1.0, 0.0, "rpm"));
        ++n2;
        mesgs[n].addField(new Field("max_running_cadence", 18, 2, 1.0, 0.0, "strides/min"));
        ++n2;
        mesgSubFieldMaps[n].add("max_running_cadence", 18, 25, 1L);
        mesgs[n].addField(new Field("avg_power", 19, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgs[n].addField(new Field("max_power", 20, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgs[n].addField(new Field("total_ascent", 21, 132, 1.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("total_descent", 22, 132, 1.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("intensity", 23, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("lap_trigger", 24, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("sport", 25, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_group", 26, 2, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("record", 20);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(20);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("position_lat", 0, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("position_long", 1, 133, 1.0, 0.0, "semicircles"));
        ++n2;
        mesgs[n].addField(new Field("altitude", 2, 132, 5.0, 500.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("heart_rate", 3, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("cadence", 4, 2, 1.0, 0.0, "rpm"));
        ++n2;
        mesgs[n].addField(new Field("distance", 5, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("speed", 6, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgs[n].addField(new Field("power", 7, 132, 1.0, 0.0, "watts"));
        mesgs[n].addField(new Field("compressed_speed_distance", 8, 13, 1.0, 0.0, ""));
        Factory.mesgs[n].fields.get((int)(++n2)).components.add(new FieldComponent(6, false, 12, 100.0, 0.0));
        Factory.mesgs[n].fields.get((int)n2).components.add(new FieldComponent(5, true, 12, 16.0, 0.0));
        ++n2;
        mesgs[n].addField(new Field("grade", 9, 131, 100.0, 0.0, "%"));
        ++n2;
        mesgs[n].addField(new Field("resistance", 10, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("time_from_course", 11, 133, 1000.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("cycle_length", 12, 2, 100.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("temperature", 13, 1, 1.0, 0.0, "\u00c2\u00b0C"));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("event", 21);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(21);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("event", 0, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("event_type", 1, 0, 1.0, 0.0, ""));
        mesgs[n].addField(new Field("data16", 2, 132, 1.0, 0.0, ""));
        Factory.mesgs[n].fields.get((int)(++n2)).components.add(new FieldComponent(3, false, 16, 1.0, 0.0));
        ++n2;
        mesgs[n].addField(new Field("data", 3, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("timer_trigger", 3, 0, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("timer_trigger", 3, 0, 0L);
        mesgs[n].addField(new Field("course_point", 3, 132, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("course_point", 3, 0, 10L);
        mesgs[n].addField(new Field("battery_level", 3, 132, 1000.0, 0.0, "V"));
        ++n2;
        mesgSubFieldMaps[n].add("battery_level", 3, 0, 11L);
        mesgs[n].addField(new Field("virtual_partner_speed", 3, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgSubFieldMaps[n].add("virtual_partner_speed", 3, 0, 12L);
        mesgs[n].addField(new Field("hr_high_alert", 3, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("hr_high_alert", 3, 0, 13L);
        mesgs[n].addField(new Field("hr_low_alert", 3, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("hr_low_alert", 3, 0, 14L);
        mesgs[n].addField(new Field("speed_high_alert", 3, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgSubFieldMaps[n].add("speed_high_alert", 3, 0, 15L);
        mesgs[n].addField(new Field("speed_low_alert", 3, 132, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgSubFieldMaps[n].add("speed_low_alert", 3, 0, 16L);
        mesgs[n].addField(new Field("cad_high_alert", 3, 132, 1.0, 0.0, "rpm"));
        ++n2;
        mesgSubFieldMaps[n].add("cad_high_alert", 3, 0, 17L);
        mesgs[n].addField(new Field("cad_low_alert", 3, 132, 1.0, 0.0, "rpm"));
        ++n2;
        mesgSubFieldMaps[n].add("cad_low_alert", 3, 0, 18L);
        mesgs[n].addField(new Field("power_high_alert", 3, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgSubFieldMaps[n].add("power_high_alert", 3, 0, 19L);
        mesgs[n].addField(new Field("power_low_alert", 3, 132, 1.0, 0.0, "watts"));
        ++n2;
        mesgSubFieldMaps[n].add("power_low_alert", 3, 0, 20L);
        mesgs[n].addField(new Field("time_duration_alert", 3, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgSubFieldMaps[n].add("time_duration_alert", 3, 0, 23L);
        mesgs[n].addField(new Field("distance_duration_alert", 3, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgSubFieldMaps[n].add("distance_duration_alert", 3, 0, 24L);
        mesgs[n].addField(new Field("calorie_duration_alert", 3, 134, 1.0, 0.0, "calories"));
        ++n2;
        mesgSubFieldMaps[n].add("calorie_duration_alert", 3, 0, 25L);
        mesgs[n].addField(new Field("fitness_equipment_state", 3, 0, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("fitness_equipment_state", 3, 0, 27L);
        mesgs[n].addField(new Field("event_group", 4, 2, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("device_info", 23);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(23);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("device_index", 0, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("device_type", 1, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("manufacturer", 2, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("serial_number", 3, 140, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("product", 4, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("software_version", 5, 132, 100.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("hardware_version", 6, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("cum_operating_time", 7, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("battery_voltage", 10, 132, 256.0, 0.0, "V"));
        ++n2;
        mesgs[n].addField(new Field("battery_status", 11, 2, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("workout", 26);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(26);
        mesgs[n].addField(new Field("sport", 4, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("capabilities", 5, 140, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("num_valid_steps", 6, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("wkt_name", 8, 7, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("workout_step", 27);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(27);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("wkt_step_name", 0, 7, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("duration_type", 1, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("duration_value", 2, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("duration_time", 2, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgSubFieldMaps[n].add("duration_time", 2, 1, 0L);
        mesgs[n].addField(new Field("duration_distance", 2, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgSubFieldMaps[n].add("duration_distance", 2, 1, 1L);
        mesgs[n].addField(new Field("duration_hr", 2, 134, 1.0, 0.0, "% or bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("duration_hr", 2, 1, 2L);
        mesgSubFieldMaps[n].add("duration_hr", 2, 1, 3L);
        mesgs[n].addField(new Field("duration_calories", 2, 134, 1.0, 0.0, "calories"));
        ++n2;
        mesgSubFieldMaps[n].add("duration_calories", 2, 1, 4L);
        mesgs[n].addField(new Field("duration_step", 2, 134, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 6L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 7L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 8L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 9L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 10L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 11L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 12L);
        mesgSubFieldMaps[n].add("duration_step", 2, 1, 13L);
        mesgs[n].addField(new Field("duration_power", 2, 134, 1.0, 0.0, "% or watts"));
        ++n2;
        mesgSubFieldMaps[n].add("duration_power", 2, 1, 14L);
        mesgSubFieldMaps[n].add("duration_power", 2, 1, 15L);
        mesgs[n].addField(new Field("target_type", 3, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("target_value", 4, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("target_hr_zone", 4, 134, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("target_hr_zone", 4, 3, 1L);
        mesgs[n].addField(new Field("target_power_zone", 4, 134, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("target_power_zone", 4, 3, 4L);
        mesgs[n].addField(new Field("repeat_steps", 4, 134, 1.0, 0.0, ""));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_steps", 4, 1, 6L);
        mesgs[n].addField(new Field("repeat_time", 4, 134, 1000.0, 0.0, "s"));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_time", 4, 1, 7L);
        mesgs[n].addField(new Field("repeat_distance", 4, 134, 100.0, 0.0, "m"));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_distance", 4, 1, 8L);
        mesgs[n].addField(new Field("repeat_calories", 4, 134, 1.0, 0.0, "calories"));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_calories", 4, 1, 9L);
        mesgs[n].addField(new Field("repeat_hr", 4, 134, 1.0, 0.0, "% or bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_hr", 4, 1, 10L);
        mesgSubFieldMaps[n].add("repeat_hr", 4, 1, 11L);
        mesgs[n].addField(new Field("repeat_power", 4, 134, 1.0, 0.0, "% or watts"));
        ++n2;
        mesgSubFieldMaps[n].add("repeat_power", 4, 1, 12L);
        mesgSubFieldMaps[n].add("repeat_power", 4, 1, 13L);
        mesgs[n].addField(new Field("custom_target_value_low", 5, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("custom_target_speed_low", 5, 134, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_speed_low", 5, 3, 0L);
        mesgs[n].addField(new Field("custom_target_heart_rate_low", 5, 134, 1.0, 0.0, "% or bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_heart_rate_low", 5, 3, 1L);
        mesgs[n].addField(new Field("custom_target_cadence_low", 5, 134, 1.0, 0.0, "rpm"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_cadence_low", 5, 3, 3L);
        mesgs[n].addField(new Field("custom_target_power_low", 5, 134, 1.0, 0.0, "% or watts"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_power_low", 5, 3, 4L);
        mesgs[n].addField(new Field("custom_target_value_high", 6, 134, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("custom_target_speed_high", 6, 134, 1000.0, 0.0, "m/s"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_speed_high", 6, 3, 0L);
        mesgs[n].addField(new Field("custom_target_heart_rate_high", 6, 134, 1.0, 0.0, "% or bpm"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_heart_rate_high", 6, 3, 1L);
        mesgs[n].addField(new Field("custom_target_cadence_high", 6, 134, 1.0, 0.0, "rpm"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_cadence_high", 6, 3, 3L);
        mesgs[n].addField(new Field("custom_target_power_high", 6, 134, 1.0, 0.0, "% or watts"));
        ++n2;
        mesgSubFieldMaps[n].add("custom_target_power_high", 6, 3, 4L);
        mesgs[n].addField(new Field("intensity", 7, 0, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("totals", 33);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(33);
        mesgs[n].addField(new Field("message_index", 254, 132, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("timer_time", 0, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("distance", 1, 134, 1.0, 0.0, "m"));
        ++n2;
        mesgs[n].addField(new Field("calories", 2, 134, 1.0, 0.0, "kcal"));
        ++n2;
        mesgs[n].addField(new Field("sport", 3, 0, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("weight_scale", 30);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(30);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("weight", 0, 132, 100.0, 0.0, "kg"));
        ++n2;
        mesgs[n].addField(new Field("percent_fat", 1, 132, 100.0, 0.0, "%"));
        ++n2;
        mesgs[n].addField(new Field("percent_hydration", 2, 132, 100.0, 0.0, "%"));
        ++n2;
        mesgs[n].addField(new Field("visceral_fat_mass", 3, 132, 100.0, 0.0, "kg"));
        ++n2;
        mesgs[n].addField(new Field("bone_mass", 4, 132, 100.0, 0.0, "kg"));
        ++n2;
        mesgs[n].addField(new Field("muscle_mass", 5, 132, 100.0, 0.0, "kg"));
        ++n2;
        mesgs[n].addField(new Field("basal_met", 7, 132, 4.0, 0.0, "kcal/day"));
        ++n2;
        mesgs[n].addField(new Field("physique_rating", 8, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("active_met", 9, 132, 4.0, 0.0, "kcal/day"));
        ++n2;
        mesgs[n].addField(new Field("metabolic_age", 10, 2, 1.0, 0.0, "years"));
        ++n2;
        mesgs[n].addField(new Field("visceral_fat_rating", 11, 2, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("user_profile_index", 12, 132, 1.0, 0.0, ""));
        ++n2;
        n2 = 0;
        Factory.mesgs[++n] = new Mesg("blood_pressure", 51);
        Factory.mesgSubFieldMaps[n] = new MesgSubFieldMap(51);
        mesgs[n].addField(new Field("timestamp", 253, 134, 1.0, 0.0, "s"));
        ++n2;
        mesgs[n].addField(new Field("systolic_pressure", 0, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("diastolic_pressure", 1, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("mean_arterial_pressure", 2, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("map_3_sample_mean", 3, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("map_morning_values", 4, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("map_evening_values", 5, 132, 1.0, 0.0, "mmHg"));
        ++n2;
        mesgs[n].addField(new Field("heart_rate", 6, 2, 1.0, 0.0, "bpm"));
        ++n2;
        mesgs[n].addField(new Field("heart_rate_type", 7, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("status", 8, 0, 1.0, 0.0, ""));
        ++n2;
        mesgs[n].addField(new Field("user_profile_index", 9, 132, 1.0, 0.0, ""));
        ++n2;
        ++n;
    }
}

