/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;

public class FileEncoder
implements MesgListener,
MesgDefinitionListener {
    private RandomAccessFile file;
    private MesgDefinition[] lastMesgDefinition = new MesgDefinition[16];
    private long dataSize;

    public FileEncoder() {
    }

    public FileEncoder(File file) {
        this.open(file);
    }

    public void open(File file) {
        try {
            file.delete();
            this.file = new RandomAccessFile(file, "rw");
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        this.dataSize = 0L;
        this.writeFileHeader();
    }

    private void writeFileHeader() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        try {
            this.file.seek(0L);
            this.file.writeByte(12);
            this.file.writeByte(16);
            this.file.writeByte(100);
            this.file.writeByte(0);
            this.file.writeByte((int)(this.dataSize & 0xFFL));
            this.file.writeByte((int)(this.dataSize >> 8 & 0xFFL));
            this.file.writeByte((int)(this.dataSize >> 16 & 0xFFL));
            this.file.writeByte((int)(this.dataSize >> 24 & 0xFFL));
            this.file.writeByte(46);
            this.file.writeByte(70);
            this.file.writeByte(73);
            this.file.writeByte(84);
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    @Override
    public void onMesg(Mesg mesg) {
        this.write(mesg);
    }

    @Override
    public void onMesgDefinition(MesgDefinition mesgDefinition) {
        this.write(mesgDefinition);
    }

    public void write(MesgDefinition mesgDefinition) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        if (!mesgDefinition.equals(this.lastMesgDefinition[mesgDefinition.localNum])) {
            this.lastMesgDefinition[mesgDefinition.localNum] = mesgDefinition;
            this.dataSize += (long)mesgDefinition.write(this.file);
        }
    }

    public void write(Mesg mesg) {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        this.write(new MesgDefinition(mesg));
        this.dataSize += (long)mesg.write(this.file);
    }

    public void write(List<Mesg> list) {
        for (Mesg mesg : list) {
            this.write(mesg);
        }
    }

    public void close() {
        if (this.file == null) {
            throw new FitRuntimeException("File not open.");
        }
        this.writeFileHeader();
        this.dataSize += 12L;
        try {
            if (this.dataSize != this.file.length()) {
                throw new FitRuntimeException("Invalid file length " + this.file.length() + ". Expected" + this.dataSize + ".");
            }
            this.file.seek(0L);
            int n = 0;
            int n2 = 0;
            while ((long)n2 < this.dataSize) {
                n = CRC.get16(n, (byte)this.file.read());
                ++n2;
            }
            this.file.writeByte(n & 0xFF);
            this.file.writeByte(n >> 8 & 0xFF);
            this.file.close();
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }
}

