/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.EventType;
import com.garmin.fit.Factory;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgWithEvent;
import com.garmin.fit.MesgWithEventListener;
import java.util.ArrayList;
import java.util.LinkedList;

public class MesgWithEventBroadcaster
implements MesgWithEventListener {
    private int MAX_GROUPS = 256;
    private int DEFAULT_GROUP = 255;
    private int BEGIN_END_GROUP = 254;
    private ArrayList<MesgWithEventListener> listeners = new ArrayList();
    private ArrayList<LinkedList<MesgWithEvent>> startedEvents = new ArrayList();

    public MesgWithEventBroadcaster() {
        for (int i = 0; i < this.MAX_GROUPS; ++i) {
            this.startedEvents.add(new LinkedList());
        }
    }

    public void addListener(MesgWithEventListener mesgWithEventListener) {
        this.listeners.add(mesgWithEventListener);
    }

    @Override
    public void onMesg(MesgWithEvent mesgWithEvent) {
        MesgWithEvent mesgWithEvent2 = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)mesgWithEvent)));
        int n = this.DEFAULT_GROUP;
        if (mesgWithEvent2.getEventGroup() != null) {
            n = mesgWithEvent2.getEventGroup().shortValue();
        }
        if (mesgWithEvent2.getEventType() == null) {
            return;
        }
        switch (mesgWithEvent2.getEventType()) {
            case BEGIN_DEPRECIATED: {
                n = this.BEGIN_END_GROUP;
                mesgWithEvent2.setEventType(EventType.START);
                break;
            }
            case END_DEPRECIATED: {
                n = this.BEGIN_END_GROUP;
                mesgWithEvent2.setEventType(EventType.STOP);
                break;
            }
            case CONSECUTIVE_DEPRECIATED: {
                mesgWithEvent2.setEventType(EventType.STOP);
                break;
            }
            case END_ALL_DEPRECIATED: {
                n = this.BEGIN_END_GROUP;
                mesgWithEvent2.setEventType(EventType.STOP_ALL);
                break;
            }
        }
        switch (mesgWithEvent2.getEventType()) {
            case START: {
                for (int i = 0; i < this.startedEvents.get(n).size(); ++i) {
                    if (this.startedEvents.get(n).get(i).getEvent() != mesgWithEvent2.getEvent()) continue;
                    MesgWithEvent mesgWithEvent3 = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(n).get(i))));
                    mesgWithEvent3.setEventType(EventType.STOP);
                    mesgWithEvent3.setTimestamp(mesgWithEvent2.getTimestamp());
                    this.broadcast(mesgWithEvent3);
                    this.startedEvents.get(n).remove(i);
                }
                this.startedEvents.get(n).add((MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)mesgWithEvent2))));
                break;
            }
            case STOP: 
            case STOP_DISABLE: {
                for (int i = 0; i < this.startedEvents.get(n).size(); ++i) {
                    if (this.startedEvents.get(n).get(i).getEvent() != mesgWithEvent2.getEvent()) continue;
                    this.startedEvents.get(n).remove(i);
                }
                break;
            }
            case STOP_ALL: {
                for (int i = 0; i < this.startedEvents.get(n).size(); ++i) {
                    if (this.startedEvents.get(n).get(i).getEvent() == mesgWithEvent2.getEvent()) continue;
                    MesgWithEvent mesgWithEvent4 = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(n).get(i))));
                    mesgWithEvent4.setEventType(EventType.STOP);
                    mesgWithEvent4.setTimestamp(mesgWithEvent2.getTimestamp());
                    this.broadcast(mesgWithEvent4);
                }
                this.startedEvents.get(n).clear();
                mesgWithEvent2.setEventType(EventType.STOP);
                break;
            }
            case STOP_DISABLE_ALL: {
                for (int i = 0; i < this.startedEvents.get(n).size(); ++i) {
                    if (this.startedEvents.get(n).get(i).getEvent() == mesgWithEvent2.getEvent()) continue;
                    MesgWithEvent mesgWithEvent5 = (MesgWithEvent)((Object)Factory.createMesg((Mesg)((Object)this.startedEvents.get(n).get(i))));
                    mesgWithEvent5.setEventType(EventType.STOP_DISABLE);
                    mesgWithEvent5.setTimestamp(mesgWithEvent2.getTimestamp());
                    this.broadcast(mesgWithEvent5);
                }
                this.startedEvents.get(n).clear();
                mesgWithEvent2.setEventType(EventType.STOP_DISABLE);
                break;
            }
        }
        this.broadcast(mesgWithEvent2);
    }

    private void broadcast(MesgWithEvent mesgWithEvent) {
        for (MesgWithEventListener mesgWithEventListener : this.listeners) {
            mesgWithEventListener.onMesg(mesgWithEvent);
        }
    }
}

