/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.ContextMenuAction;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;

public class ActionMenu {
    private Action mAction;
    private ActionMenu[] mSubItems;
    private boolean mIsSelected;

    public ActionMenu(Action action, ActionMenu[] subItems) {
        this.mAction = action;
        this.mSubItems = subItems;
    }

    public ActionMenu(String menuTitle, Icon menuIcon, ActionMenu[] subItems) {
        this((Action)new ContextMenuAction(menuTitle, menuIcon), subItems);
    }

    public ActionMenu(String menuTitle, ActionMenu[] subItems) {
        this(menuTitle, (Icon)null, subItems);
    }

    public ActionMenu(Action action, Action[] subItems) {
        this.mAction = action;
        this.mSubItems = new ActionMenu[subItems.length];
        for (int i = 0; i < this.mSubItems.length; ++i) {
            this.mSubItems[i] = new ActionMenu(subItems[i]);
        }
    }

    public ActionMenu(String menuTitle, Icon menuIcon, Action[] subItems) {
        this((Action)new ContextMenuAction(menuTitle, menuIcon), subItems);
    }

    public ActionMenu(String menuTitle, Action[] subItems) {
        this(menuTitle, (Icon)null, subItems);
    }

    public ActionMenu(Action action, Object[] subItems) {
        this.mAction = action;
        ArrayList<ActionMenu> subMenus = new ArrayList<ActionMenu>();
        for (Object subItem : subItems) {
            if (subItem instanceof Action) {
                subMenus.add(new ActionMenu((Action)subItem));
                continue;
            }
            if (!(subItem instanceof ActionMenu)) continue;
            subMenus.add((ActionMenu)subItem);
        }
        this.mSubItems = new ActionMenu[subMenus.size()];
        subMenus.toArray(this.mSubItems);
    }

    public ActionMenu(String menuTitle, Icon menuIcon, Object[] subItems) {
        this((Action)new ContextMenuAction(menuTitle, menuIcon), subItems);
    }

    public ActionMenu(String menuTitle, Object[] subItems) {
        this(menuTitle, null, subItems);
    }

    public ActionMenu(Action action, boolean isSelected) {
        this(action, (ActionMenu[])null);
        this.mIsSelected = isSelected;
    }

    public ActionMenu(Action action) {
        this(action, false);
    }

    public ActionMenu(ActionMenu actionMenu) {
        this(actionMenu.getAction(), actionMenu.getSubItems());
        this.mIsSelected = actionMenu.isSelected();
    }

    public String getTitle() {
        return this.mAction.getValue("Name").toString();
    }

    public ActionMenu[] getSubItems() {
        return this.mSubItems;
    }

    public boolean hasSubItems() {
        return this.mSubItems != null;
    }

    public boolean isSelected() {
        return this.mIsSelected;
    }

    public Action getAction() {
        return this.mAction;
    }
}

