/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.ActionMenu;
import devplugin.Date;
import devplugin.Marker;
import devplugin.NodeFormatter;
import devplugin.Plugin;
import devplugin.PluginTreeListener;
import devplugin.Program;
import devplugin.ProgramItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import tvbrowser.core.TvDataUpdateListener;
import tvbrowser.core.TvDataUpdater;
import tvbrowser.ui.pluginview.Node;
import tvbrowser.ui.pluginview.PluginTreeModel;
import util.program.ProgramUtilities;
import util.ui.Localizer;
import util.ui.UIThreadRunner;

public class PluginTreeNode
implements Comparable<PluginTreeNode> {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginTreeNode.class);
    private byte mNodeType;
    private ArrayList<PluginTreeNode> mChildNodes = null;
    private Object mObject;
    private ArrayList<PluginTreeListener> mNodeListeners;
    private Marker mMarker;
    private Node mDefaultNode;
    private boolean mGroupingByDate;
    private boolean mGroupWeekly;
    private static Date mNodeToday;
    private static Date mNodeTomorrow;
    private static Date mNodeYesterday;

    private PluginTreeNode(byte type, Object object) {
        this.mNodeType = type;
        this.mObject = object;
        this.mDefaultNode = new Node(type, this.mObject);
        this.mNodeListeners = null;
        this.mGroupingByDate = true;
        this.mGroupWeekly = false;
    }

    private PluginTreeNode(int type, Object object) {
        this((byte)type, object);
    }

    public PluginTreeNode(String title) {
        this(4, (Object)title);
    }

    public PluginTreeNode(Marker marker) {
        this(marker, true);
    }

    public PluginTreeNode(Plugin plugin) {
        this(true, plugin);
    }

    public PluginTreeNode(boolean handleTvDataUpdate, Plugin plugin) {
        this(1, (Object)plugin);
        if (handleTvDataUpdate) {
            this.addRemovedProgramsListener();
        }
    }

    public PluginTreeNode(Marker marker, boolean handleTvDataUpdate) {
        this(1, (Object)marker);
        this.mMarker = marker;
        if (handleTvDataUpdate) {
            this.addRemovedProgramsListener();
        }
    }

    private void addRemovedProgramsListener() {
        final RemovedProgramsHandler removedProgramsHandler = new RemovedProgramsHandler();
        TvDataUpdater.getInstance().addTvDataUpdateListener(new TvDataUpdateListener(){

            @Override
            public void tvDataUpdateStarted(Date until) {
                removedProgramsHandler.clear();
            }

            @Override
            public void tvDataUpdateFinished() {
                PluginTreeNode.this.refreshAllPrograms(removedProgramsHandler);
                PluginTreeNode.this.update();
                Program[] removedPrograms = removedProgramsHandler.getRemovedPrograms();
                PluginTreeNode.this.fireProgramsRemoved(removedPrograms);
            }
        });
    }

    public PluginTreeNode(ProgramItem item) {
        this(2, (Object)item);
        this.mDefaultNode.setAllowsChildren(false);
    }

    public void addNodeListener(PluginTreeListener listener) {
        if (this.mNodeListeners == null) {
            this.mNodeListeners = new ArrayList(1);
        }
        this.mNodeListeners.add(listener);
    }

    public boolean removeNodeListener(PluginTreeListener listener) {
        if (this.mNodeListeners == null) {
            return false;
        }
        return this.mNodeListeners.remove(listener);
    }

    public void removeAllNodeListeners() {
        if (this.mNodeListeners == null) {
            return;
        }
        this.mNodeListeners.clear();
        this.mNodeListeners = null;
    }

    private synchronized void refreshAllPrograms(RemovedProgramsHandler handler) {
        if (this.mChildNodes == null) {
            return;
        }
        for (int i = this.mChildNodes.size() - 1; i >= 0; --i) {
            PluginTreeNode node = this.mChildNodes.get(i);
            node.mMarker = this.mMarker;
            if (node.isLeaf()) {
                ProgramItem progItemInTree = (ProgramItem)node.getUserObject();
                Program progInTree = progItemInTree.getProgram();
                if (progInTree == null) {
                    node.removeProgram(progItemInTree);
                    continue;
                }
                if (progInTree.getProgramState() == 2) {
                    this.removeProgram(progInTree);
                    handler.addRemovedProgram(progInTree);
                    continue;
                }
                if (progInTree.getProgramState() != 1) continue;
                Program updatedProg = Plugin.getPluginManager().getProgram(progInTree.getDate(), progInTree.getID());
                progItemInTree.setProgram(updatedProg);
                continue;
            }
            node.refreshAllPrograms(handler);
        }
    }

    private void fireProgramsRemoved(Program[] progArr) {
        if (this.mNodeListeners == null) {
            return;
        }
        for (int i = 0; i < this.mNodeListeners.size(); ++i) {
            PluginTreeListener listener = this.mNodeListeners.get(i);
            listener.programsRemoved(progArr);
        }
    }

    public Node getMutableTreeNode() {
        return this.mDefaultNode;
    }

    public void addActionMenu(ActionMenu menu) {
        this.mDefaultNode.addActionMenu(menu);
    }

    public void removeAllActions() {
        this.mDefaultNode.removeAllActionMenus();
    }

    public void addAction(Action action) {
        this.addActionMenu(new ActionMenu(action));
    }

    public ActionMenu[] getActionMenus() {
        return this.mDefaultNode.getActionMenus();
    }

    public void setNodeFormatter(NodeFormatter formatter) {
        this.mDefaultNode.setNodeFormatter(formatter);
    }

    public void setGroupingByDateEnabled(boolean enable) {
        this.mGroupingByDate = enable;
    }

    public void setGroupingByWeekEnabled(boolean enable) {
        this.mGroupWeekly = enable;
    }

    private NodeFormatter getNodeFormatter(boolean isWeekNodesEnabled) {
        return this.mDefaultNode.getNodeFormatter(isWeekNodesEnabled);
    }

    private void createDefaultNodes() {
        this.mDefaultNode.removeAllChildren();
        if (this.mChildNodes == null) {
            return;
        }
        Object[] items = this.mChildNodes.toArray(new PluginTreeNode[this.mChildNodes.size()]);
        Arrays.sort(items);
        Date currentDate = null;
        for (Object n : items) {
            if (!((PluginTreeNode)n).isLeaf()) {
                if (((PluginTreeNode)n).mGroupingByDate) {
                    super.createDateNodes();
                } else {
                    super.createDefaultNodes();
                }
                this.mDefaultNode.add(((PluginTreeNode)n).getMutableTreeNode());
                continue;
            }
            if (((PluginTreeNode)n).mNodeType == 2) {
                ProgramItem progItem = (ProgramItem)((PluginTreeNode)n).getUserObject();
                Node node = ((PluginTreeNode)n).getMutableTreeNode();
                if (currentDate == null) {
                    currentDate = Date.getCurrentDate();
                }
                if (progItem.getProgram().getDate().addDays(1).compareTo(currentDate) < 0) continue;
                this.mDefaultNode.add(node);
                continue;
            }
            this.mDefaultNode.add(((PluginTreeNode)n).getMutableTreeNode());
        }
    }

    private void createDateNodes() {
        boolean createWeekNodes;
        this.mDefaultNode.removeAllChildren();
        if (this.mChildNodes == null || this.mChildNodes.size() == 0) {
            return;
        }
        HashMap<Date, ArrayList<PluginTreeNode>> dateMap = new HashMap<Date, ArrayList<PluginTreeNode>>();
        for (PluginTreeNode n : this.mChildNodes) {
            if (!n.isLeaf()) {
                if (n.mGroupingByDate) {
                    n.createDateNodes();
                } else {
                    n.createDefaultNodes();
                }
                this.mDefaultNode.add(n.getMutableTreeNode());
                continue;
            }
            Date date = ((ProgramItem)n.getUserObject()).getDate();
            if (date.compareTo(mNodeYesterday) < 0) continue;
            ArrayList<PluginTreeNode> list = (ArrayList<PluginTreeNode>)dateMap.get(date);
            if (list == null) {
                list = new ArrayList<PluginTreeNode>();
                dateMap.put(date, list);
            }
            list.add(n);
        }
        Set keySet = dateMap.keySet();
        Object[] dates = new Date[keySet.size()];
        keySet.toArray(dates);
        Arrays.sort(dates);
        Node node = null;
        String lastDateStr = "";
        int numPrograms = 0;
        for (Object date : dates) {
            numPrograms += ((ArrayList)dateMap.get(date)).size();
        }
        boolean isShowingWeekNodes = createWeekNodes = this.mGroupWeekly && numPrograms <= dates.length * 2;
        for (Object date : dates) {
            String dateStr;
            if (mNodeYesterday.equals(date)) {
                dateStr = Localizer.getLocalization("i18n_yesterday");
                isShowingWeekNodes = false;
            } else if (mNodeToday.equals(date)) {
                dateStr = Localizer.getLocalization("i18n_today");
                isShowingWeekNodes = false;
            } else if (mNodeTomorrow.equals(date)) {
                dateStr = Localizer.getLocalization("i18n_tomorrow");
                isShowingWeekNodes = false;
            } else {
                int weeks;
                dateStr = createWeekNodes ? ((weeks = ((Date)date).getNumberOfDaysSince(mNodeToday) / 7) <= 3 ? mLocalizer.msg("weeks." + weeks, "in {0} weeks", weeks) : mLocalizer.msg("weeks.later", "later")) : ((Date)date).getLongDateString();
            }
            if (!dateStr.equals(lastDateStr)) {
                node = new Node(3, (Object)dateStr);
                this.mDefaultNode.add(node);
                lastDateStr = dateStr;
            }
            List list = (List)dateMap.get(date);
            Object[] nodeArr = new PluginTreeNode[list.size()];
            list.toArray(nodeArr);
            Arrays.sort(nodeArr);
            for (Object element : nodeArr) {
                Node newNode = new Node((ProgramItem)((PluginTreeNode)element).getUserObject());
                newNode.setNodeFormatter(super.getNodeFormatter(createWeekNodes && isShowingWeekNodes));
                node.add(newNode);
            }
            isShowingWeekNodes = createWeekNodes;
        }
    }

    public Object getUserObject() {
        return this.mObject;
    }

    public synchronized void removeAllChildren() {
        if (this.mMarker != null) {
            Program[] programs;
            for (Program program : programs = this.getPrograms()) {
                program.unmark(this.mMarker);
            }
        }
        if (this.mChildNodes != null) {
            this.mChildNodes.clear();
            this.mChildNodes = null;
        }
        this.mDefaultNode.removeAllChildren();
    }

    public synchronized void add(PluginTreeNode node) {
        if (this.mChildNodes == null) {
            this.mChildNodes = new ArrayList(1);
        }
        this.mChildNodes.add(node);
        node.mMarker = this.mMarker;
    }

    public boolean contains(Program prog, boolean recursive) {
        PluginTreeNode node = this.findProgramTreeNode(prog, recursive);
        return node != null;
    }

    public boolean contains(Program prog) {
        return this.contains(prog, false);
    }

    public synchronized void update() {
        mNodeToday = Date.getCurrentDate();
        mNodeTomorrow = mNodeToday.addDays(1);
        mNodeYesterday = mNodeToday.addDays(-1);
        if (this.mGroupingByDate) {
            this.createDateNodes();
        } else {
            this.createDefaultNodes();
        }
        UIThreadRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                PluginTreeModel.getInstance().reload(PluginTreeNode.this.mDefaultNode);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPrograms(List<Program> listNew) {
        List<Program> list = listNew;
        synchronized (list) {
            Iterator<Program> newIt = listNew.iterator();
            if (this.mChildNodes != null && this.mChildNodes.size() > 0) {
                Program[] currentProgs = this.getPrograms();
                ArrayList<Program> listCurrent = new ArrayList<Program>(currentProgs.length);
                for (Program currentProg : currentProgs) {
                    listCurrent.add(currentProg);
                }
                Comparator<Program> comp = ProgramUtilities.getProgramComparator();
                Collections.sort(listCurrent, comp);
                Collections.sort(listNew, comp);
                Iterator currentIt = listCurrent.iterator();
                if (currentIt.hasNext() && newIt.hasNext()) {
                    Program currentProg;
                    Program newProg = newIt.next();
                    currentProg = (Program)currentIt.next();
                    while (newProg != null && currentProg != null) {
                        int comparison = comp.compare(newProg, currentProg);
                        if (comparison < 0) {
                            this.markAndAdd(newProg);
                            if (newIt.hasNext()) {
                                newProg = newIt.next();
                                continue;
                            }
                            newProg = null;
                            continue;
                        }
                        if (comparison > 0) {
                            if (currentIt.hasNext()) {
                                currentProg = (Program)currentIt.next();
                                continue;
                            }
                            currentProg = null;
                            continue;
                        }
                        if (comparison != 0) continue;
                        currentProg = currentIt.hasNext() ? (Program)currentIt.next() : null;
                        if (newIt.hasNext()) {
                            newProg = newIt.next();
                            continue;
                        }
                        newProg = null;
                    }
                }
            }
            while (newIt.hasNext()) {
                this.markAndAdd(newIt.next());
            }
        }
    }

    private void markAndAdd(Program program) {
        if (this.mMarker != null) {
            program.mark(this.mMarker);
        }
        PluginTreeNode node = new PluginTreeNode(new ProgramItem(program));
        this.add(node);
    }

    public synchronized PluginTreeNode addProgram(Program program) {
        if (program == null) {
            return null;
        }
        PluginTreeNode node = this.findProgramTreeNode(program, false);
        if (node != null) {
            return node;
        }
        if (this.mMarker != null) {
            program.mark(this.mMarker);
        }
        node = new PluginTreeNode(new ProgramItem(program));
        this.add(node);
        return node;
    }

    public synchronized PluginTreeNode addProgramWithoutCheck(Program program) {
        if (this.mMarker != null) {
            program.mark(this.mMarker);
        }
        PluginTreeNode node = new PluginTreeNode(new ProgramItem(program));
        this.add(node);
        return node;
    }

    private PluginTreeNode findProgramTreeNode(PluginTreeNode root, Program prog, boolean recursive) {
        if (root.mChildNodes != null) {
            for (PluginTreeNode node : root.mChildNodes) {
                if (!node.isLeaf()) {
                    PluginTreeNode n;
                    if (!recursive || (n = this.findProgramTreeNode(node, prog, recursive)) == null) continue;
                    return n;
                }
                ProgramItem item = (ProgramItem)node.getUserObject();
                if (item == null || !prog.equals(item.getProgram())) continue;
                return node;
            }
        }
        return null;
    }

    private PluginTreeNode findProgramTreeNode(Program prog, boolean recursive) {
        return this.findProgramTreeNode(this, prog, recursive);
    }

    public synchronized void removeProgram(ProgramItem item) {
        this.removeProgram(item.getProgram());
    }

    public synchronized void removeProgram(Program program) {
        PluginTreeNode node = this.findProgramTreeNode(program, false);
        if (node != null) {
            this.mChildNodes.remove(node);
            if (this.mMarker != null) {
                program.unmark(this.mMarker);
            }
        }
    }

    public synchronized PluginTreeNode addNode(String title) {
        PluginTreeNode node = new PluginTreeNode(title);
        this.add(node);
        return node;
    }

    public ProgramItem[] getProgramItems() {
        if (this.mChildNodes == null) {
            return new ProgramItem[0];
        }
        ArrayList<Object> list = new ArrayList<Object>();
        this.addProgramItemsTo(list);
        ProgramItem[] result = new ProgramItem[list.size()];
        list.toArray(result);
        return result;
    }

    private void addProgramItemsTo(ArrayList<Object> list) {
        if (this.mChildNodes == null || this.mChildNodes.isEmpty()) {
            return;
        }
        for (PluginTreeNode n : this.mChildNodes) {
            if (n.isLeaf()) {
                list.add(n.getUserObject());
                continue;
            }
            n.addProgramItemsTo(list);
        }
    }

    public Program[] getPrograms() {
        if (this.mChildNodes == null) {
            return new Program[0];
        }
        ArrayList<Program> list = new ArrayList<Program>();
        this.addProgramsTo(list);
        Program[] result = new Program[list.size()];
        list.toArray(result);
        return result;
    }

    private void addProgramsTo(ArrayList<Program> list) {
        if (this.mChildNodes == null || this.mChildNodes.isEmpty()) {
            return;
        }
        for (PluginTreeNode n : this.mChildNodes) {
            if (n.isLeaf()) {
                ProgramItem item = (ProgramItem)n.getUserObject();
                Program program = item.getProgram();
                if (program == null) continue;
                list.add(program);
                continue;
            }
            n.addProgramsTo(list);
        }
    }

    public void store(ObjectOutputStream out) throws IOException {
        int childrenCnt = 0;
        if (this.mChildNodes != null) {
            childrenCnt = this.mChildNodes.size();
        }
        out.writeInt(childrenCnt);
        for (int i = 0; i < childrenCnt; ++i) {
            PluginTreeNode n = this.mChildNodes.get(i);
            out.writeInt(n.mNodeType);
            if (n.mNodeType == 2) {
                ProgramItem item = (ProgramItem)n.getUserObject();
                item.write(out);
            } else {
                String title = (String)n.getUserObject();
                out.writeObject(title);
            }
            n.store(out);
        }
    }

    public void load(ObjectInputStream in) throws IOException {
        int cnt = in.readInt();
        for (int i = 0; i < cnt; ++i) {
            PluginTreeNode n;
            int type = in.readInt();
            if (type == 2) {
                ProgramItem item = new ProgramItem();
                try {
                    item.read(in);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                Program program = item.getProgram();
                n = new PluginTreeNode(item);
                if (program != null) {
                    this.add(n);
                    if (this.mMarker != null) {
                        item.getProgram().mark(this.mMarker);
                    }
                }
            } else {
                try {
                    String title = (String)in.readObject();
                    n = new PluginTreeNode(title);
                    this.add(n);
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    return;
                }
            }
            n.load(in);
        }
    }

    public int size() {
        if (this.mChildNodes == null) {
            return 0;
        }
        return this.mChildNodes.size();
    }

    public synchronized void clear() {
        if (this.mChildNodes == null) {
            return;
        }
        this.mChildNodes.clear();
        this.mChildNodes = null;
    }

    public boolean isEmpty() {
        return this.mChildNodes == null || this.mChildNodes.isEmpty();
    }

    public boolean isLeaf() {
        return this.mDefaultNode.getType() == 2;
    }

    public String toString() {
        switch (this.mNodeType) {
            case 1: {
                return "plugin node: " + this.mObject.toString();
            }
            case 2: {
                return "program node: " + this.mObject.toString();
            }
            case 3: {
                return "structure node: " + this.mObject.toString();
            }
            case 4: {
                return "custom node: " + this.mObject.toString();
            }
        }
        return super.toString();
    }

    public PluginTreeNode[] getChildren() {
        if (this.mChildNodes == null) {
            return new PluginTreeNode[0];
        }
        return this.mChildNodes.toArray(new PluginTreeNode[this.mChildNodes.size()]);
    }

    @Override
    public int compareTo(PluginTreeNode other) {
        Object otherUserObject = other.getUserObject();
        if (this.mObject instanceof ProgramItem && otherUserObject instanceof ProgramItem) {
            return ((ProgramItem)this.mObject).compareTo((ProgramItem)otherUserObject);
        }
        if (this.mObject instanceof String && otherUserObject instanceof String) {
            return ((String)this.mObject).compareToIgnoreCase((String)otherUserObject);
        }
        if (this.mObject instanceof String) {
            return 1;
        }
        return -1;
    }

    public static class RemovedProgramsHandler {
        private ArrayList<Program> mProgArr = new ArrayList();

        public void clear() {
            this.mProgArr.clear();
        }

        public void addRemovedProgram(Program prog) {
            this.mProgArr.add(prog);
        }

        public Program[] getRemovedPrograms() {
            Program[] progArr = new Program[this.mProgArr.size()];
            this.mProgArr.toArray(progArr);
            return progArr;
        }
    }
}

