/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.ChannelFilter;
import devplugin.ChannelFilterChangeListener;
import java.util.ArrayList;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import util.exc.TvBrowserException;

public class ChannelFilterList {
    private ArrayList<ChannelFilter> mChannelFilterList;
    private ArrayList<ChannelFilterChangeListener> mChannelFilterChangeListenerList;
    private static ChannelFilterList INSTANCE;

    private ChannelFilterList() {
        INSTANCE = this;
        this.mChannelFilterList = new ArrayList(0);
        this.mChannelFilterChangeListenerList = new ArrayList(0);
    }

    public static final synchronized ChannelFilterList getInstance() {
        if (INSTANCE == null) {
            new ChannelFilterList();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChannelFilter getChannelFilterForName(String name) {
        ArrayList<ChannelFilter> arrayList = this.mChannelFilterList;
        synchronized (arrayList) {
            for (ChannelFilter filter : this.mChannelFilterList) {
                if (!filter.getName().equals(name)) continue;
                return filter;
            }
            try {
                ChannelFilter test = ChannelFilter.createChannelFilterForName(name);
                this.mChannelFilterList.add(test);
                return test;
            }
            catch (ClassCastException e) {
            }
            catch (TvBrowserException tvBrowserException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ChannelFilter[] getAvailableChannelFilter() {
        ArrayList<ChannelFilter> arrayList = this.mChannelFilterList;
        synchronized (arrayList) {
            String[] names = FilterComponentList.getInstance().getChannelFilterNames();
            ArrayList<String> foundNames = new ArrayList<String>();
            block6: for (ChannelFilter filter : this.mChannelFilterList) {
                for (String name : names) {
                    if (!filter.getName().equals(name)) continue;
                    foundNames.add(name);
                    continue block6;
                }
            }
            for (String name : names) {
                if (foundNames.contains(name)) continue;
                try {
                    ChannelFilter test = ChannelFilter.createChannelFilterForName(name);
                    this.mChannelFilterList.add(test);
                }
                catch (ClassCastException e) {
                }
                catch (TvBrowserException e) {
                    // empty catch block
                }
            }
            return this.mChannelFilterList.toArray(new ChannelFilter[this.mChannelFilterList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeChannelFilter(ChannelFilter filter) {
        ArrayList<ChannelFilter> arrayList = this.mChannelFilterList;
        synchronized (arrayList) {
            this.mChannelFilterList.remove(filter);
        }
    }

    void registerChannelFilterChangeListener(ChannelFilterChangeListener listener) {
        this.mChannelFilterChangeListenerList.add(listener);
    }

    void unregisterChannelFilterChangeListener(ChannelFilterChangeListener listener) {
        this.mChannelFilterChangeListenerList.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChannelFilterAdded(ChannelFilterComponent filterComponent) {
        ArrayList<ChannelFilter> arrayList = this.mChannelFilterList;
        synchronized (arrayList) {
            ChannelFilter filter = this.getChannelFilterForName(filterComponent.getName());
            if (filter != null) {
                for (ChannelFilterChangeListener listener : this.mChannelFilterChangeListenerList) {
                    listener.channelFilterAdded(filter);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireChannelFilterRemoved(ChannelFilterComponent filterComponent) {
        ArrayList<ChannelFilter> arrayList = this.mChannelFilterList;
        synchronized (arrayList) {
            for (int i = this.mChannelFilterList.size() - 1; i >= 0; --i) {
                if (!this.mChannelFilterList.get(i).getName().equals(filterComponent.getName())) continue;
                ChannelFilter filter = this.mChannelFilterList.remove(i);
                for (ChannelFilterChangeListener listener : this.mChannelFilterChangeListenerList) {
                    listener.channelFilterRemoved(filter);
                }
                break;
            }
        }
    }
}

