/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import devplugin.Channel;
import devplugin.PluginAccess;
import devplugin.PluginsFilterComponent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Set;
import java.util.logging.Logger;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.ChannelFilterList;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.AgeLimitFilterComponent;
import tvbrowser.core.filters.filtercomponents.BeanShellFilterComponent;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.DateFilterComponent;
import tvbrowser.core.filters.filtercomponents.DayFilterComponent;
import tvbrowser.core.filters.filtercomponents.FavoritesFilterComponent;
import tvbrowser.core.filters.filtercomponents.KeywordFilterComponent;
import tvbrowser.core.filters.filtercomponents.MassFilterComponent;
import tvbrowser.core.filters.filtercomponents.PluginFilterComponent;
import tvbrowser.core.filters.filtercomponents.PluginIconFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramInfoFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramLengthFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramMarkingPriorityFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramRunningFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramTypeFilterComponent;
import tvbrowser.core.filters.filtercomponents.ReminderFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleTitleFilterComponent;
import tvbrowser.core.filters.filtercomponents.TimeFilterComponent;
import tvbrowser.core.plugin.PluginManagerImpl;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class FilterComponentList {
    private static FilterComponentList mInstance;
    private static ArrayList<FilterComponent> mComponentList;
    private static final Logger mLog;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_NONE = 0;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_PARTLY = 1;
    private static final int TYPE_BROKEN_FILTER_COMPONENT_COMPLETELY = 2;

    private FilterComponentList() {
        mComponentList = new ArrayList();
        File filterCompFile = new File(FilterList.FILTER_DIRECTORY, "filter.comp");
        if (filterCompFile.exists() && filterCompFile.isFile()) {
            StreamUtilities.objectInputStreamIgnoringExceptions(filterCompFile, 4096, new ObjectInputStreamProcessor(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void process(ObjectInputStream in) throws IOException {
                    int version = in.readInt();
                    int compCnt = in.readInt();
                    for (int i = 0; i < compCnt; ++i) {
                        if (version == 1) {
                            FilterComponent comp = null;
                            try {
                                comp = FilterComponentList.this.readComponent(in);
                            }
                            catch (IOException e) {
                                mLog.warning("error reading filter component: " + e);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                            }
                            if (comp == null) continue;
                            ArrayList e = mComponentList;
                            synchronized (e) {
                                mComponentList.add(comp);
                                continue;
                            }
                        }
                        if (version != 2) continue;
                        String key = in.readUTF();
                        File componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + key + ".dat");
                        StreamUtilities.objectInputStreamIgnoringExceptions(componentFile, 4096, new ObjectInputStreamProcessor(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void process(ObjectInputStream inputStream) throws IOException {
                                inputStream.readInt();
                                int size = inputStream.readInt();
                                for (int j = 0; j < size; ++j) {
                                    FilterComponent comp = null;
                                    try {
                                        comp = FilterComponentList.this.readComponent(inputStream);
                                    }
                                    catch (IOException e) {
                                        mLog.warning("error reading filter component: " + e);
                                    }
                                    catch (ClassNotFoundException e) {
                                        e.printStackTrace();
                                    }
                                    if (comp == null) continue;
                                    ArrayList arrayList = mComponentList;
                                    synchronized (arrayList) {
                                        mComponentList.add(comp);
                                        continue;
                                    }
                                }
                            }
                        });
                    }
                    in.close();
                }
            });
        }
    }

    public ArrayList<SingleChannelFilterComponent> updateChannels(Channel[] channels) {
        ArrayList<SingleChannelFilterComponent> toRemove = new ArrayList<SingleChannelFilterComponent>();
        ArrayList<Channel> toAdd = new ArrayList<Channel>();
        toAdd.addAll(Arrays.asList(channels));
        ArrayList<String> acceptNoneFilterComponentNames = new ArrayList<String>();
        ArrayList<SingleChannelFilterComponent> chammelNameUpdateList = new ArrayList<SingleChannelFilterComponent>();
        for (FilterComponent test : mComponentList) {
            if (test instanceof SingleChannelFilterComponent) {
                boolean found = false;
                for (Channel ch : channels) {
                    if (!((SingleChannelFilterComponent)test).containsChannel(ch)) continue;
                    toAdd.remove(ch);
                    found = true;
                    break;
                }
                if (!found) {
                    toRemove.add((SingleChannelFilterComponent)test);
                    continue;
                }
                if (!((SingleChannelFilterComponent)test).isNameToUpdate()) continue;
                chammelNameUpdateList.add((SingleChannelFilterComponent)test);
                continue;
            }
            if (!(test instanceof AcceptNoneFilterComponent)) continue;
            acceptNoneFilterComponentNames.add(test.getName());
        }
        for (SingleChannelFilterComponent remove : toRemove) {
            mComponentList.remove(remove);
        }
        for (Channel ch : toAdd) {
            SingleChannelFilterComponent test = new SingleChannelFilterComponent(ch);
            if (acceptNoneFilterComponentNames.contains(test.getName())) {
                this.remove(test.getName());
            }
            mComponentList.add(test);
        }
        return chammelNameUpdateList;
    }

    public void store() {
        final HashMap<String, ArrayList<FilterComponent>> filterTable = new HashMap<String, ArrayList<FilterComponent>>();
        for (FilterComponent component : mComponentList) {
            ArrayList<FilterComponent> componentList = (ArrayList<FilterComponent>)filterTable.get(component.getClass().getCanonicalName());
            if (componentList == null) {
                componentList = new ArrayList<FilterComponent>();
                filterTable.put(component.getClass().getCanonicalName(), componentList);
            }
            componentList.add(component);
        }
        File filterCompFile = new File(FilterList.FILTER_DIRECTORY, "filter.comp");
        StreamUtilities.objectOutputStreamIgnoringExceptions(filterCompFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                out.writeInt(2);
                out.writeInt(filterTable.size());
                Set filterKeys = filterTable.keySet();
                for (String key : filterKeys) {
                    out.writeUTF(key);
                    File componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + key + ".dat");
                    final ArrayList list = (ArrayList)filterTable.get(key);
                    StreamUtilities.objectOutputStreamIgnoringExceptions(componentFile, new ObjectOutputStreamProcessor(){

                        @Override
                        public void process(ObjectOutputStream outputStream) throws IOException {
                            outputStream.writeInt(1);
                            outputStream.writeInt(list.size());
                            for (FilterComponent comp : list) {
                                FilterComponentList.this.writeComponent(outputStream, comp);
                            }
                            outputStream.close();
                        }
                    });
                }
                out.close();
            }
        });
    }

    private void writeComponent(ObjectOutputStream out, FilterComponent comp) throws IOException {
        out.writeObject(comp.getClass().getName());
        out.writeInt(comp.getVersion());
        out.writeObject(comp.getName());
        out.writeObject(comp.getDescription());
        comp.write(out);
    }

    private FilterComponent readComponent(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String className = (String)in.readObject();
        int version = in.readInt();
        String name = (String)in.readObject();
        String description = (String)in.readObject();
        FilterComponent filterComponent = null;
        if (className.endsWith(".AgeLimitFilterComponent")) {
            filterComponent = new AgeLimitFilterComponent(name, description);
        } else if (className.endsWith(".BeanShellFilterComponent")) {
            filterComponent = new BeanShellFilterComponent(name, description);
        } else if (className.endsWith(".ChannelFilterComponent")) {
            filterComponent = new ChannelFilterComponent(name, description);
        } else if (className.endsWith(".DayFilterComponent")) {
            filterComponent = new DayFilterComponent(name, description);
        } else if (className.endsWith(".DateFilterComponent")) {
            filterComponent = new DateFilterComponent(name, description);
        } else if (className.endsWith(".FavoritesFilterComponent")) {
            filterComponent = new FavoritesFilterComponent(name, description);
        } else if (className.endsWith(".KeywordFilterComponent")) {
            filterComponent = new KeywordFilterComponent(name, description);
        } else if (className.endsWith(".MassFilterComponent")) {
            filterComponent = new MassFilterComponent(name, description);
        } else if (className.endsWith(".PluginFilterComponent")) {
            filterComponent = new PluginFilterComponent(name, description);
        } else if (className.endsWith(".PluginIconFilterComponent")) {
            filterComponent = new PluginIconFilterComponent(name, description);
        } else if (className.endsWith(".ProgramInfoFilterComponent")) {
            filterComponent = new ProgramInfoFilterComponent(name, description);
        } else if (className.endsWith(".ProgramLengthFilterComponent")) {
            filterComponent = new ProgramLengthFilterComponent(name, description);
        } else if (className.endsWith(".ProgramMarkingPriorityFilterComponent")) {
            filterComponent = new ProgramMarkingPriorityFilterComponent(name, description);
        } else if (className.endsWith(".ProgramRunningFilterComponent")) {
            filterComponent = new ProgramRunningFilterComponent(name, description);
        } else if (className.endsWith(".ProgramTypeFilterComponent")) {
            filterComponent = new ProgramTypeFilterComponent(name, description);
        } else if (className.endsWith(".ReminderFilterComponent")) {
            filterComponent = new ReminderFilterComponent(name, description);
        } else if (className.endsWith(".SingleTitleFilterComponent")) {
            filterComponent = new SingleTitleFilterComponent(name, description);
        } else if (className.endsWith(".TimeFilterComponent")) {
            filterComponent = new TimeFilterComponent(name, description);
        } else if (className.endsWith(".SingleChannelFilterComponent")) {
            filterComponent = new SingleChannelFilterComponent(null);
        } else if (className.endsWith(".AcceptNoneFilterComponent")) {
            filterComponent = new AcceptNoneFilterComponent(name);
        } else {
            try {
                PluginAccess[] plugins;
                block2: for (PluginAccess plugin : plugins = PluginManagerImpl.getInstance().getActivatedPlugins()) {
                    Class<? extends PluginsFilterComponent>[] clazzes = plugin.getAvailableFilterComponentClasses();
                    if (clazzes == null) continue;
                    for (Class<? extends PluginsFilterComponent> clazz : clazzes) {
                        if (clazz.getName().compareTo(className) != 0) continue;
                        filterComponent = clazz.newInstance();
                        continue block2;
                    }
                }
                filterComponent.setName(name);
                filterComponent.setDescription(description);
            }
            catch (Exception e) {
                mLog.warning("error reading filter component: " + className + " unknown");
                return null;
            }
        }
        if (filterComponent != null) {
            filterComponent.read(in, version);
            if (filterComponent instanceof PluginFilterComponent) {
                String pluginId = ((PluginFilterComponent)filterComponent).getPluginId();
                if (pluginId.compareTo("java.reminderplugin.ReminderPlugin") == 0) {
                    filterComponent = new ReminderFilterComponent(name, description);
                } else if (pluginId.compareTo("java.favoritesplugin.FavoritesPlugin") == 0) {
                    filterComponent = new FavoritesFilterComponent(name, description);
                }
            }
        }
        return filterComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterComponent[] getAvailableFilterComponents() {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            return mComponentList.toArray(new FilterComponent[mComponentList.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilterComponent getFilterComponentByName(String name) {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            for (FilterComponent c : mComponentList) {
                if (c.getName().compareTo(name) != 0) continue;
                return c;
            }
        }
        return null;
    }

    public static synchronized FilterComponentList getInstance() {
        if (mInstance == null) {
            mInstance = new FilterComponentList();
            Settings.updateChannelFilters(ChannelList.getSubscribedChannels(), false);
        }
        return mInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(FilterComponent comp) {
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            String name = comp.getName();
            for (int i = 0; i < mComponentList.size(); ++i) {
                if (!name.equals(mComponentList.get(i).getName()) || !(mComponentList.get(i) instanceof AcceptNoneFilterComponent)) continue;
                mComponentList.remove(i);
                break;
            }
            mComponentList.add(comp);
        }
        this.store();
        if (comp instanceof ChannelFilterComponent) {
            ChannelFilterList.getInstance().fireChannelFilterAdded((ChannelFilterComponent)comp);
        }
    }

    public boolean exists(String name) {
        FilterComponent c = this.getFilterComponentByName(name);
        return c != null && !(c instanceof AcceptNoneFilterComponent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(String filterCompName) {
        FilterComponent filterComp = this.getFilterComponentByName(filterCompName);
        ArrayList<FilterComponent> arrayList = mComponentList;
        synchronized (arrayList) {
            if (mComponentList.remove(filterComp)) {
                if (filterComp instanceof ChannelFilterComponent) {
                    ChannelFilterList.getInstance().fireChannelFilterRemoved((ChannelFilterComponent)filterComp);
                }
                String key = filterComp.getClass().getCanonicalName();
                File componentFile = new File(FilterList.FILTER_DIRECTORY, "java." + key + ".dat");
                if (componentFile.isFile() && !componentFile.delete()) {
                    componentFile.deleteOnExit();
                }
            }
        }
        this.store();
    }

    public String[] getChannelFilterNames() {
        ArrayList<String> channelFilters = new ArrayList<String>();
        for (FilterComponent component : this.getAvailableFilterComponents()) {
            if (!(component instanceof ChannelFilterComponent)) continue;
            channelFilters.add(component.getName());
        }
        Object[] sortedArray = new String[channelFilters.size()];
        channelFilters.toArray(sortedArray);
        Arrays.sort(sortedArray);
        return sortedArray;
    }

    public static final String getLabelForComponent(FilterComponent component, String label) {
        int type;
        String result = component != null && label == null ? component.getName() : (label != null ? label : null);
        int n = type = component instanceof AcceptNoneFilterComponent ? 2 : 0;
        if (type == 0) {
            try {
                Method isBrokenCompletely = component.getClass().getMethod("isBrokenCompletely", new Class[0]);
                Object brokenResult = isBrokenCompletely.invoke((Object)component, new Object[0]);
                if (brokenResult instanceof Boolean && ((Boolean)brokenResult).booleanValue()) {
                    type = 2;
                } else {
                    Method isBrokenPartially = component.getClass().getMethod("isBrokenPartially", new Class[0]);
                    brokenResult = isBrokenPartially.invoke((Object)component, new Object[0]);
                    if (brokenResult instanceof Boolean && ((Boolean)brokenResult).booleanValue()) {
                        type = 1;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        switch (type) {
            case 2: {
                result = UserFilter.getLabelForBrokenCompletely(result);
                break;
            }
            case 1: {
                result = UserFilter.getLabelForBrokenPartially(result);
            }
        }
        return result;
    }

    static {
        mLog = Logger.getLogger(FilterComponentList.class.getName());
    }
}

