/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.ui.mainframe.MainFrame;

public class GenericFilterMap {
    private static File mGenericFilterDirectory;
    private File mGenericFilterProp;
    protected static final String GENERIC_PLUGIN_FILTER_DIRECTORY;
    private static final String GENRIC_FILTER_PROP = "genericfilters.prop";
    private HashMap<String, GenericFilterHolder> mGenericPluginFilterMap = new HashMap();
    private GenericFilterHolder mGenericPictureFilterHolder;
    private static final String GENERIC_PICTURE_FILTER_NAME = "_picture";
    private static GenericFilterMap INSTANCE;

    private GenericFilterMap() {
        this.create();
    }

    private void create() {
        mGenericFilterDirectory = new File(GENERIC_PLUGIN_FILTER_DIRECTORY);
        this.mGenericFilterProp = new File(mGenericFilterDirectory, GENRIC_FILTER_PROP);
        if (!mGenericFilterDirectory.exists()) {
            mGenericFilterDirectory.mkdirs();
        }
        this.loadFilters();
    }

    public static final synchronized GenericFilterMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new GenericFilterMap();
        }
        return INSTANCE;
    }

    private void loadFilters() {
        try {
            File pictureFilterFile;
            if (this.mGenericFilterProp.isFile()) {
                Properties prop = new Properties();
                try {
                    FileInputStream in = new FileInputStream(this.mGenericFilterProp);
                    prop.load(in);
                    in.close();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                Enumeration<Object> keys = prop.keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String activatedValue = prop.getProperty(key, null);
                    if (activatedValue == null) continue;
                    boolean activated = Boolean.parseBoolean(activatedValue);
                    GenericFilterHolder holder = new GenericFilterHolder(activated, new File(mGenericFilterDirectory, key + ".filter"));
                    this.mGenericPluginFilterMap.put(key, holder);
                }
            }
            if ((pictureFilterFile = new File(mGenericFilterDirectory, "_picture.filter")).isFile()) {
                this.mGenericPictureFilterHolder = new GenericFilterHolder(true, pictureFilterFile);
            } else {
                this.mGenericPictureFilterHolder = new GenericFilterHolder();
                this.mGenericPictureFilterHolder.setActivated(true);
                this.mGenericPictureFilterHolder.setFilter(new UserFilter(GENERIC_PICTURE_FILTER_NAME));
                this.mGenericPictureFilterHolder.getFilter().setRule("");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void updateGenericPluginFilterActivated(PluginProxy plugin, boolean activated) {
        GenericFilterHolder holder = this.mGenericPluginFilterMap.get(plugin.getId());
        if (holder != null) {
            holder.setActivated(activated);
        }
    }

    public void updateGenericPluginFilter(PluginProxy plugin, UserFilter filter, boolean activated) {
        if (filter != null) {
            GenericFilterHolder holder = this.mGenericPluginFilterMap.get(plugin.getId());
            if (holder == null) {
                holder = new GenericFilterHolder();
                this.mGenericPluginFilterMap.put(plugin.getId(), holder);
            }
            holder.setActivated(activated);
            holder.setFilter(filter);
        } else {
            this.mGenericPluginFilterMap.remove(plugin.getId());
        }
        this.storeGenericFilters();
    }

    public UserFilter getGenericPluginFilter(PluginProxy plugin, boolean onlyActivated) {
        GenericFilterHolder holder = this.mGenericPluginFilterMap.get(plugin.getId());
        if (holder != null && (!onlyActivated || holder.isActivated())) {
            return holder.getFilter();
        }
        return null;
    }

    public void storeGenericFilters() {
        Set<String> keys = this.mGenericPluginFilterMap.keySet();
        Properties prop = new Properties();
        for (String key : keys) {
            GenericFilterHolder holder = this.mGenericPluginFilterMap.get(key);
            prop.setProperty(key, String.valueOf(holder.isActivated()));
            holder.getFilter().store(GENERIC_PLUGIN_FILTER_DIRECTORY, key);
        }
        try {
            FileOutputStream out = new FileOutputStream(this.mGenericFilterProp);
            prop.store(out, "Generic plugin filters");
            out.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PluginProxy[] getActivatedGenericPluginFilterProxies() {
        ArrayList<PluginProxy> proxyList = new ArrayList<PluginProxy>();
        Set<String> keys = this.mGenericPluginFilterMap.keySet();
        for (String key : keys) {
            PluginProxy proxy;
            GenericFilterHolder holder = this.mGenericPluginFilterMap.get(key);
            if (!holder.isActivated() || (proxy = PluginProxyManager.getInstance().getActivatedPluginForId(key)) == null) continue;
            proxyList.add(proxy);
        }
        return proxyList.toArray(new PluginProxy[proxyList.size()]);
    }

    public void initializeFilters() {
        for (String key : this.mGenericPluginFilterMap.keySet()) {
            GenericFilterHolder holder = this.mGenericPluginFilterMap.get(key);
            if (holder == null) continue;
            try {
                holder.initialize();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        try {
            this.mGenericPictureFilterHolder.initialize();
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }

    public boolean containsKey(String key) {
        return this.mGenericPluginFilterMap.containsKey(key);
    }

    public UserFilter getGenericPictureFilter() {
        return this.mGenericPictureFilterHolder.getFilter();
    }

    public void updateGenericPictureFilter(UserFilter filter) {
        this.mGenericPictureFilterHolder.setFilter(filter);
        this.mGenericPictureFilterHolder.getFilter().store(GENERIC_PLUGIN_FILTER_DIRECTORY, GENERIC_PICTURE_FILTER_NAME);
        MainFrame.getInstance().getProgramTableScrollPane().forceRepaintAll();
    }

    static {
        GENERIC_PLUGIN_FILTER_DIRECTORY = Settings.getUserSettingsDirName() + "/genericfilters";
    }

    private static final class GenericFilterHolder {
        private UserFilter mGenericFilter;
        private boolean mIsActivated;
        private File mFilterFile;

        public GenericFilterHolder() {
            this.mGenericFilter = null;
            this.mFilterFile = null;
            this.mIsActivated = false;
        }

        public GenericFilterHolder(boolean activated, File filterFile) {
            this.mIsActivated = activated;
            this.mFilterFile = filterFile;
            this.mGenericFilter = null;
        }

        public boolean isActivated() {
            return this.mIsActivated;
        }

        public void setActivated(boolean activated) {
            this.mIsActivated = activated;
        }

        public UserFilter getFilter() {
            return this.mGenericFilter;
        }

        public void setFilter(UserFilter filter) {
            this.mGenericFilter = filter;
        }

        public void initialize() throws ParserException {
            if (this.mFilterFile != null && this.mFilterFile.isFile()) {
                this.mGenericFilter = new UserFilter(this.mFilterFile);
            }
        }
    }
}

