/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;
import util.ui.customizableitems.SelectableItemList;

public class DayFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DayFilterComponent.class);
    private final String[] allDays = new String[]{mLocalizer.msg("monday", "Monday"), mLocalizer.msg("tuesday", "Tuesday"), mLocalizer.msg("wednesday", "Wednesday"), mLocalizer.msg("thursday", "Thursday"), mLocalizer.msg("friday", "Friday"), mLocalizer.msg("saturday", "Saturday"), mLocalizer.msg("sunday", "Sunday")};
    private int mSelectedDays = 0;
    private SelectableItemList mList;

    public DayFilterComponent(String name, String description) {
        super(name, description);
    }

    public DayFilterComponent() {
        this("", "");
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mSelectedDays = in.readInt();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mSelectedDays);
    }

    public String toString() {
        return mLocalizer.msg("day", "Day");
    }

    @Override
    public void saveSettings() {
        this.mSelectedDays = 0;
        Object[] selection = this.mList.getSelection();
        ArrayList<String> listSelection = new ArrayList<String>(selection.length);
        for (Object object : selection) {
            listSelection.add((String)object);
        }
        int bit = 1;
        for (int day = 0; day < 7; ++day) {
            if (listSelection.contains(this.allDays[day])) {
                this.mSelectedDays |= bit;
            }
            bit <<= 1;
        }
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("description", "This filter accepts programs belonging to the following channels:");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new BorderLayout());
        ArrayList<String> selectedDays = new ArrayList<String>();
        int bit = 1;
        for (int day = 0; day < 7; ++day) {
            if ((this.mSelectedDays & bit) > 0) {
                selectedDays.add(this.allDays[day]);
            }
            bit <<= 1;
        }
        this.mList = new SelectableItemList(selectedDays.toArray(), this.allDays);
        content.add((Component)this.mList, "Center");
        return content;
    }

    @Override
    public boolean accept(Program program) {
        int day = program.getDate().getCalendar().get(7);
        if (day == 2 && (this.mSelectedDays & 1) > 0) {
            return true;
        }
        if (day == 3 && (this.mSelectedDays & 2) > 0) {
            return true;
        }
        if (day == 4 && (this.mSelectedDays & 4) > 0) {
            return true;
        }
        if (day == 5 && (this.mSelectedDays & 8) > 0) {
            return true;
        }
        if (day == 6 && (this.mSelectedDays & 0x10) > 0) {
            return true;
        }
        if (day == 7 && (this.mSelectedDays & 0x20) > 0) {
            return true;
        }
        return day == 1 && (this.mSelectedDays & 0x40) > 0;
    }

    @Override
    public int getVersion() {
        return 1;
    }
}

