/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import util.ui.Localizer;

public class PluginIconFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(PluginIconFilterComponent.class);
    private JComboBox mBox;
    private PluginProxy mPlugin;

    public PluginIconFilterComponent(String name, String desc) {
        super(name, desc);
    }

    public PluginIconFilterComponent() {
        this("", "");
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        String pluginId = (String)in.readObject();
        this.mPlugin = PluginProxyManager.getInstance().getPluginForId(pluginId);
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        if (this.mPlugin == null) {
            out.writeObject("[invalid]");
        } else {
            out.writeObject(this.mPlugin.getId());
        }
    }

    @Override
    public boolean accept(Program program) {
        Icon[] icons;
        return this.mPlugin != null && this.mPlugin.isActivated() && (icons = this.mPlugin.getProgramTableIcons(program)) != null && icons.length > 0;
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "Accept all programs marked by plugin:");
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel content = new JPanel(new BorderLayout(0, 7));
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        this.mBox = new JComboBox<PluginProxy>(plugins);
        if (this.mPlugin != null) {
            this.mBox.setSelectedItem(this.mPlugin);
        }
        content.add((Component)this.mBox, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)content, "North");
        return centerPanel;
    }

    public String toString() {
        return mLocalizer.msg("PluginIcon", "PluginIcon");
    }

    @Override
    public void saveSettings() {
        this.mPlugin = (PluginProxy)this.mBox.getSelectedItem();
    }

    @Override
    public int getVersion() {
        return 1;
    }

    public boolean isBrokenCompletely() {
        return this.mPlugin == null || PluginProxyManager.getInstance().getActivatedPluginForId(this.mPlugin.getId()) == null;
    }
}

