/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tvbrowser.TVBrowser;
import util.io.stream.InputStreamProcessor;
import util.io.stream.StreamUtilities;

public class DefaultSettings {
    private static final String FILENAME = System.getProperty("propertiesfile", "default.properties");
    private Properties mProperties;

    public DefaultSettings(Properties prop) {
        this.mProperties = prop;
    }

    public DefaultSettings() {
        this.mProperties = new Properties();
        File settingsFile = new File(FILENAME);
        if (settingsFile.canRead() && !TVBrowser.isTransportable()) {
            StreamUtilities.inputStreamIgnoringExceptions(settingsFile, new InputStreamProcessor(){

                @Override
                public void process(InputStream input) throws IOException {
                    DefaultSettings.this.mProperties.load(input);
                }
            });
        }
    }

    public String getProperty(String key, String defaultString) {
        String value = this.mProperties.getProperty(key, defaultString);
        if (value == null) {
            return null;
        }
        String pre = "\\$\\{";
        String post = "\\}";
        String regex = pre + "(.*?)" + post;
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(value);
        while (matcher.find()) {
            String sysKey = matcher.group(1);
            String p = pre + sysKey + post;
            String v = sysKey.equalsIgnoreCase("user.appdata") ? System.getenv("appdata") : System.getProperty(sysKey, "UNKNOWN");
            v = v.replaceAll("\\\\", "/");
            v = v.replaceAll("\\$", "**");
            value = value.replaceAll(p, v);
        }
        return value;
    }
}

