/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.tvdataservice;

import devplugin.Channel;
import devplugin.ChannelGroup;
import devplugin.Date;
import devplugin.ProgressMonitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import tvbrowser.core.Settings;
import tvbrowser.core.tvdataservice.AbstractTvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import util.exc.ErrorHandler;
import util.exc.TvBrowserException;
import util.ui.Localizer;
import util.ui.progress.ProgressMonitorGroup;

public class ChannelGroupManager {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ChannelGroupManager.class);
    private static ChannelGroupManager mInstance;
    private HashMap<TvDataServiceProxy, ArrayList<ChannelGroup>> mServiceToGroupsMap;
    private HashMap<String, ChannelGroup> mGroups = new HashMap();
    private HashMap<ChannelGroup, TvDataServiceProxy> mGroupToService;

    private ChannelGroupManager() {
        TvDataServiceProxy[] proxies;
        this.mServiceToGroupsMap = new HashMap();
        this.mGroupToService = new HashMap();
        for (TvDataServiceProxy proxy : proxies = TvDataServiceProxyManager.getInstance().getDataServices()) {
            ChannelGroup[] groups;
            for (ChannelGroup group : groups = proxy.getAvailableGroups()) {
                this.addGroup(proxy, group);
            }
        }
    }

    private void removeAllGroups() {
        this.mGroups.clear();
        this.mGroupToService.clear();
        this.mServiceToGroupsMap.clear();
    }

    private void addGroup(TvDataServiceProxy service, ChannelGroup group) {
        this.mGroups.put(this.createId(service, group), group);
        this.mGroupToService.put(group, service);
        ArrayList<ChannelGroup> groups = this.mServiceToGroupsMap.get(service);
        if (groups == null) {
            groups = new ArrayList();
            this.mServiceToGroupsMap.put(service, groups);
        }
        groups.add(group);
    }

    public static ChannelGroupManager getInstance() {
        if (mInstance == null) {
            mInstance = new ChannelGroupManager();
        }
        return mInstance;
    }

    public TvDataServiceProxy getTvDataService(ChannelGroup group) {
        return this.mGroupToService.get(group);
    }

    public void checkForAvailableGroupsAndChannels(ProgressMonitor monitor) {
        this.removeAllGroups();
        TvDataServiceProxy[] services = TvDataServiceProxyManager.getInstance().getDataServices();
        ProgressMonitorGroup progressGroup = new ProgressMonitorGroup(monitor, 30);
        ProgressMonitor curMon = progressGroup.getNextProgressMonitor(10);
        curMon.setMaximum(services.length);
        for (int i = 0; i < services.length; ++i) {
            ChannelGroup[] groupArr = null;
            if (services[i].supportsDynamicChannelGroups()) {
                try {
                    groupArr = services[i].checkForAvailableGroups(null);
                }
                catch (TvBrowserException e) {
                    ErrorHandler.handle(e);
                }
            } else {
                groupArr = services[i].getAvailableGroups();
            }
            if (groupArr != null) {
                for (ChannelGroup aGroupArr : groupArr) {
                    this.addGroup(services[i], aGroupArr);
                }
            }
            curMon.setValue(i + 1);
        }
        curMon = progressGroup.getNextProgressMonitor(20);
        curMon.setMaximum(services.length);
        int channelCount = 0;
        TvDataServiceProxy[] proxies = TvDataServiceProxyManager.getInstance().getDataServices();
        for (TvDataServiceProxy proxy : proxies) {
            if (!proxy.supportsDynamicChannelList()) continue;
            ChannelGroup[] groups = proxy.getAvailableGroups();
            int max = groups.length;
            curMon.setMaximum(max);
            for (int j = 0; j < max; ++j) {
                try {
                    final String channelCountString = Integer.toString(channelCount);
                    final ProgressMonitor finalMonitor = curMon;
                    Channel[] channels = proxy.checkForAvailableChannels(groups[j], new ProgressMonitor(){

                        @Override
                        public void setValue(int value) {
                            finalMonitor.setValue(value);
                        }

                        @Override
                        public void setMessage(String msg) {
                            finalMonitor.setMessage(msg + " " + mLocalizer.msg("channelCount", "(Found {0} channels)", channelCountString));
                        }

                        @Override
                        public void setMaximum(int maximum) {
                            finalMonitor.setMaximum(maximum);
                        }
                    });
                    if (channels != null) {
                        channelCount += channels.length;
                    }
                    curMon.setValue(j);
                    continue;
                }
                catch (TvBrowserException e) {
                    ErrorHandler.handle(e);
                }
            }
        }
        Settings.propLastChannelUpdate.setDate(new Date());
    }

    private String createId(TvDataServiceProxy service, ChannelGroup group) {
        return service.getId() + '.' + group.getId();
    }

    public ChannelGroup[] getAvailableGroups() {
        Collection<ChannelGroup> col = this.mGroups.values();
        return col.toArray(new ChannelGroup[col.size()]);
    }

    public ChannelGroup[] getAvailableGroups(AbstractTvDataServiceProxy proxy) {
        Collection groups = this.mServiceToGroupsMap.get(proxy);
        if (groups == null) {
            return new ChannelGroup[0];
        }
        return groups.toArray(new ChannelGroup[groups.size()]);
    }

    public ChannelGroup[] getUsedGroups(AbstractTvDataServiceProxy proxy) {
        String[] subscribedGroupIds = this.getUsedGroupIds();
        ArrayList<ChannelGroup> groups = this.mServiceToGroupsMap.get(proxy);
        if (groups == null) {
            return new ChannelGroup[0];
        }
        if (subscribedGroupIds == null) {
            return groups.toArray(new ChannelGroup[groups.size()]);
        }
        ArrayList<ChannelGroup> result = new ArrayList<ChannelGroup>();
        block0: for (ChannelGroup group : groups) {
            String id = this.createId(proxy, group);
            for (String subscribedGroupId : subscribedGroupIds) {
                if (!id.equals(subscribedGroupId)) continue;
                result.add(group);
                continue block0;
            }
        }
        return result.toArray(new ChannelGroup[result.size()]);
    }

    private String[] getUsedGroupIds() {
        return Settings.propUsedChannelGroups.getStringArray();
    }
}

