/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.search.regexsearch.RegexSearcher;
import util.exc.TvBrowserException;

public class ActorSearcher
extends RegexSearcher {
    private String mLastName;

    public ActorSearcher(String actor) throws TvBrowserException {
        super(ActorSearcher.getSearchTerm(actor), false);
        String[] actorStr = actor.trim().split("\\s");
        this.mLastName = actorStr[actorStr.length - 1].toLowerCase();
    }

    @Override
    protected boolean matches(String value) {
        if (value.toLowerCase().indexOf(this.mLastName) < 0) {
            return false;
        }
        return super.matches(value);
    }

    private static String getSearchTerm(String actor) {
        if (actor == null) {
            return null;
        }
        if (StringUtils.isEmpty(actor = actor.trim())) {
            return null;
        }
        String[] actorStr = actor.split("\\s");
        String regEx = ".*\\b((" + actor + ")";
        int actorMax = actorStr.length - 1;
        if (actorStr.length > 1) {
            regEx = regEx + "|(" + actorStr[actorMax] + "\\s*,\\s*" + actorStr[0] + ")" + "|(" + actorStr[0].substring(0, 1) + "(\\.|" + actorStr[0].substring(1) + ")\\s*\\w*.?\\s*" + actorStr[actorMax] + ")";
        }
        regEx = regEx + ")\\b.*";
        return regEx;
    }
}

