/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.core;

import java.awt.GridLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.extras.favoritesplugin.FavoriteConfigurator;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import util.ui.Localizer;
import util.ui.SearchFormSettings;

public class TitleFavorite
extends Favorite {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(TitleFavorite.class);
    public static final String TYPE_ID = "title";
    private String mProgramTitle;

    public TitleFavorite(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super(in);
        in.readInt();
        this.mProgramTitle = (String)in.readObject();
        this.mSearchFormSettings = new SearchFormSettings(this.mProgramTitle);
    }

    public TitleFavorite(String programTitle) {
        programTitle = programTitle.trim();
        this.setName(programTitle);
        this.mProgramTitle = programTitle;
        this.mSearchFormSettings = new SearchFormSettings(this.mProgramTitle);
    }

    @Override
    public String getTypeID() {
        return TYPE_ID;
    }

    public String getProgramTitle() {
        return this.mProgramTitle;
    }

    @Override
    public FavoriteConfigurator createConfigurator() {
        return new Configurator();
    }

    @Override
    protected void internalWriteData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeObject(this.mProgramTitle);
    }

    @Override
    public boolean isValidSearch() {
        return true;
    }

    class Configurator
    implements FavoriteConfigurator {
        private JTextField mSearchTextTf;

        public Configurator() {
            this.mSearchTextTf = new JTextField(TitleFavorite.this.mSearchFormSettings.getSearchText());
        }

        @Override
        public JPanel createConfigurationPanel() {
            JPanel panel = new JPanel(new GridLayout(-1, 1));
            panel.add(new JLabel(mLocalizer.msg("title-favorite.term", "Any program whose title contains this term will be marked as a favorite:")));
            panel.add(this.mSearchTextTf);
            return panel;
        }

        @Override
        public void save() {
            String searchText = this.mSearchTextTf.getText();
            TitleFavorite.this.mProgramTitle = searchText;
            TitleFavorite.this.mSearchFormSettings.setSearchText(searchText);
        }

        @Override
        public boolean check() {
            if (this.mSearchTextTf.getText().trim().equals("")) {
                JOptionPane.showMessageDialog(this.mSearchTextTf, mLocalizer.msg("missingTitle.message", "Please specify a title for the favorite!"), mLocalizer.msg("missingTitle.title", "Invalid options"), 2);
                return false;
            }
            return true;
        }
    }
}

