/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.dlgs;

import devplugin.Channel;
import devplugin.Date;
import devplugin.NodeFormatter;
import devplugin.PluginTreeNode;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramItem;
import devplugin.ProgramReceiveTarget;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.FavoritesPluginProxy;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteNode;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTree;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class FavoriteTreeModel
extends DefaultTreeModel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FavoriteTreeModel.class);
    private static FavoriteTreeModel mInstance;
    private ArrayList<Program> mMultiples = null;

    private FavoriteTreeModel(TreeNode root) {
        super(root, true);
    }

    public static FavoriteTreeModel initInstance(Favorite[] favoriteArr) {
        FavoriteNode rootNode = new FavoriteNode("");
        FavoriteTreeModel.fixRootNode(rootNode);
        for (Favorite fav : favoriteArr) {
            rootNode.add(fav);
        }
        mInstance = new FavoriteTreeModel(rootNode);
        return mInstance;
    }

    public static FavoriteTreeModel initInstance(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        FavoriteNode rootNode = new FavoriteNode(in, version);
        FavoriteTreeModel.fixRootNode(rootNode);
        mInstance = new FavoriteTreeModel(rootNode);
        return mInstance;
    }

    private static void fixRootNode(FavoriteNode rootNode) {
        String rootLabel = mLocalizer.msg("rootLabel", "All favorites");
        if (StringUtils.isEmpty(rootLabel)) {
            rootLabel = "FAVORITES_ROOT";
        }
        rootNode.setUserObject(rootLabel);
    }

    public static FavoriteTreeModel getInstance() {
        if (mInstance == null) {
            mInstance = FavoriteTreeModel.initInstance(new Favorite[0]);
        }
        return mInstance;
    }

    @Override
    public void reload(TreeNode node) {
        super.reload(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            FavoriteNode child = (FavoriteNode)e.nextElement();
            if (!child.isDirectoryNode()) continue;
            this.reload(child);
        }
    }

    public void reload(FavoriteTree tree, TreeNode node) {
        super.reload(node);
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            FavoriteNode child = (FavoriteNode)e.nextElement();
            if (!child.isDirectoryNode()) continue;
            this.reload(tree, child);
        }
        FavoriteNode parent = (FavoriteNode)node;
        if (parent.wasExpanded()) {
            tree.expandPath(new TreePath(tree.getModel().getPathToRoot(node)));
        } else {
            tree.collapsePath(new TreePath(tree.getModel().getPathToRoot(node)));
        }
    }

    @Override
    public void reload() {
        this.reload(this.root);
    }

    @Override
    public boolean isLeaf(Object nodeObject) {
        if (nodeObject instanceof FavoriteNode) {
            FavoriteNode node = (FavoriteNode)nodeObject;
            return node.getChildCount() == 0;
        }
        return super.isLeaf(nodeObject);
    }

    public Favorite[] getFavoriteArr() {
        return this.getFavoriteArr((FavoriteNode)this.getRoot(), true);
    }

    public Favorite[] getFavoriteArr(FavoriteNode node, boolean withChilds) {
        ArrayList<Favorite> favoriteList = new ArrayList<Favorite>();
        this.fillFavoriteList(node, favoriteList, withChilds);
        return favoriteList.toArray(new Favorite[favoriteList.size()]);
    }

    private void fillFavoriteList(FavoriteNode node, ArrayList<Favorite> favoriteList, boolean withChilds) {
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FavoriteNode child = (FavoriteNode)e.nextElement();
                if (withChilds && child.isDirectoryNode()) {
                    this.fillFavoriteList(child, favoriteList, withChilds);
                    continue;
                }
                if (!child.containsFavorite()) continue;
                favoriteList.add(child.getFavorite());
            }
        }
    }

    public void deleteFavorite(Favorite favorite) {
        this.deleteFavorite(favorite, true);
    }

    public void deleteFavorite(Favorite favorite, boolean updateRootNode) {
        String[] reminderServices;
        Program[] delFavPrograms;
        for (Program program : delFavPrograms = favorite.getPrograms()) {
            program.unmark(FavoritesPluginProxy.getInstance());
        }
        this.deleteFavorite((FavoriteNode)this.getRoot(), favorite);
        for (String reminderService : reminderServices = favorite.getReminderConfiguration().getReminderServices()) {
            if (!"window".equals(reminderService)) continue;
            ReminderPlugin.getInstance().removePrograms(favorite.getPrograms());
        }
        if (updateRootNode) {
            FavoritesPlugin.getInstance().updateRootNode(true);
        }
    }

    public boolean isContainedByOtherFavorites(Favorite favorite, Program p) {
        return this.isContainedByOtherFavorites((FavoriteNode)this.getRoot(), favorite, p);
    }

    private boolean isContainedByOtherFavorites(FavoriteNode node, Favorite favorite, Program p) {
        boolean value = false;
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FavoriteNode child = (FavoriteNode)e.nextElement();
                if (child.isDirectoryNode()) {
                    value = value || this.isContainedByOtherFavorites(child, favorite, p);
                    continue;
                }
                if (!child.containsFavorite() || child.equals(favorite)) continue;
                value = value || child.getFavorite().contains(p);
            }
        }
        return value;
    }

    private void deleteFavorite(FavoriteNode node, Favorite fav) {
        if (node.isDirectoryNode()) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                FavoriteNode child = (FavoriteNode)e.nextElement();
                if (child.isDirectoryNode()) {
                    this.deleteFavorite(child, fav);
                    continue;
                }
                if (!child.containsFavorite()) continue;
                if (child.equals(fav)) {
                    Program[] progs;
                    node.remove(child);
                    for (Program prog : progs = fav.getPrograms()) {
                        prog.validateMarking();
                    }
                    continue;
                }
                child.getFavorite().handleContainingPrograms(fav.getPrograms());
            }
        }
    }

    public void addFavorite(Favorite fav) {
        this.addFavorite(fav, (FavoriteNode)this.getRoot());
    }

    public FavoriteNode addFavorite(Favorite fav, FavoriteNode parent) {
        Program[] progs;
        if (parent == null) {
            parent = (FavoriteNode)this.getRoot();
        }
        FavoriteNode newNode = parent.add(fav);
        this.reload(parent);
        FavoritesPlugin.getInstance().updateRootNode(true);
        for (Program prog : progs = newNode.getAllPrograms(false)) {
            prog.validateMarking();
        }
        return newNode;
    }

    public static String getFavoriteLabel(Favorite favorite, Program program) {
        return FavoriteTreeModel.getFavoriteLabel(favorite, program, null);
    }

    public static String getFavoriteLabel(Favorite favorite, Program p, Channel currentChannel) {
        String episode;
        Date currentDate;
        Date d = p.getDate();
        String progdate = d.equals((currentDate = Date.getCurrentDate()).addDays(-1)) ? Localizer.getLocalization("i18n_yesterday") : (d.equals(currentDate) ? Localizer.getLocalization("i18n_today") : (d.equals(currentDate.addDays(1)) ? Localizer.getLocalization("i18n_tomorrow") : p.getDateString()));
        String description = progdate + "  " + p.getTimeString();
        if (favorite.getName().compareTo(p.getTitle()) != 0) {
            description = description + "  " + p.getTitle();
        }
        if (StringUtils.isNotBlank(episode = p.getTextField(ProgramFieldType.EPISODE_TYPE))) {
            if (episode.length() <= 3) {
                episode = ProgramFieldType.EPISODE_TYPE.getLocalizedName() + " " + episode;
            }
            description = description + ": " + episode;
        }
        if (null == currentChannel || currentChannel != p.getChannel()) {
            description = description + "  (" + p.getChannel() + ")";
        }
        return description;
    }

    public void storeData(ObjectOutputStream out) throws IOException {
        ((FavoriteNode)this.getRoot()).store(out);
    }

    public void updatePluginTree(PluginTreeNode node, ArrayList<Program> allPrograms, FavoriteNode parentFavorite) {
        if (parentFavorite == null) {
            parentFavorite = (FavoriteNode)this.getRoot();
        }
        if (parentFavorite.isDirectoryNode()) {
            Enumeration<TreeNode> e = parentFavorite.children();
            while (e.hasMoreElements()) {
                final FavoriteNode child = (FavoriteNode)e.nextElement();
                if (child.isDirectoryNode()) {
                    PluginTreeNode newNode = new PluginTreeNode(child.toString());
                    newNode.setGroupingByWeekEnabled(true);
                    this.updatePluginTree(newNode, allPrograms, child);
                    if (newNode.isEmpty()) continue;
                    node.add(newNode);
                    continue;
                }
                Program[] progArr = child.getFavorite().getWhiteListPrograms();
                if (progArr.length <= 0) continue;
                PluginTreeNode newNode = new PluginTreeNode(child.toString());
                newNode.setGroupingByWeekEnabled(true);
                newNode.getMutableTreeNode().setIcon(FavoritesPlugin.getFavoritesIcon(16));
                node.add(newNode);
                AbstractAction editFavorite = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoritesPlugin.getInstance().editFavorite(child.getFavorite());
                    }
                };
                editFavorite.putValue("Name", mLocalizer.ellipsisMsg("editTree", "Edit"));
                editFavorite.putValue("SmallIcon", TVBrowserIcons.edit(16));
                AbstractAction deleteFavorite = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FavoritesPlugin.getInstance().askAndDeleteFavorite(child.getFavorite());
                    }
                };
                deleteFavorite.putValue("Name", mLocalizer.ellipsisMsg("deleteTree", "Delete"));
                deleteFavorite.putValue("SmallIcon", TVBrowserIcons.delete(16));
                deleteFavorite.putValue("ACTIONKEY_KEY_EVENT", 127);
                newNode.addAction(editFavorite);
                newNode.addAction(deleteFavorite);
                if (progArr.length <= 10) {
                    newNode.setGroupingByDateEnabled(false);
                }
                boolean episodeOnly = progArr.length > 1;
                for (Program program : progArr) {
                    String episode = program.getTextField(ProgramFieldType.EPISODE_TYPE);
                    if (!StringUtils.isBlank(episode)) continue;
                    episodeOnly = false;
                    break;
                }
                for (Program program : progArr) {
                    PluginTreeNode pNode = newNode.addProgramWithoutCheck(program);
                    allPrograms.add(program);
                    if (!episodeOnly && progArr.length > 10) continue;
                    pNode.setNodeFormatter(new NodeFormatter(){

                        @Override
                        public String format(ProgramItem pitem) {
                            Program p = pitem.getProgram();
                            return FavoriteTreeModel.getFavoriteLabel(child.getFavorite(), p);
                        }
                    });
                }
            }
        }
    }

    public static int[] getProgramsCount(FavoriteNode node) {
        int[] count = new int[2];
        Date currentDate = Date.getCurrentDate();
        if (node.containsFavorite()) {
            Program[] whiteListPrograms = node.getFavorite().getWhiteListPrograms();
            count[0] = whiteListPrograms.length;
            for (Program p : whiteListPrograms) {
                if (!p.getDate().equals(currentDate) || p.isExpired()) continue;
                count[1] = count[1] + 1;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            FavoriteNode child = (FavoriteNode)node.getChildAt(i);
            if (child.containsFavorite()) {
                Program[] whiteListPrograms = child.getFavorite().getWhiteListPrograms();
                count[0] = count[0] + whiteListPrograms.length;
                for (Program p : whiteListPrograms) {
                    if (!p.getDate().equals(currentDate) || p.isExpired()) continue;
                    count[1] = count[1] + 1;
                }
                continue;
            }
            int[] countReturned = FavoriteTreeModel.getProgramsCount(child);
            count[0] = count[0] + countReturned[0];
            count[1] = count[1] + countReturned[1];
        }
        return count;
    }

    public void sort(FavoriteNode node, Comparator<FavoriteNode> comp, String title) {
        String msg = mLocalizer.msg("reallySort", "Do you really want to sort '{0}'?\n\nThe current order will get lost.", node.toString());
        int result = JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), msg, title, 0);
        if (result == 0) {
            this.sortNodeInternal(node, comp);
        }
        FavoritesPlugin.getInstance().favoriteSelectionChanged();
    }

    private void sortNodeInternal(FavoriteNode node, Comparator<FavoriteNode> comp) {
        ArrayList<TreeNode> childNodes = Collections.list(node.children());
        Collections.sort(childNodes, comp);
        node.removeAllChildren();
        for (FavoriteNode favoriteNode : childNodes) {
            node.add(favoriteNode);
            if (!favoriteNode.isDirectoryNode()) continue;
            this.sortNodeInternal(favoriteNode, comp);
        }
    }

    public Favorite[] getFavoritesContainingReceiveTarget(ProgramReceiveTarget target) {
        ProgramReceiveTarget[] defaultTargets;
        Favorite[] favorites = this.getFavoriteArr();
        for (ProgramReceiveTarget defaultTarget : defaultTargets = FavoritesPlugin.getInstance().getDefaultClientPluginsTargets()) {
            if (!defaultTarget.equals(target)) continue;
            return favorites;
        }
        ArrayList<Favorite> receiveFavorites = new ArrayList<Favorite>();
        for (Favorite fav : favorites) {
            if (!fav.containsReceiveTarget(target)) continue;
            receiveFavorites.add(fav);
        }
        return receiveFavorites.toArray(new Favorite[receiveFavorites.size()]);
    }

    public void updatePluginTree(PluginTreeNode topicNode, ArrayList<Program> allPrograms) {
        this.updatePluginTree(topicNode, allPrograms, null);
    }

    public Favorite[] getFavoritesContainingProgram(Program program) {
        ArrayList<Favorite> containing = new ArrayList<Favorite>();
        block0: for (Favorite favorite : this.getFavoriteArr()) {
            for (Program favProgram : favorite.getWhiteListPrograms()) {
                if (!favProgram.equals(program)) continue;
                containing.add(favorite);
                continue block0;
            }
        }
        return containing.toArray(new Favorite[containing.size()]);
    }

    public boolean isInMultipleFavorites(Program program) {
        if (this.mMultiples == null) {
            HashMap<Program, Integer> map = new HashMap<Program, Integer>(2000);
            for (Favorite favorite : this.getFavoriteArr()) {
                for (Program favProgram : favorite.getPrograms()) {
                    Integer count = (Integer)map.get(favProgram);
                    if (count == null) {
                        count = 0;
                    }
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    map.put(favProgram, count);
                }
            }
            this.mMultiples = new ArrayList();
            for (Map.Entry entry : map.entrySet()) {
                if ((Integer)entry.getValue() <= 1) continue;
                this.mMultiples.add((Program)entry.getKey());
            }
        }
        for (Program dupProgram : this.mMultiples) {
            if (!dupProgram.equals(program)) continue;
            return true;
        }
        return false;
    }

    public void resetMultiplesCounter() {
        this.mMultiples = null;
    }

    public void reValidateChannelLimitations() {
    }
}

