/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Date;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.exc.ErrorHandler;
import util.io.ExecutionHandler;
import util.io.IOUtilities;
import util.paramhandler.ParamParser;
import util.ui.Localizer;

public class ReminderTimerListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderTimerListener.class);
    private static final Logger mLog = Logger.getLogger(ReminderTimerListener.class.getName());
    private Properties mSettings;
    private ReminderList mReminderList;

    public ReminderTimerListener(Properties settings, ReminderList reminderList) {
        this.mSettings = settings;
        this.mReminderList = reminderList;
    }

    public void timeEvent(ArrayList<ReminderListItem> reminders) {
        ArrayList<ReminderListItem> notExpired = new ArrayList<ReminderListItem>(reminders.size());
        for (ReminderListItem item : reminders) {
            if (item.getProgramItem().getProgram().isExpired()) continue;
            notExpired.add(item);
        }
        reminders = notExpired;
        if (reminders.isEmpty()) {
            return;
        }
        if ("true".equals(this.mSettings.getProperty("usesound"))) {
            ReminderPlugin.playSound(this.mSettings.getProperty("soundfile"));
        }
        if ("true".equals(this.mSettings.getProperty("usebeep"))) {
            Toolkit.getDefaultToolkit().beep();
        }
        if ("true".equals(this.mSettings.getProperty("usemsgbox"))) {
            HashMap<Integer, ArrayList<ReminderListItem>> sortedReminders = new HashMap<Integer, ArrayList<ReminderListItem>>(reminders.size());
            for (ReminderListItem reminder : reminders) {
                ArrayList<ReminderListItem> list;
                int time = reminder.getProgram().getStartTime();
                if (reminder.getProgram().isOnAir() || reminder.getProgram().isExpired()) {
                    time = -1;
                }
                if ((list = (ArrayList<ReminderListItem>)sortedReminders.get(time)) == null) {
                    list = new ArrayList<ReminderListItem>();
                    sortedReminders.put(time, list);
                }
                list.add(reminder);
            }
            for (ArrayList singleTimeReminders : sortedReminders.values()) {
                new ReminderFrame(this.mReminderList, singleTimeReminders, this.getAutoCloseReminderTime(singleTimeReminders));
            }
        } else {
            for (ReminderListItem reminder : reminders) {
                this.mReminderList.removeWithoutChecking(reminder.getProgramItem());
                this.mReminderList.blockProgram(reminder.getProgram());
            }
        }
        if ("true".equals(this.mSettings.getProperty("useexec"))) {
            String fName = this.mSettings.getProperty("execfile", "").trim();
            if (StringUtils.isNotEmpty(fName)) {
                for (ReminderListItem reminder : reminders) {
                    ParamParser parser = new ParamParser();
                    String fParam = parser.analyse(this.mSettings.getProperty("execparam", ""), reminder.getProgram());
                    try {
                        ExecutionHandler executionHandler = new ExecutionHandler(fParam, fName);
                        executionHandler.execute();
                    }
                    catch (Exception exc) {
                        String msg = mLocalizer.msg("error.2", "Error executing reminder program!\n({0})", fName, exc);
                        ErrorHandler.handle(msg, exc);
                    }
                }
            } else {
                mLog.warning("Reminder program name is not defined!");
            }
        }
        ProgramReceiveTarget[] targets = ReminderPlugin.getInstance().getClientPluginsTargets();
        ArrayList<Program> programs = new ArrayList<Program>();
        for (ReminderListItem reminder : reminders) {
            programs.add(reminder.getProgram());
        }
        for (ProgramReceiveTarget target : targets) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null || !plugin.canReceiveProgramsWithTarget()) continue;
            plugin.receivePrograms(programs.toArray(new Program[programs.size()]), target);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new Thread("Update reminder tree"){

                    @Override
                    public void run() {
                        this.setPriority(1);
                        ReminderPlugin.getInstance().updateRootNode(true);
                    }
                }.start();
            }
        });
    }

    private int getAutoCloseReminderTime(ArrayList<ReminderListItem> reminders) {
        int result = 0;
        for (ReminderListItem reminder : reminders) {
            result = Math.max(result, this.getAutoCloseReminderTime(reminder.getProgram()));
        }
        return result;
    }

    private int getAutoCloseReminderTime(Program p) {
        int autoCloseReminderTime = 0;
        try {
            if (this.mSettings.getProperty("autoCloseBehaviour", "onEnd").equals("onEnd")) {
                int endTime = p.getStartTime() + p.getLength();
                int currentTime = IOUtilities.getMinutesAfterMidnight();
                int dateDiff = p.getDate().compareTo(Date.getCurrentDate());
                if (dateDiff == -1) {
                    currentTime += 1440;
                } else if (dateDiff == 1) {
                    endTime += 1440;
                }
                autoCloseReminderTime = (endTime - currentTime) * 60;
            } else if (this.mSettings.getProperty("autoCloseBehaviour", "onTime").equals("onTime")) {
                String asString = this.mSettings.getProperty("autoCloseReminderTime", "10");
                autoCloseReminderTime = Integer.parseInt(asString);
            } else {
                autoCloseReminderTime = 0;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return autoCloseReminderTime;
    }
}

