/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tvbrowser.core.ChannelList;
import tvbrowser.core.Settings;
import tvbrowser.extras.searchplugin.SearchPlugin;
import tvbrowser.ui.mainframe.MainFrame;
import util.settings.PluginPictureSettings;
import util.ui.ChannelListCellRenderer;
import util.ui.Localizer;
import util.ui.SearchFormSettings;
import util.ui.SearchHelper;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

class RepetitionDialog
extends JDialog
implements WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(RepetitionDialog.class);
    private JTextField mText;
    private JComboBox mChannelChooser;
    private JComboBox mTimeChooser;

    RepetitionDialog(Window parent) {
        this(parent, (Channel)null);
    }

    RepetitionDialog(Window parent, Channel channel) {
        super(parent);
        this.setModal(true);
        this.createGui(channel);
    }

    private void createGui(Channel channel) {
        this.setTitle(mLocalizer.msg("title", "Search repetition"));
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new FormLayout("pref, 3dlu, 0dlu:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref, fill:5dlu:grow, pref"));
        panel.setBorder(Borders.DLU7);
        CellConstraints cc = new CellConstraints();
        panel.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("searchForRepetition", "Search for repetitions")), cc.xyw(1, 1, 3));
        panel.add((Component)new JLabel(mLocalizer.msg("forProgram", "of:")), cc.xy(1, 3));
        this.mText = new JTextField();
        panel.add((Component)this.mText, cc.xy(3, 3));
        panel.add((Component)new JLabel(mLocalizer.msg("on", "on:")), cc.xy(1, 5));
        Vector<Object> list = new Vector<Object>();
        list.add(mLocalizer.msg("allChannels", "All channels"));
        ArrayList<Channel> channelList = new ArrayList<Channel>(Arrays.asList(ChannelList.getSubscribedChannels()));
        if (channel != null) {
            list.add(channel);
            channelList.remove(channel);
        }
        list.addAll(channelList);
        this.mChannelChooser = new JComboBox(list);
        this.mChannelChooser.setRenderer(new ChannelListCellRenderer(true, true));
        panel.add((Component)this.mChannelChooser, cc.xy(3, 5));
        panel.add((Component)new JLabel(mLocalizer.msg("when", "when:")), cc.xy(1, 7));
        String[] dates = new String[]{Localizer.getLocalization("i18n_today"), Localizer.getLocalization("i18n_tomorrow"), mLocalizer.msg("oneWeek", "one week"), mLocalizer.msg("twoWeeks", "two weeks"), mLocalizer.msg("threeWeeks", "three weeks"), mLocalizer.msg("allData", "all data")};
        this.mTimeChooser = new JComboBox<String>(dates);
        this.mTimeChooser.setSelectedIndex(SearchPlugin.getInstance().getRepetitionTimeSelection());
        panel.add((Component)this.mTimeChooser, cc.xy(3, 7));
        JButton stdSearch = new JButton(mLocalizer.ellipsisMsg("more", "More"));
        stdSearch.setToolTipText(mLocalizer.msg("standardSearch", "Open standard search"));
        stdSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RepetitionDialog.this.close();
                SearchFormSettings[] history = SearchPlugin.getSearchHistory();
                if (history != null && history.length > 0) {
                    SearchPlugin.getInstance().openSearchDialog(RepetitionDialog.this.mText.getText());
                } else {
                    SearchPlugin.getInstance().openSearchDialog(RepetitionDialog.this.mText.getText(), RepetitionDialog.this.getSearchSettings());
                }
            }
        });
        ButtonBarBuilder builder = new ButtonBarBuilder();
        builder.addButton((JComponent)stdSearch);
        builder.addUnrelatedGap();
        builder.addGlue();
        JButton go = new JButton(mLocalizer.msg("go", "go"));
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepetitionDialog.this.search();
            }
        });
        JButton cancel = new JButton(Localizer.getLocalization("i18n_cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RepetitionDialog.this.close();
            }
        });
        builder.addButton(go, cancel);
        panel.add((Component)builder.getPanel(), cc.xyw(1, 9, 3));
        Settings.layoutWindow("extras.repetitionDialog", this, new Dimension(Sizes.dialogUnitXAsPixel(220, this), Sizes.dialogUnitYAsPixel(125, this)));
        UiUtilities.registerForClosing(this);
        this.getRootPane().setDefaultButton(go);
    }

    private void search() {
        this.setVisible(false);
        SearchPlugin.getInstance().setRepetitionTimeSelection(this.mTimeChooser.getSelectedIndex());
        SearchFormSettings settings = this.getSearchSettings();
        SearchHelper.search((Component)UiUtilities.getLastModalChildOf(MainFrame.getInstance()), new PluginPictureSettings(0), settings, true);
    }

    private SearchFormSettings getSearchSettings() {
        int days = this.getDays();
        SearchFormSettings settings = new SearchFormSettings(this.mText.getText());
        settings.setSearchIn(1);
        settings.setSearcherType(1);
        settings.setCaseSensitive(false);
        settings.setNrDays(days);
        if (this.mChannelChooser.getSelectedIndex() > 0) {
            settings.setChannels(new Channel[]{(Channel)this.mChannelChooser.getSelectedItem()});
        }
        return settings;
    }

    private int getDays() {
        int days = 1;
        switch (this.mTimeChooser.getSelectedIndex()) {
            case 0: {
                days = 0;
                break;
            }
            case 1: {
                days = 1;
                break;
            }
            case 2: {
                days = 7;
                break;
            }
            case 3: {
                days = 14;
                break;
            }
            case 4: {
                days = 21;
                break;
            }
            default: {
                days = -1;
            }
        }
        return days;
    }

    public void setPatternText(String text) {
        this.mText.setText(text);
    }

    @Override
    public void close() {
        this.setVisible(false);
    }
}

