/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tvbrowser.extras.searchplugin.SearchPlugin;
import util.ui.Localizer;
import util.ui.SearchFormSettings;
import util.ui.TVBrowserIcons;

class SearchSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchSettingsTab.class);
    private JCheckBox mAlwaysExpertMode;

    SearchSettingsTab() {
    }

    @Override
    public JPanel createSettingsPanel() {
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default,0dlu:grow", "default,5dlu,default,2dlu,default"));
        pb.border(Borders.DIALOG);
        this.mAlwaysExpertMode = new JCheckBox(mLocalizer.msg("alwaysExpert", "Use expert mode for repetition search also"), SearchPlugin.getAlwaysSearchExpert());
        JButton clearHistory = new JButton(mLocalizer.msg("clearHistory", "Clear Search History"));
        clearHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPlugin.setSearchHistory(new SearchFormSettings[0]);
            }
        });
        pb.addSeparator(mLocalizer.msg("title", "Search"), CC.xyw(1, 1, 3));
        pb.add((Component)this.mAlwaysExpertMode, CC.xyw(2, 3, 2));
        pb.add((Component)clearHistory, CC.xy(2, 5));
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        SearchPlugin.setAlwaysSearchExpert(this.mAlwaysExpertMode.isSelected());
    }

    @Override
    public Icon getIcon() {
        return TVBrowserIcons.search(16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Search");
    }
}

