/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxyManager;
import tvdataservice.PictureSettingsIf;
import tvdataservice.SettingsPanel;
import util.ui.Localizer;
import util.ui.UiUtilities;

public class PictureConfigPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(PictureConfigPanel.class);
    private JRadioButton mDownloadAll;
    private JRadioButton mDownloadNoPictures;
    private JRadioButton mDownloadEvening;
    private JRadioButton mDownloadMorning;
    private SettingsPanel mTvBrowserDataServiceSettingsPanel;

    public PictureConfigPanel(boolean update) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("fill:pref:grow, 10dlu, fill:300dlu:grow, fill:pref:grow", "fill:0dlu:grow, pref, 15dlu, pref, pref, pref, pref, 15dlu, pref, fill:0dlu:grow"), this);
        this.mDownloadAll = new JRadioButton(mLocalizer.msg("allPictures", "Download pictures for all programs"));
        this.mDownloadNoPictures = new JRadioButton(mLocalizer.msg("noPictures", "Don't download pictures"));
        this.mDownloadEvening = new JRadioButton(mLocalizer.msg("eveningPictures", "Download only pictures for the evening programs (4 PM to midnight)"));
        this.mDownloadMorning = new JRadioButton(mLocalizer.msg("morningPictures", "Download only pictures for the day programs (midnight to 4 PM)"));
        pb.add((Component)UiUtilities.createHtmlHelpTextArea((update ? mLocalizer.msg("preambelUpdate", "Preambel") : "") + mLocalizer.msg("preambel", "Preambel")), cc.xyw(2, 2, 2));
        pb.add((Component)this.mDownloadAll, cc.xy(3, 4));
        pb.add((Component)this.mDownloadNoPictures, cc.xy(3, 5));
        pb.add((Component)this.mDownloadEvening, cc.xy(3, 6));
        pb.add((Component)this.mDownloadMorning, cc.xy(3, 7));
        pb.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg(update ? "closingUpdate" : "closing", "Closing")), cc.xyw(2, 9, 2));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mDownloadAll);
        bg.add(this.mDownloadNoPictures);
        bg.add(this.mDownloadEvening);
        bg.add(this.mDownloadMorning);
        TvDataServiceProxy[] services = TvDataServiceProxyManager.getInstance().getTvDataServices(new String[]{"tvbrowserdataservice.TvBrowserDataService"});
        if (services != null && services.length == 1) {
            this.mTvBrowserDataServiceSettingsPanel = services[0].getSettingsPanel();
            if (this.mTvBrowserDataServiceSettingsPanel instanceof PictureSettingsIf) {
                int i = ((PictureSettingsIf)((Object)this.mTvBrowserDataServiceSettingsPanel)).getPictureState();
                this.mDownloadNoPictures.setSelected(i == 0);
                this.mDownloadAll.setSelected(i == 3);
                this.mDownloadMorning.setSelected(i == 1);
                this.mDownloadEvening.setSelected(i == 2);
            }
        }
    }

    public void saveSettings() {
        if (this.mTvBrowserDataServiceSettingsPanel instanceof PictureSettingsIf) {
            PictureSettingsIf pictureIf = (PictureSettingsIf)((Object)this.mTvBrowserDataServiceSettingsPanel);
            if (this.mDownloadNoPictures.isSelected()) {
                pictureIf.setPictureState(0);
            } else if (this.mDownloadMorning.isSelected()) {
                pictureIf.setPictureState(1);
            } else if (this.mDownloadEvening.isSelected()) {
                pictureIf.setPictureState(2);
            } else if (this.mDownloadAll.isSelected()) {
                pictureIf.setPictureState(3);
            }
            this.mTvBrowserDataServiceSettingsPanel.ok();
        }
    }

    public boolean isActivated() {
        return !this.mDownloadNoPictures.isSelected();
    }
}

