/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import tvbrowser.core.ChannelList;
import tvbrowser.ui.configassistant.AbstractCardPanel;
import tvbrowser.ui.configassistant.PrevNextButtons;
import tvbrowser.ui.configassistant.StatusPanel;
import tvbrowser.ui.settings.ChannelsSettingsTab;
import util.ui.Localizer;

class SubscribeChannelCardPanel
extends AbstractCardPanel {
    private ChannelsSettingsTab mChannelsSettingsTab;
    private JPanel mContent = new JPanel(new BorderLayout());
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(SubscribeChannelCardPanel.class);

    public SubscribeChannelCardPanel(PrevNextButtons btns) {
        super(btns);
    }

    @Override
    public JPanel getPanel() {
        return this.mContent;
    }

    @Override
    public boolean onNext() {
        this.mChannelsSettingsTab.saveSettingsWithoutDataUpdate();
        if (ChannelList.getNumberOfSubscribedChannels() == 0) {
            JOptionPane.showMessageDialog(this.mContent, mLocalizer.msg("noChannelsSelected", "There are no channels selected..."), mLocalizer.msg("noChannelsSelected.Title", "no selected channels"), 1);
            return false;
        }
        return true;
    }

    @Override
    public boolean onPrev() {
        this.mChannelsSettingsTab.saveSettings();
        return true;
    }

    @Override
    public void onShow() {
        super.onShow();
        this.mChannelsSettingsTab = new ChannelsSettingsTab(true);
        this.mContent.removeAll();
        this.mContent.add((Component)new StatusPanel(1), "North");
        this.mContent.add((Component)this.mChannelsSettingsTab.createSettingsPanel(), "Center");
    }
}

