/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginAccess;
import devplugin.PluginsFilterComponent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.filtercomponents.AgeLimitFilterComponent;
import tvbrowser.core.filters.filtercomponents.BeanShellFilterComponent;
import tvbrowser.core.filters.filtercomponents.ChannelFilterComponent;
import tvbrowser.core.filters.filtercomponents.DateFilterComponent;
import tvbrowser.core.filters.filtercomponents.DayFilterComponent;
import tvbrowser.core.filters.filtercomponents.FavoritesFilterComponent;
import tvbrowser.core.filters.filtercomponents.KeywordFilterComponent;
import tvbrowser.core.filters.filtercomponents.MassFilterComponent;
import tvbrowser.core.filters.filtercomponents.PluginFilterComponent;
import tvbrowser.core.filters.filtercomponents.PluginIconFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramInfoFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramLengthFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramMarkingPriorityFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramRunningFilterComponent;
import tvbrowser.core.filters.filtercomponents.ProgramTypeFilterComponent;
import tvbrowser.core.filters.filtercomponents.ReminderFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleTitleFilterComponent;
import tvbrowser.core.filters.filtercomponents.TimeFilterComponent;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.ui.filter.dlgs.Utilities;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class EditFilterComponentDlg
extends JDialog
implements ActionListener,
DocumentListener,
WindowClosingIf {
    private static final String REGEX_INVALID_CHARACTERS = "[\\p{Punct}\\s&&[^_]]";
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(EditFilterComponentDlg.class);
    private FilterComponent mSelectedFilterComponent;
    private JComboBox mRuleCb;
    private JPanel mCenterPanel;
    private JPanel mRulePanel = null;
    private JPanel mContentPane;
    private JButton mOkBtn;
    private JButton mCancelBtn;
    private JTextField mDescTF;
    private JTextField mNameTF;
    private JEditorPane mFilterComponentDescription;
    private JPanel mTypeDescriptionPanel;

    public EditFilterComponentDlg(Window parent, FilterComponent comp) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.init(parent, comp, null);
    }

    public EditFilterComponentDlg(JDialog parent) {
        this(parent, null);
    }

    public EditFilterComponentDlg(JDialog parent, FilterComponent comp) {
        this(parent, comp, null);
    }

    public EditFilterComponentDlg(JDialog parent, FilterComponent comp, Class<? extends FilterComponent> filterComponentClass) {
        super((Dialog)parent, true);
        this.init(parent, comp, filterComponentClass);
    }

    public EditFilterComponentDlg(JFrame parent) {
        this(parent, null);
    }

    public EditFilterComponentDlg(JFrame parent, FilterComponent comp) {
        this(parent, comp, null);
    }

    public EditFilterComponentDlg(JFrame parent, FilterComponent comp, Class<? extends FilterComponent> filterComponentClass) {
        super((Frame)parent, true);
        this.init(parent, comp, filterComponentClass);
    }

    private void init(Window parent, FilterComponent comp, Class<? extends FilterComponent> filterComponentClass) {
        UiUtilities.registerForClosing(this);
        this.setTitle(mLocalizer.msg("title", "Edit filter component"));
        this.mContentPane = new JPanel();
        this.mNameTF = new JTextField(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                str = str.replaceAll(EditFilterComponentDlg.REGEX_INVALID_CHARACTERS, "_");
                super.insertString(offset, str, a);
            }
        }, "", 20);
        this.mNameTF.getDocument().addDocumentListener(this);
        this.mDescTF = new JTextField(20);
        this.mRuleCb = new JComboBox();
        this.mRuleCb.addActionListener(this);
        this.mRuleCb.addItem(mLocalizer.msg("hint", "must choose one"));
        this.mFilterComponentDescription = UiUtilities.createHtmlHelpTextArea("");
        this.mTypeDescriptionPanel = new JPanel(new FormLayout("min:grow", "fill:default:grow"));
        this.mTypeDescriptionPanel.add((Component)this.mFilterComponentDescription, CC.xy(1, 1));
        this.mTypeDescriptionPanel.setBackground(Color.red);
        this.mCenterPanel = new JPanel(new BorderLayout());
        JScrollPane scrollPane = new JScrollPane(this.mCenterPanel);
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        scrollPane.getViewport().setBorder(null);
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default,5dlu,default:grow,5dlu,", "default,5dlu,default,2dlu,default,2dlu,default,10dlu,default,5dlu,fill:min:grow,5dlu,default,5dlu,default"), this.mContentPane);
        pb.border(Borders.DIALOG);
        pb.addSeparator(mLocalizer.msg("component", "Component"), CC.xyw(1, 1, 5));
        pb.addLabel(mLocalizer.msg("name", "Name:"), CC.xy(2, 3));
        pb.add((Component)this.mNameTF, CC.xy(4, 3));
        pb.addLabel(mLocalizer.msg("description", "Description:"), CC.xy(2, 5));
        pb.add((Component)this.mDescTF, CC.xy(4, 5));
        pb.addLabel(mLocalizer.msg("type", "Type:"), CC.xy(2, 7));
        pb.add((Component)this.mRuleCb, CC.xy(4, 7));
        pb.addSeparator(mLocalizer.msg("componentSettings", "Component settings:"), CC.xyw(1, 9, 5));
        pb.add((Component)scrollPane, CC.xyw(2, 11, 3));
        pb.add((Component)new JSeparator(0), CC.xyw(1, 13, 5));
        TreeSet<FilterComponent> set = new TreeSet<FilterComponent>(new FilterComponent.TypeComparator());
        if (filterComponentClass == null) {
            PluginAccess[] plugins;
            set.add(new AgeLimitFilterComponent());
            set.add(new BeanShellFilterComponent());
            set.add(new ChannelFilterComponent());
            set.add(new DateFilterComponent());
            set.add(new DayFilterComponent());
            set.add(new FavoritesFilterComponent());
            set.add(new KeywordFilterComponent());
            set.add(new MassFilterComponent());
            set.add(new PluginFilterComponent());
            set.add(new PluginIconFilterComponent());
            set.add(new ProgramInfoFilterComponent());
            set.add(new ProgramLengthFilterComponent());
            set.add(new ProgramMarkingPriorityFilterComponent());
            set.add(new ProgramRunningFilterComponent());
            set.add(new ProgramTypeFilterComponent());
            set.add(new ReminderFilterComponent());
            set.add(new SingleTitleFilterComponent());
            set.add(new TimeFilterComponent());
            for (PluginAccess plugin : plugins = PluginManagerImpl.getInstance().getActivatedPlugins()) {
                Class<? extends PluginsFilterComponent>[] clazzes = plugin.getAvailableFilterComponentClasses();
                if (clazzes == null) continue;
                for (Class<? extends PluginsFilterComponent> clazz : clazzes) {
                    try {
                        set.add(clazz.newInstance());
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            try {
                set.add(filterComponentClass.newInstance());
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        Iterator<FilterComponent> it = set.iterator();
        while (it.hasNext()) {
            this.mRuleCb.addItem(it.next());
        }
        ButtonBarBuilder bottomBar = Utilities.createFilterButtonBar();
        this.mOkBtn = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOkBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOkBtn);
        this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelBtn.addActionListener(this);
        bottomBar.addButton(this.mOkBtn, this.mCancelBtn);
        if (comp != null) {
            this.setFilterComponent(comp);
        } else if (this.mRuleCb.getItemCount() == 2) {
            this.mRuleCb.setSelectedIndex(1);
        }
        pb.add((Component)bottomBar.getPanel(), CC.xyw(1, 15, 5));
        this.updateOkBtn();
        this.setLayout(new BorderLayout());
        this.add((Component)this.mContentPane, "Center");
        this.setMinimumSize(new Dimension(500, 550));
        Settings.layoutWindow("editFilterComponentDlg", this, this.getMinimumSize(), parent);
        this.setVisible(true);
    }

    private void setFilterComponent(FilterComponent comp) {
        for (int i = 1; i < this.mRuleCb.getItemCount(); ++i) {
            FilterComponent c = (FilterComponent)this.mRuleCb.getItemAt(i);
            if (!c.toString().equals(comp.toString())) continue;
            DefaultComboBoxModel model = (DefaultComboBoxModel)this.mRuleCb.getModel();
            model.removeElementAt(i);
            model.insertElementAt(comp, i);
            this.mRuleCb.setSelectedIndex(i);
            this.mNameTF.setText(comp.getName());
            this.mDescTF.setText(comp.getDescription());
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            Object o = e.getSource();
            if (o == this.mRuleCb) {
                Object item;
                if (this.mRulePanel != null) {
                    this.mCenterPanel.remove(this.mTypeDescriptionPanel);
                    this.mCenterPanel.remove(this.mRulePanel);
                }
                if ((item = this.mRuleCb.getSelectedItem()) instanceof FilterComponent) {
                    FilterComponent fItem = (FilterComponent)item;
                    if (fItem.getTypeDescription() != null && fItem.getTypeDescription().trim().length() > 0) {
                        UiUtilities.updateHtmlHelpTextArea(this.mFilterComponentDescription, fItem.getTypeDescription(), UIManager.getColor("Label.foreground"), UIManager.getColor("Panel.background"));
                        this.mCenterPanel.add((Component)this.mTypeDescriptionPanel, "North");
                    }
                    this.mRulePanel = fItem.getSettingsPanel();
                    if (this.mRulePanel != null) {
                        this.mRulePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
                        this.mCenterPanel.add((Component)this.mRulePanel, "Center");
                    }
                }
                this.mContentPane.updateUI();
                this.updateOkBtn();
            } else if (o == this.mOkBtn) {
                String compName = this.mNameTF.getText();
                if (FilterComponentList.getInstance().exists(compName)) {
                    JOptionPane.showMessageDialog(this, "Component '" + compName + "' already exists");
                } else {
                    FilterComponent c = (FilterComponent)this.mRuleCb.getSelectedItem();
                    c.saveSettings();
                    this.mSelectedFilterComponent = c;
                    this.mSelectedFilterComponent.setName(compName);
                    this.mSelectedFilterComponent.setDescription(this.mDescTF.getText());
                    this.setVisible(false);
                }
            } else if (o == this.mCancelBtn) {
                this.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public FilterComponent getFilterComponent() {
        return this.mSelectedFilterComponent;
    }

    private void updateOkBtn() {
        if (this.mOkBtn != null) {
            Pattern p = Pattern.compile(REGEX_INVALID_CHARACTERS);
            Matcher m = p.matcher(this.mNameTF.getText());
            this.mOkBtn.setEnabled(this.mNameTF.getText().length() > 0 && !m.find() && this.mRuleCb.getSelectedItem() instanceof FilterComponent);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateOkBtn();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateOkBtn();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateOkBtn();
    }

    @Override
    public void close() {
        this.mSelectedFilterComponent = null;
        this.setVisible(false);
    }
}

