/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.filter.dlgs;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.Settings;
import tvbrowser.core.filters.FilterComponent;
import tvbrowser.core.filters.FilterComponentList;
import tvbrowser.core.filters.FilterList;
import tvbrowser.core.filters.ParserException;
import tvbrowser.core.filters.UserFilter;
import tvbrowser.core.filters.filtercomponents.AcceptNoneFilterComponent;
import tvbrowser.core.filters.filtercomponents.SingleChannelFilterComponent;
import tvbrowser.ui.filter.dlgs.EditFilterComponentDlg;
import tvbrowser.ui.filter.dlgs.Utilities;
import util.ui.DragAndDropMouseListener;
import util.ui.ListDragAndDropHandler;
import util.ui.ListDropAction;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class EditFilterDlg
extends JDialog
implements ActionListener,
DocumentListener,
CaretListener,
WindowClosingIf,
ListDropAction {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(EditFilterDlg.class);
    private static final Localizer mFilterLocalizer = Localizer.getLocalizerFor(UserFilter.class);
    private JButton mNewBtn;
    private JButton mEditBtn;
    private JButton mRemoveBtn;
    private JButton mOkBtn;
    private JButton mCancelBtn;
    private Window mParent;
    private JTextField mFilterNameTF;
    private JTextField mFilterRuleTF;
    private UserFilter mFilter = null;
    private JLabel mFilterRuleErrorLb;
    private JLabel mColLb;
    private String mFilterName = null;
    private FilterList mFilterList;
    private JList mFilterConstruction;
    private JList mFilterComponentList;
    private static String AND_KEY = "and";
    private static String OR_KEY = "or";
    private static String NOT_KEY = "not";
    private static String OPEN_BRACKET_KEY = "open_bracket";
    private static String CLOSE_BRACKET_KEY = "close_bracket";
    private DefaultListModel mFilterComponentListModel;
    private DefaultListModel mFilterConstructionListModel;
    private boolean mFromFilterList;
    private boolean mOkWasPressed;

    public EditFilterDlg(Window parent, FilterList filterList, UserFilter filter, boolean fromFilterList) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        this.init(parent, filterList, filter, fromFilterList);
    }

    private void init(Window parent, FilterList filterList, UserFilter filter, boolean fromFilterList) {
        UiUtilities.registerForClosing(this);
        this.mFromFilterList = fromFilterList;
        this.mOkWasPressed = false;
        if (filter == null) {
            this.setTitle(mLocalizer.msg("titleNew", "Create filter"));
        } else {
            this.setTitle(mLocalizer.msg("titleEdit", "Edit filter {0}", filter.toString()));
            this.mFilterName = filter.toString();
        }
        this.mFilterList = filterList;
        this.mParent = parent;
        this.mFilter = filter;
        this.mFilterNameTF = new JTextField(new PlainDocument(){

            @Override
            public void insertString(int offset, String str, AttributeSet a) throws BadLocationException {
                str = str.replaceAll("[\\p{Punct}&&[^_]]", "_");
                super.insertString(offset, str, a);
            }
        }, "", 30);
        this.mFilterNameTF.getDocument().addDocumentListener(this);
        this.mFilterNameTF.setEditable(fromFilterList);
        this.mFilterRuleTF = new JTextField();
        this.mFilterRuleTF.getDocument().addDocumentListener(this);
        this.mFilterRuleTF.addCaretListener(this);
        FormLayout layout = new FormLayout("5dlu,fill:min:grow,5dlu,default,5dlu", "default,5dlu,default,10dlu,default,5dlu,default,default,5dlu,default,5dlu,fill:min:grow,5dlu,default,5dlu,default,5dlu,default");
        PanelBuilder filterCreation = new PanelBuilder(layout);
        filterCreation.border(Borders.DIALOG);
        filterCreation.addSeparator(mLocalizer.msg("filterName", "Filter name:"), CC.xyw(1, 1, 5));
        filterCreation.add((Component)this.mFilterNameTF, CC.xyw(2, 3, 3));
        filterCreation.addSeparator(mLocalizer.msg("ruleString", "Filter rule:"), CC.xyw(1, 5, 5));
        filterCreation.add((Component)this.mFilterRuleTF, CC.xy(2, 7));
        this.mColLb = filterCreation.addLabel("0", CC.xy(4, 7));
        this.mFilterRuleErrorLb = filterCreation.addLabel(mLocalizer.msg("ruleExample", "example: component1 or (component2 and not component3)"), CC.xy(2, 8));
        FormLayout filterCompLayout = new FormLayout("default:grow,5dlu,default", "default,5dlu,default,5dlu,default,fill:min:grow");
        PanelBuilder filterComponents = new PanelBuilder(filterCompLayout);
        this.mNewBtn = new JButton(TVBrowserIcons.newIcon(16));
        this.mNewBtn.setToolTipText(mLocalizer.msg("newButton", "Create new filter component..."));
        this.mEditBtn = new JButton(TVBrowserIcons.edit(16));
        this.mEditBtn.setToolTipText(mLocalizer.msg("editButton", "Edit selected filter component..."));
        this.mRemoveBtn = new JButton(TVBrowserIcons.delete(16));
        this.mRemoveBtn.setToolTipText(mLocalizer.msg("removeButton", "Delete selected filter component"));
        this.mNewBtn.addActionListener(this);
        this.mEditBtn.addActionListener(this);
        this.mRemoveBtn.addActionListener(this);
        ButtonBarBuilder bottomBar = Utilities.createFilterButtonBar();
        this.mOkBtn = new JButton(Localizer.getLocalization("i18n_ok"));
        this.mOkBtn.addActionListener(this);
        this.getRootPane().setDefaultButton(this.mOkBtn);
        this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelBtn.addActionListener(this);
        bottomBar.addButton(this.mOkBtn, this.mCancelBtn);
        FilterComponent[] fc = FilterComponentList.getInstance().getAvailableFilterComponents();
        Arrays.sort(fc, new FilterComponent.NameComparator());
        this.mFilterComponentListModel = new DefaultListModel();
        this.mFilterComponentList = new JList(this.mFilterComponentListModel);
        this.mFilterComponentList.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof FilterItem) {
                    FilterItem item = (FilterItem)value;
                    if (item.isAndItem() || item.isNotItem() || item.isOrItem() || item.isOpenBracketItem() || item.isCloseBracketItem()) {
                        label.setFont(label.getFont().deriveFont(1));
                    } else if (item.getComponent().getDescription().length() > 0) {
                        label.setText(label.getText() + " [" + item.getComponent().getDescription() + "]");
                    }
                    label.setText(FilterComponentList.getLabelForComponent(item.getComponent(), label.getText()));
                }
                return label;
            }
        });
        this.mFilterComponentList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                EditFilterDlg.this.updateBtns();
            }
        });
        this.mFilterComponentList.setSelectionMode(0);
        this.mFilterComponentListModel.addElement(new FilterItem(AND_KEY, 0));
        this.mFilterComponentListModel.addElement(new FilterItem(OR_KEY, 0));
        this.mFilterComponentListModel.addElement(new FilterItem(NOT_KEY, 0));
        this.mFilterComponentListModel.addElement(new FilterItem(OPEN_BRACKET_KEY, 0));
        this.mFilterComponentListModel.addElement(new FilterItem(CLOSE_BRACKET_KEY, 0));
        this.mFilterConstructionListModel = new DefaultListModel();
        this.mFilterConstruction = new JList(this.mFilterConstructionListModel);
        this.mFilterConstruction.setSelectionMode(0);
        this.mFilterConstruction.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                try {
                    if (value instanceof FilterItem) {
                        FilterItem item = (FilterItem)value;
                        FormLayout layout = new FormLayout("default:grow", "default");
                        for (int i = 0; i < item.getLevel(); ++i) {
                            layout.insertColumn(1, ColumnSpec.decode("9dlu"));
                        }
                        JPanel panel = new JPanel(layout);
                        panel.setOpaque(false);
                        if (item.isAndItem() || item.isOrItem() || item.isNotItem()) {
                            label.setFont(label.getFont().deriveFont(1));
                            layout.insertColumn(1, ColumnSpec.decode("3dlu"));
                            panel.add((Component)label, CC.xy(item.getLevel() + 2, 1));
                        } else if (item.isOpenBracketItem() || item.isCloseBracketItem()) {
                            label.setFont(label.getFont().deriveFont(1));
                            panel.add((Component)label, CC.xy(item.getLevel() + 1, 1));
                        } else {
                            panel.add((Component)label, CC.xy(item.getLevel() + 1, 1));
                            label.setText(FilterComponentList.getLabelForComponent(item.getComponent(), label.getText()));
                        }
                        if (index > 0) {
                            FilterItem test = (FilterItem)list.getModel().getElementAt(index - 1);
                            FilterItem test2 = null;
                            if (index < list.getModel().getSize() - 2) {
                                test2 = (FilterItem)list.getModel().getElementAt(index + 1);
                            }
                            if (test.isCloseBracketItem() && !item.isAndItem() && !item.isOrItem() && !item.isCloseBracketItem()) {
                                label.setForeground(Color.red);
                            } else if (item.isNotItem() && (!test.isAndItem() && !test.isOrItem() || test.isNotItem()) && (test2 == null || test2.getComponent() == null)) {
                                label.setForeground(Color.red);
                            } else if ((item.isAndItem() || item.isOrItem()) && (test.isAndItem() || test.isOrItem() || test.isOpenBracketItem())) {
                                label.setForeground(Color.red);
                            } else if (item.getComponent() != null && test2 != null && test2.isNotItem()) {
                                label.setForeground(Color.red);
                            } else if (!(test2 == null || !test2.isOpenBracketItem() || item.isAndItem() || item.isOrItem() || item.isNotItem() || item.isOpenBracketItem())) {
                                label.setForeground(Color.red);
                            } else if (index == list.getModel().getSize() - 1 && (item.isAndItem() || item.isNotItem() || item.isOrItem() || item.isOpenBracketItem())) {
                                label.setForeground(Color.red);
                            } else if (item.getComponent() != null && test.getComponent() != null) {
                                label.setForeground(Color.red);
                            }
                        }
                        return panel;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return label;
            }
        });
        if (this.mFilter != null) {
            this.mFilterName = filter.getName();
            this.mFilterNameTF.setText(this.mFilter.toString());
            this.mFilterRuleTF.setText(this.mFilter.getRule());
            this.fillFilterConstruction();
        }
        ListDragAndDropHandler dnDHandler = new ListDragAndDropHandler(this.mFilterComponentList, this.mFilterConstruction, this);
        new DragAndDropMouseListener(this.mFilterComponentList, this.mFilterConstruction, this, dnDHandler, false);
        new DragAndDropMouseListener(this.mFilterConstruction, this.mFilterComponentList, this, dnDHandler);
        this.mFilterComponentList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                EditFilterDlg.this.mFilterComponentList.requestFocus();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e) && e.getClickCount() == 2) {
                    int index = EditFilterDlg.this.mFilterComponentList.locationToIndex(e.getPoint());
                    EditFilterDlg.this.mFilterComponentList.setSelectedIndex(index);
                    EditFilterDlg.this.editSelectedFilterComponent();
                }
            }
        });
        for (FilterComponent element : fc) {
            this.mFilterComponentListModel.addElement(new FilterItem(element, 0));
        }
        filterComponents.add((Component)this.mNewBtn, CC.xy(3, 1));
        filterComponents.add((Component)this.mEditBtn, CC.xy(3, 3));
        filterComponents.add((Component)this.mRemoveBtn, CC.xy(3, 5));
        filterComponents.add((Component)new JScrollPane(this.mFilterComponentList), CC.xywh(1, 1, 1, 6));
        PanelBuilder listPanel = new PanelBuilder(new FormLayout("5dlu,min:grow,5dlu,10dlu,5dlu,min:grow,5dlu", "default,5dlu,fill:min:grow"));
        listPanel.addSeparator(mLocalizer.msg("componentsTitle", "Available filter components:"), CC.xyw(5, 1, 3));
        listPanel.add((Component)filterComponents.getPanel(), CC.xy(6, 3));
        listPanel.addSeparator(mLocalizer.msg("filterConstruction", "Filter construction"), CC.xyw(1, 1, 3));
        listPanel.add((Component)new JScrollPane(this.mFilterConstruction), CC.xy(2, 3));
        filterCreation.add((Component)listPanel.getPanel(), CC.xyw(1, 12, 4));
        filterCreation.add((Component)UiUtilities.createHelpTextArea(mLocalizer.msg("help", "To create or edit a filter you can enter the rules in the text field or drag and drop the rules to the left side.")), CC.xyw(2, 14, 4));
        filterCreation.add((Component)new JSeparator(0), CC.xyw(1, 16, 4));
        filterCreation.add((Component)bottomBar.getPanel(), CC.xyw(1, 18, 4));
        this.updateBtns();
        this.setMinimumSize(new Dimension(600, 560));
        this.setLayout(new BorderLayout());
        this.add((Component)filterCreation.getPanel(), "Center");
        Settings.layoutWindow("editFilterDlg", this, this.getMinimumSize(), this.mParent);
        this.setVisible(true);
    }

    private void updateBtns() {
        if (this.mFilterComponentList == null) {
            return;
        }
        if (this.mFilterComponentList.getSelectedIndex() > 0) {
            FilterItem item = (FilterItem)this.mFilterComponentList.getSelectedValue();
            this.mRemoveBtn.setEnabled(!item.isAndItem() && !item.isOrItem() && !item.isNotItem() && !item.isOpenBracketItem() && !item.isCloseBracketItem() && !(item.getComponent() instanceof SingleChannelFilterComponent));
            this.mEditBtn.setEnabled(this.mRemoveBtn.isEnabled() && !(item.getComponent() instanceof AcceptNoneFilterComponent));
        } else {
            this.mEditBtn.setEnabled(false);
            this.mRemoveBtn.setEnabled(false);
        }
        boolean validRule = true;
        try {
            UserFilter.testTokenTree(this.mFilterRuleTF.getText());
            this.mFilterRuleErrorLb.setForeground(UIManager.getColor("Label.foreground"));
            this.mFilterRuleErrorLb.setText(mLocalizer.msg("ruleExample", "example: component1 or (component2 and not component3)"));
        }
        catch (ParserException e) {
            this.mFilterRuleErrorLb.setForeground(Color.red);
            this.mFilterRuleErrorLb.setText(e.getMessage());
            validRule = false;
        }
        if (this.mFilterRuleTF.hasFocus() && validRule) {
            this.fillFilterConstruction();
        }
        this.mOkBtn.setEnabled(StringUtils.isNotBlank(this.mFilterNameTF.getText()) && this.mFilterComponentList.getModel().getSize() > 0 && validRule);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.mNewBtn) {
            EditFilterComponentDlg dlg = new EditFilterComponentDlg(this);
            FilterComponent rule = dlg.getFilterComponent();
            if (rule != null) {
                this.mFilterComponentListModel.addElement(new FilterItem(rule, 0));
                FilterComponentList.getInstance().add(rule);
                String text = this.mFilterRuleTF.getText();
                if (text.length() > 0) {
                    text = text + " " + mFilterLocalizer.msg("or", "or") + " ";
                }
                text = text + rule.getName();
                this.mFilterRuleTF.setText(text);
                this.fillFilterConstruction();
            }
        } else if (o == this.mEditBtn) {
            this.editSelectedFilterComponent();
        } else if (o == this.mFilterComponentList) {
            this.updateBtns();
        } else if (o == this.mRemoveBtn) {
            FilterComponent fc;
            UserFilter[] userFilterArr;
            boolean allowRemove;
            block28: {
                allowRemove = true;
                userFilterArr = this.mFilterList.getUserFilterArr();
                fc = ((FilterItem)this.mFilterComponentListModel.getElementAt(this.mFilterComponentList.getSelectedIndex())).getComponent();
                UserFilter testFilter = new UserFilter("test");
                try {
                    testFilter.setRule(this.mFilterRuleTF.getText());
                    if (testFilter.containsRuleComponent(fc.getName())) {
                        allowRemove = false;
                        JOptionPane.showMessageDialog(this, mLocalizer.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", this.mFilterNameTF.getText()));
                    }
                }
                catch (Exception ex) {
                    if (this.mFilter == null || !this.mFilter.containsRuleComponent(fc.getName())) break block28;
                    allowRemove = false;
                    JOptionPane.showMessageDialog(this, mLocalizer.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", this.mFilterNameTF.getText()));
                }
            }
            for (int i = 0; i < userFilterArr.length && allowRemove; ++i) {
                if (userFilterArr[i] == this.mFilter || !userFilterArr[i].containsRuleComponent(fc.getName())) continue;
                allowRemove = false;
                JOptionPane.showMessageDialog(this, mLocalizer.msg("usedByAnotherFilter", "This filter component is used by filter '{0}'\nRemove the filter first.", userFilterArr[i].toString()));
            }
            if (allowRemove) {
                FilterComponentList.getInstance().remove(fc.getName());
                this.mFilterComponentListModel.removeElementAt(this.mFilterComponentList.getSelectedIndex());
                this.updateBtns();
            }
        } else if (o == this.mOkBtn) {
            this.mOkWasPressed = true;
            if (this.mFromFilterList) {
                String filterName = this.mFilterNameTF.getText();
                if (!filterName.equalsIgnoreCase(this.mFilterName) && this.mFilterList.containsFilter(filterName)) {
                    JOptionPane.showMessageDialog(this, mLocalizer.msg("alreadyExists", "Filter '{0}' already exists.", filterName));
                    this.mOkWasPressed = false;
                } else {
                    if (this.mFilter == null) {
                        this.mFilter = new UserFilter(this.mFilterNameTF.getText());
                    } else {
                        this.mFilter.setName(this.mFilterNameTF.getText());
                    }
                    try {
                        this.mFilter.setRule(this.mFilterRuleTF.getText());
                        FilterComponentList.getInstance().store();
                        this.setVisible(false);
                    }
                    catch (ParserException exc) {
                        this.mOkWasPressed = false;
                        JOptionPane.showMessageDialog(this, mLocalizer.msg("invalidRule", "Invalid rule: ") + exc.getMessage());
                    }
                }
            } else {
                try {
                    this.mFilter.setRule(this.mFilterRuleTF.getText());
                    FilterComponentList.getInstance().store();
                    this.setVisible(false);
                }
                catch (ParserException e1) {
                    this.mOkWasPressed = false;
                    JOptionPane.showMessageDialog(this, mLocalizer.msg("invalidRule", "Invalid rule: ") + e1.getMessage());
                }
            }
        } else if (o == this.mCancelBtn) {
            this.setVisible(false);
        }
    }

    public boolean getOkWasPressed() {
        return this.mOkWasPressed;
    }

    public UserFilter getUserFilter() {
        return this.mFilter;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateBtns();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.mColLb.setText("pos: " + this.mFilterRuleTF.getCaretPosition());
    }

    @Override
    public void close() {
        this.setVisible(false);
    }

    public boolean checkValueForRuleType(String value, String ruleType) {
        if (ruleType != null) {
            if (ruleType.equals(AND_KEY) && (value.toLowerCase().equals("and") || value.toLowerCase().equals("und"))) {
                return true;
            }
            if (ruleType.equals(OR_KEY) && (value.toLowerCase().equals("or") || value.toLowerCase().equals("oder"))) {
                return true;
            }
            if (ruleType.equals(NOT_KEY) && (value.toLowerCase().equals("not") || value.toLowerCase().equals("nicht"))) {
                return true;
            }
            if (ruleType.equals(OPEN_BRACKET_KEY) && value.toLowerCase().equals("(")) {
                return true;
            }
            if (ruleType.equals(CLOSE_BRACKET_KEY) && value.toLowerCase().equals(")")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void drop(JList source, JList target, int row, boolean move) {
        try {
            int i;
            this.mFilterNameTF.requestFocus();
            if (target.equals(this.mFilterConstruction)) {
                if (source.equals(this.mFilterComponentList)) {
                    FilterItem value = (FilterItem)source.getSelectedValue();
                    ((DefaultListModel)target.getModel()).add(row, value.clone(0));
                    int level = 0;
                    for (int i2 = 0; i2 < target.getModel().getSize(); ++i2) {
                        FilterItem item = (FilterItem)target.getModel().getElementAt(i2);
                        if (item.toString().equals("(")) {
                            item.setLevel(level++);
                            continue;
                        }
                        if (item.toString().equals(")")) {
                            --level;
                            level = Math.max(level, 0);
                            item.setLevel(level);
                            continue;
                        }
                        item.setLevel(level);
                    }
                } else {
                    UiUtilities.moveSelectedItems(target, row, false);
                    int level = 0;
                    for (i = 0; i < target.getModel().getSize(); ++i) {
                        FilterItem item = (FilterItem)target.getModel().getElementAt(i);
                        if (item.toString().equals("(")) {
                            item.setLevel(level++);
                            continue;
                        }
                        if (item.toString().equals(")")) {
                            --level;
                            level = Math.max(level, 0);
                            item.setLevel(level);
                            continue;
                        }
                        item.setLevel(level);
                    }
                }
            } else if (source.equals(this.mFilterConstruction)) {
                ((DefaultListModel)source.getModel()).remove(source.getSelectedIndex());
                int level = 0;
                for (i = 0; i < source.getModel().getSize(); ++i) {
                    FilterItem item = (FilterItem)source.getModel().getElementAt(i);
                    if (item.toString().equals("(")) {
                        item.setLevel(level++);
                        continue;
                    }
                    if (item.toString().equals(")")) {
                        --level;
                        level = Math.max(level, 0);
                        item.setLevel(level);
                        continue;
                    }
                    item.setLevel(level);
                }
            }
            StringBuilder build = new StringBuilder();
            for (i = 0; i < this.mFilterConstruction.getModel().getSize(); ++i) {
                build.append(this.mFilterConstruction.getModel().getElementAt(i).toString()).append(" ");
            }
            if (build.length() > 0) {
                build.delete(build.length() - 1, build.length());
            }
            this.mFilterRuleTF.setText(build.toString());
            if (source != null) {
                source.repaint();
            }
            if (target != null) {
                target.repaint();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private void fillFilterConstruction() {
        this.mFilterConstructionListModel.clear();
        ArrayList<String> values = new ArrayList<String>();
        String rule = this.mFilterRuleTF.getText();
        for (int i = rule.length() - 1; i > 0; --i) {
            if (rule.charAt(i) == ' ') {
                values.add(0, rule.substring(i).trim());
                rule = rule.substring(0, i).trim();
                i = rule.length();
                continue;
            }
            if (rule.charAt(i) != '(' && rule.charAt(i) != ')') continue;
            String test = rule.substring(i + 1).trim();
            if (test.length() > 0) {
                values.add(0, test);
            }
            values.add(0, rule.substring(i, i + 1));
            rule = rule.substring(0, i).trim();
            i = rule.length();
        }
        if (!rule.isEmpty()) {
            values.add(0, rule.trim());
        }
        int level = 0;
        for (String value : values) {
            if (this.checkValueForRuleType(value, AND_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(AND_KEY, level));
            } else if (this.checkValueForRuleType(value, OR_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(OR_KEY, level));
            } else if (this.checkValueForRuleType(value, NOT_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(NOT_KEY, level));
            } else if (this.checkValueForRuleType(value, OPEN_BRACKET_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(OPEN_BRACKET_KEY, level));
                ++level;
            } else if (this.checkValueForRuleType(value, CLOSE_BRACKET_KEY)) {
                this.mFilterConstructionListModel.addElement(new FilterItem(CLOSE_BRACKET_KEY, --level));
            } else {
                for (FilterComponent element : FilterComponentList.getInstance().getAvailableFilterComponents()) {
                    if (!element.getName().equals(value)) continue;
                    this.mFilterConstructionListModel.addElement(new FilterItem(element, level));
                }
            }
            level = Math.max(level, 0);
        }
    }

    private void editSelectedFilterComponent() {
        int inx = this.mFilterComponentList.getSelectedIndex();
        if (inx == -1) {
            return;
        }
        FilterComponent rule = ((FilterItem)this.mFilterComponentListModel.getElementAt(inx)).getComponent();
        FilterComponentList.getInstance().remove(rule.getName());
        this.mFilterComponentListModel.removeElementAt(inx);
        EditFilterComponentDlg dlg = null;
        dlg = this.mParent instanceof JFrame ? new EditFilterComponentDlg((JFrame)this.mParent, rule) : new EditFilterComponentDlg((JDialog)this.mParent, rule);
        FilterComponent newRule = dlg.getFilterComponent();
        if (newRule == null) {
            newRule = rule;
        }
        FilterComponentList.getInstance().add(newRule);
        this.mFilterComponentListModel.addElement(new FilterItem(newRule, 0));
        this.mFilterConstruction.repaint();
        this.updateBtns();
    }

    private class FilterItem {
        private String mRuleType;
        private FilterComponent mComponent;
        private int mLevel;

        private FilterItem(String ruleType, int level, FilterComponent comp) {
            this.mRuleType = ruleType;
            this.mLevel = level;
            this.mComponent = comp;
        }

        public FilterItem(String ruleType, int level) {
            this.mRuleType = ruleType;
            this.mComponent = null;
            this.mLevel = level;
        }

        public FilterItem(FilterComponent comp, int level) {
            this.mRuleType = null;
            this.mComponent = comp;
            this.mLevel = level;
        }

        public String toString() {
            if (this.mRuleType != null) {
                if (EditFilterDlg.this.getLocale().getLanguage().equals("de")) {
                    if (this.mRuleType.equals(AND_KEY)) {
                        return "UND";
                    }
                    if (this.mRuleType.equals(OR_KEY)) {
                        return "ODER";
                    }
                    if (this.mRuleType.equals(NOT_KEY)) {
                        return "NICHT";
                    }
                } else {
                    if (this.mRuleType.equals(AND_KEY)) {
                        return "AND";
                    }
                    if (this.mRuleType.equals(OR_KEY)) {
                        return "OR";
                    }
                    if (this.mRuleType.equals(NOT_KEY)) {
                        return "NOT";
                    }
                }
                if (this.mRuleType.equals(OPEN_BRACKET_KEY)) {
                    return "(";
                }
                if (this.mRuleType.equals(CLOSE_BRACKET_KEY)) {
                    return ")";
                }
            }
            return this.mComponent.getName();
        }

        public void setLevel(int level) {
            this.mLevel = level;
        }

        public int getLevel() {
            return this.mLevel;
        }

        public FilterComponent getComponent() {
            return this.mComponent;
        }

        public FilterItem clone(int level) {
            return new FilterItem(this.mRuleType, level, this.mComponent);
        }

        public boolean isOpenBracketItem() {
            return this.mRuleType != null && this.mRuleType.equals(OPEN_BRACKET_KEY);
        }

        public boolean isCloseBracketItem() {
            return this.mRuleType != null && this.mRuleType.equals(CLOSE_BRACKET_KEY);
        }

        public boolean isAndItem() {
            return this.mRuleType != null && this.mRuleType.equals(AND_KEY);
        }

        public boolean isOrItem() {
            return this.mRuleType != null && this.mRuleType.equals(OR_KEY);
        }

        public boolean isNotItem() {
            return this.mRuleType != null && this.mRuleType.equals(NOT_KEY);
        }
    }
}

