/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.mainframe;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import devplugin.Channel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.core.ChannelList;
import tvbrowser.core.DummyChannel;
import tvbrowser.core.Settings;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.ui.mainframe.PanelButton;
import tvbrowser.ui.mainframe.PeriodItem;
import tvbrowser.ui.mainframe.TvDataServiceCheckBox;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class UpdateDlg
extends JDialog
implements ActionListener,
WindowClosingIf {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(UpdateDlg.class);
    protected static final int CANCEL = -1;
    protected static final int GETALL = 28;
    private JButton mCancelBtn;
    private JButton mUpdateBtn;
    private int mResult = 0;
    private JComboBox mManuelDownloadPeriodSelection;
    private JComboBox mAutoDownloadPeriodSelection;
    private TvDataServiceCheckBox[] mDataServiceCbArr;
    private TvDataServiceProxy[] mSelectedTvDataServiceArr;
    private JCheckBox mAutoUpdate;
    private JCheckBox mSaveAsDefaultPeriod;
    private JCheckBox mSaveAsDefaultDataservices;
    private JRadioButton mStartUpdate;
    private JRadioButton mRecurrentUpdate;

    public UpdateDlg(JFrame parent, boolean modal, String reason) {
        super((Frame)parent, modal);
        UiUtilities.registerForClosing(this);
        this.mResult = -1;
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setTitle(mLocalizer.msg("dlgTitle", "TV data update"));
        JPanel buttonPanel = new JPanel(new FlowLayout(4));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.mUpdateBtn = new JButton(mLocalizer.msg("updateNow", "Update now"));
        this.mUpdateBtn.addActionListener(this);
        buttonPanel.add(this.mUpdateBtn);
        this.getRootPane().setDefaultButton(this.mUpdateBtn);
        this.mCancelBtn = new JButton(Localizer.getLocalization("i18n_cancel"));
        this.mCancelBtn.addActionListener(this);
        buttonPanel.add(this.mCancelBtn);
        contentPane.add((Component)buttonPanel, "South");
        JPanel northPanel = new JPanel();
        northPanel.setLayout(new BoxLayout(northPanel, 1));
        if (reason != null && !reason.isEmpty()) {
            String question = mLocalizer.msg("question", "Do you want to update now?");
            JLabel lbReason = new JLabel("<html>" + reason + "<br>" + question + "</html>");
            JPanel panelReason = new JPanel(new BorderLayout(7, 0));
            panelReason.add((Component)lbReason, "West");
            northPanel.add(panelReason);
            northPanel.add(new JLabel(" "));
        }
        PanelBuilder panel1 = new PanelBuilder(new FormLayout("10dlu,default,5dlu:grow,5dlu", "default,5dlu,default,default"));
        panel1.addSeparator(mLocalizer.msg("period", "Update program for"), CC.xyw(1, 1, 4));
        this.mManuelDownloadPeriodSelection = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        this.mSaveAsDefaultPeriod = new JCheckBox(mLocalizer.msg("saveDefault", "Save as default"), Settings.propSaveDefaultDataUpdateValuesDefault.getBoolean());
        panel1.add((Component)this.mManuelDownloadPeriodSelection, CC.xyw(2, 3, 2));
        panel1.add((Component)this.mSaveAsDefaultPeriod, CC.xyw(2, 4, 2));
        northPanel.add(panel1.getPanel());
        TvDataServiceProxy[] serviceArr = this.getActiveDataServices();
        if (serviceArr.length > 1) {
            JPanel dataServicePanel = new JPanel();
            dataServicePanel.setLayout(new BoxLayout(dataServicePanel, 1));
            this.mDataServiceCbArr = new TvDataServiceCheckBox[serviceArr.length];
            String[] checkedServiceNames = Settings.propDataServicesForUpdate.getStringArray();
            boolean expand = false;
            for (int i = 0; i < serviceArr.length; ++i) {
                this.mDataServiceCbArr[i] = new TvDataServiceCheckBox(serviceArr[i]);
                boolean isSelected = this.tvDataServiceIsChecked(serviceArr[i], checkedServiceNames);
                this.mDataServiceCbArr[i].setSelected(isSelected);
                if (!isSelected) {
                    expand = true;
                }
                dataServicePanel.add(this.mDataServiceCbArr[i]);
            }
            this.mSaveAsDefaultDataservices = new JCheckBox(mLocalizer.msg("saveDefault", "Save as default"), Settings.propSaveDefaultDataUpdateValuesDefault.getBoolean());
            dataServicePanel.add(Box.createRigidArea(new Dimension(0, Sizes.dialogUnitXAsPixel(5, dataServicePanel))));
            dataServicePanel.add(this.mSaveAsDefaultDataservices);
            PanelBuilder ds = new PanelBuilder(new FormLayout("10dlu,default:grow,5dlu,default", "10dlu,default,5dlu,default"));
            ds.add((Component)dataServicePanel, CC.xyw(2, 4, 3));
            ds.addSeparator(mLocalizer.msg("dataSources", "Data sources"), CC.xyw(1, 2, 2));
            dataServicePanel.setVisible(expand);
            PanelButton open = new PanelButton(dataServicePanel, this);
            ds.add((Component)open, CC.xy(4, 2));
            northPanel.add(ds.getPanel());
        }
        int period = Settings.propDownloadPeriod.getInt();
        PeriodItem pi = new PeriodItem(period);
        this.mManuelDownloadPeriodSelection.setSelectedItem(pi);
        PanelBuilder pb = new PanelBuilder(new FormLayout("10dlu,default:grow,5dlu,default", "10dlu,default,5dlu,default"));
        pb.addSeparator(mLocalizer.msg("autoUpdateTitle", "Automatic update"), CC.xyw(1, 2, 2));
        JPanel boxPanel = new JPanel(new FormLayout("10dlu,0dlu,default:grow", "default,2dlu,default,default,4dlu,default,3dlu,default"));
        this.mAutoUpdate = new JCheckBox(mLocalizer.msg("autoUpdateMessage", "Update data automatically"), !Settings.propAutoDownloadType.getString().equals("never"));
        boxPanel.setVisible(!this.mAutoUpdate.isSelected());
        this.mStartUpdate = new JRadioButton(mLocalizer.msg("onStartUp", "Only on TV-Browser startup"), !Settings.propAutoDataDownloadEnabled.getBoolean() && this.mAutoUpdate.isSelected());
        this.mRecurrentUpdate = new JRadioButton(mLocalizer.msg("recurrent", "Recurrent"), Settings.propAutoDataDownloadEnabled.getBoolean());
        this.mAutoDownloadPeriodSelection = new JComboBox<PeriodItem>(PeriodItem.getPeriodItems());
        period = Settings.propAutoDownloadPeriod.getInt();
        pi = new PeriodItem(period);
        this.mAutoDownloadPeriodSelection.setSelectedItem(pi);
        final JLabel label = new JLabel(mLocalizer.msg("period", "Update program for") + ":");
        boxPanel.add((Component)this.mAutoUpdate, CC.xyw(1, 1, 3));
        boxPanel.add((Component)this.mStartUpdate, CC.xyw(2, 3, 2));
        boxPanel.add((Component)this.mRecurrentUpdate, CC.xyw(2, 4, 2));
        boxPanel.add((Component)label, CC.xyw(2, 6, 2));
        boxPanel.add((Component)this.mAutoDownloadPeriodSelection, CC.xy(3, 8));
        this.mRecurrentUpdate.setEnabled(this.mAutoUpdate.isSelected());
        this.mStartUpdate.setEnabled(this.mAutoUpdate.isSelected());
        label.setEnabled(this.mAutoUpdate.isSelected());
        this.mAutoDownloadPeriodSelection.setEnabled(this.mAutoUpdate.isSelected());
        pb.add((Component)boxPanel, CC.xyw(2, 4, 2));
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mStartUpdate);
        bg.add(this.mRecurrentUpdate);
        PanelButton open = new PanelButton(boxPanel, this);
        pb.add((Component)open, CC.xy(4, 2));
        this.mAutoUpdate.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                UpdateDlg.this.mRecurrentUpdate.setEnabled(e.getStateChange() == 1);
                UpdateDlg.this.mStartUpdate.setEnabled(e.getStateChange() == 1);
                label.setEnabled(e.getStateChange() == 1);
                UpdateDlg.this.mAutoDownloadPeriodSelection.setEnabled(e.getStateChange() == 1);
            }
        });
        northPanel.add(pb.getPanel());
        contentPane.add((Component)northPanel, "North");
        this.mUpdateBtn.requestFocusInWindow();
    }

    private TvDataServiceProxy[] getActiveDataServices() {
        ArrayList<TvDataServiceProxy> services = new ArrayList<TvDataServiceProxy>();
        for (Channel channel : ChannelList.getSubscribedChannels()) {
            if (channel instanceof DummyChannel || channel.getDataServiceProxy() == null || services.contains(channel.getDataServiceProxy())) continue;
            services.add(channel.getDataServiceProxy());
        }
        return services.toArray(new TvDataServiceProxy[services.size()]);
    }

    private boolean tvDataServiceIsChecked(TvDataServiceProxy service, String[] serviceNames) {
        if (serviceNames == null) {
            return true;
        }
        for (String serviceName : serviceNames) {
            if (service.getId().compareTo(serviceName) != 0) continue;
            return true;
        }
        return false;
    }

    public int getResult() {
        return this.mResult;
    }

    public TvDataServiceProxy[] getSelectedTvDataServices() {
        if (this.mSelectedTvDataServiceArr == null) {
            this.mSelectedTvDataServiceArr = this.getActiveDataServices();
        }
        return this.mSelectedTvDataServiceArr;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        Object source = event.getSource();
        if (source == this.mCancelBtn) {
            this.mResult = -1;
            this.setVisible(false);
        } else if (source == this.mUpdateBtn) {
            PeriodItem pi = (PeriodItem)this.mManuelDownloadPeriodSelection.getSelectedItem();
            this.mResult = pi.getDays();
            if (this.mDataServiceCbArr == null) {
                this.mSelectedTvDataServiceArr = this.getActiveDataServices();
            } else {
                ArrayList<TvDataServiceProxy> dataServiceList = new ArrayList<TvDataServiceProxy>();
                for (TvDataServiceCheckBox element : this.mDataServiceCbArr) {
                    if (!element.isSelected()) continue;
                    dataServiceList.add(element.getTvDataService());
                }
                this.mSelectedTvDataServiceArr = new TvDataServiceProxy[dataServiceList.size()];
                dataServiceList.toArray(this.mSelectedTvDataServiceArr);
            }
            if (this.mSaveAsDefaultPeriod.isSelected()) {
                Settings.propDownloadPeriod.setInt(this.mResult);
            }
            if (this.mSaveAsDefaultDataservices == null || this.mSaveAsDefaultDataservices.isSelected()) {
                String[] dataServiceArr = new String[this.mSelectedTvDataServiceArr.length];
                for (int i = 0; i < dataServiceArr.length; ++i) {
                    dataServiceArr[i] = this.mSelectedTvDataServiceArr[i].getId();
                }
                Settings.propDataServicesForUpdate.setStringArray(dataServiceArr);
            }
            if (this.mAutoUpdate.isSelected()) {
                if (Settings.propAutoDownloadType.getString().equals("never")) {
                    Settings.propAutoDownloadType.setString(Settings.propAutoDownloadType.getDefault());
                }
                Settings.propAutoDownloadPeriod.setInt(((PeriodItem)this.mAutoDownloadPeriodSelection.getSelectedItem()).getDays());
            } else {
                Settings.propAutoDownloadType.setString("never");
            }
            Settings.propAutoDataDownloadEnabled.setBoolean(this.mAutoUpdate.isSelected() && this.mRecurrentUpdate.isSelected());
            this.setVisible(false);
        }
    }

    @Override
    public void close() {
        this.mResult = -1;
        this.setVisible(false);
    }

    public void setNumberOfDays(int numberOfDays) {
        for (PeriodItem item : PeriodItem.getPeriodItems()) {
            if (item.getDays() < numberOfDays) continue;
            this.mManuelDownloadPeriodSelection.setSelectedItem(item);
            return;
        }
    }
}

