/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.programtable;

import devplugin.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import tvbrowser.core.Settings;
import tvbrowser.ui.programtable.AbstractProgramTableLayout;
import tvbrowser.ui.programtable.ProgramTableModel;
import util.ui.ProgramPanel;

public class TimeBlockLayout
extends AbstractProgramTableLayout {
    protected boolean mCompactLayout = false;
    protected boolean mOptimizedCompactLayout = false;
    private LastLayoutComponent[] mLastLayoutComponentList;
    private ArrayList<ProgramPanel>[] mBlockProgramList;

    @Override
    public void updateLayout(final ProgramTableModel model) {
        int columnCount = model.getColumnCount();
        if (columnCount == 0) {
            return;
        }
        final int[] columnStartArr = new int[columnCount];
        Arrays.fill(columnStartArr, 0);
        int[] lastRow = new int[columnCount];
        Arrays.fill(lastRow, 0);
        final int[] minimumBlockHeight = new int[columnCount];
        this.mLastLayoutComponentList = new LastLayoutComponent[columnCount];
        this.mBlockProgramList = new ArrayList[columnCount];
        for (int i = 0; i < this.mBlockProgramList.length; ++i) {
            this.mBlockProgramList[i] = new ArrayList();
        }
        int blockEnd = 0;
        int blockSize = Settings.propTimeBlockSize.getInt() * 60;
        int blockCount = (Settings.propProgramTableEndOfDay.getInt() + 1440) / blockSize + 1;
        Date nextProgramTableDate = model.getDate().addDays(1);
        for (int block = 0; block < blockCount; ++block) {
            int maxHeight = 0;
            Arrays.fill(minimumBlockHeight, 0);
            for (int column = 0; column < columnCount; ++column) {
                this.mBlockProgramList[column].clear();
                int height = 0;
                int rowCount = model.getRowCount(column);
                for (int row = lastRow[column]; row < rowCount; ++row) {
                    lastRow[column] = row;
                    ProgramPanel panel = model.getProgramPanel(column, row);
                    int startTime = panel.getProgram().getStartTime();
                    if (panel.getProgram().getDate().equals(nextProgramTableDate)) {
                        startTime += 1440;
                    }
                    if (startTime < block * blockSize || startTime >= (block + 1) * blockSize) break;
                    this.mBlockProgramList[column].add(panel);
                    panel.setHeight(-1);
                    if ((height += this.mCompactLayout && (!this.mOptimizedCompactLayout || !panel.getProgram().isOnAir()) ? panel.getMinimumHeight() : panel.getPreferredHeight()) <= maxHeight) continue;
                    maxHeight = height;
                }
                minimumBlockHeight[column] = height;
            }
            final int blockStart = blockEnd;
            final int finalBlockEnd = blockEnd += maxHeight;
            ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 3));
            int col1 = 0;
            while (col1 < columnCount) {
                final int col = col1++;
                threadPool.execute(new Thread("LAYOUT TIME BLOCK COLUMN THREAD"){

                    @Override
                    public void run() {
                        ArrayList list;
                        if (TimeBlockLayout.this.mLastLayoutComponentList[col] != null) {
                            TimeBlockLayout.this.mLastLayoutComponentList[col].getPanel().setHeight(blockStart - TimeBlockLayout.this.mLastLayoutComponentList[col].getPrePosition());
                        }
                        if (!(list = TimeBlockLayout.this.mBlockProgramList[col]).isEmpty()) {
                            int internHeight;
                            if (((ProgramPanel)list.get(0)).equals(model.getProgramPanel(col, 0))) {
                                columnStartArr[col] = blockStart;
                            }
                            int internLastHeight = internHeight = blockStart;
                            int additionalHeight = 0;
                            int additionalHeight2 = 0;
                            if (TimeBlockLayout.this.mOptimizedCompactLayout) {
                                additionalHeight = (finalBlockEnd - blockStart - minimumBlockHeight[col]) / list.size();
                                int additionalCount = 0;
                                int preferredSizeHeights = 0;
                                int minimumSizeHeights = 0;
                                for (int i = 0; i < list.size(); ++i) {
                                    ProgramPanel panel = (ProgramPanel)list.get(i);
                                    if (panel.getPreferredHeight() < panel.getMinimumHeight() + additionalHeight || panel.getProgram().isOnAir()) {
                                        preferredSizeHeights += panel.getPreferredHeight();
                                        continue;
                                    }
                                    ++additionalCount;
                                    minimumSizeHeights += panel.getMinimumHeight();
                                }
                                if (additionalCount != 0) {
                                    additionalHeight2 = (finalBlockEnd - blockStart - preferredSizeHeights - minimumSizeHeights) / additionalCount;
                                }
                            }
                            for (int i = 0; i < list.size(); ++i) {
                                ProgramPanel panel = (ProgramPanel)list.get(i);
                                if (TimeBlockLayout.this.mCompactLayout && !TimeBlockLayout.this.mOptimizedCompactLayout) {
                                    panel.setHeight(panel.getMinimumHeight());
                                } else if (!TimeBlockLayout.this.mOptimizedCompactLayout || panel.getMinimumHeight() + additionalHeight > panel.getPreferredHeight() || panel.getProgram().isOnAir()) {
                                    panel.setHeight(panel.getPreferredHeight());
                                } else {
                                    panel.setHeight(panel.getMinimumHeight() + additionalHeight2);
                                }
                                internLastHeight = internHeight;
                                internHeight += panel.getHeight();
                            }
                            ((TimeBlockLayout)TimeBlockLayout.this).mLastLayoutComponentList[col] = new LastLayoutComponent((ProgramPanel)list.get(list.size() - 1), internLastHeight);
                        }
                    }
                });
            }
            threadPool.shutdown();
            try {
                threadPool.awaitTermination(30L, TimeUnit.SECONDS);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        for (int col = 0; col < columnCount; ++col) {
            if (this.mLastLayoutComponentList[col] == null) continue;
            this.mLastLayoutComponentList[col].getPanel().setHeight(blockEnd - this.mLastLayoutComponentList[col].getPrePosition());
        }
        this.setColumnStarts(columnStartArr);
    }

    private static class LastLayoutComponent {
        private ProgramPanel mLastPanel;
        private int mPrePosition;

        protected LastLayoutComponent(ProgramPanel lastPanel, int prePosition) {
            this.mLastPanel = lastPanel;
            this.mPrePosition = prePosition;
        }

        protected ProgramPanel getPanel() {
            return this.mLastPanel;
        }

        protected int getPrePosition() {
            return this.mPrePosition;
        }
    }
}

