/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.PluginCenterPanel;
import devplugin.PluginCenterPanelWrapper;
import devplugin.SettingsTab;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.plugin.PluginProxyManager;
import tvbrowser.extras.common.InternalPluginProxyIf;
import tvbrowser.extras.common.InternalPluginProxyList;
import tvbrowser.ui.DontShowAgainOptionBox;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.UiUtilities;

public class CenterPanelSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(CenterPanelSettingsTab.class);
    private OrderChooser mPanelChooser;
    private JCheckBox mTabBarAlwaysVisible;
    private ArrayList<PluginCenterPanel> mAllPanelList;

    @Override
    public JPanel createSettingsPanel() {
        PluginCenterPanel[] panels;
        PluginCenterPanelWrapper wrapper;
        PluginProxy[] plugins = PluginProxyManager.getInstance().getActivatedPlugins();
        InternalPluginProxyIf[] internalPlugins = InternalPluginProxyList.getInstance().getAvailableProxys();
        this.mAllPanelList = new ArrayList();
        ArrayList<PluginCenterPanel> currentOrderList = new ArrayList<PluginCenterPanel>();
        this.mAllPanelList.add(MainFrame.getInstance().getProgramTableScrollPaneWrapper());
        this.mAllPanelList.add(MainFrame.getInstance().getPluginViewWrapper());
        for (PluginProxy plugin : plugins) {
            try {
                wrapper = plugin.getPluginCenterPanelWrapper();
                if (wrapper == null) continue;
                for (PluginCenterPanel panel : panels = wrapper.getCenterPanels()) {
                    if (panel == null || panel.getName() == null || panel.getPanel() == null || panel.getId() == null) continue;
                    this.mAllPanelList.add(panel);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        for (InternalPluginProxyIf internalPlugin : internalPlugins) {
            try {
                wrapper = internalPlugin.getPluginCenterPanelWrapper();
                if (wrapper == null) continue;
                for (PluginCenterPanel panel : panels = wrapper.getCenterPanels()) {
                    if (panel == null || panel.getName() == null || panel.getPanel() == null || panel.getId() == null) continue;
                    this.mAllPanelList.add(panel);
                }
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        for (String id : Settings.propCenterPanelArr.getStringArray()) {
            for (PluginCenterPanel centerPanel : this.mAllPanelList) {
                if (!id.equals(centerPanel.getId())) continue;
                currentOrderList.add(centerPanel);
            }
        }
        this.mPanelChooser = new OrderChooser(currentOrderList.toArray(), this.mAllPanelList.toArray());
        this.mTabBarAlwaysVisible = new JCheckBox(mLocalizer.msg("alwaysShowTabs", "Always show tabs"), Settings.propAlwaysShowTabBarForCenterPanel.getBoolean());
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default:grow,5dlu", "default,5dlu,fill:default:grow,5dlu,default"));
        pb.border(Borders.DIALOG);
        pb.addSeparator(mLocalizer.msg("info", "Shown tabs in the main window"), cc.xyw(1, 1, 3));
        pb.add((Component)this.mPanelChooser, cc.xy(2, 3));
        pb.add((Component)this.mTabBarAlwaysVisible, cc.xy(2, 5));
        return pb.getPanel();
    }

    @Override
    public void saveSettings() {
        Object[] order = this.mPanelChooser.getOrder();
        ArrayList<String> idList = new ArrayList<String>(order.length);
        for (Object o : order) {
            if (o == null) continue;
            this.mAllPanelList.remove(o);
            idList.add(((PluginCenterPanel)o).getId());
        }
        if (!idList.contains(MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId())) {
            Object[] options = new String[]{mLocalizer.msg("programTableTabKeepDeactivated", "Keep deactivated"), mLocalizer.msg("programTableTabActivate", "Activate program table tab again")};
            if (DontShowAgainOptionBox.showOptionDialog("CenterPanelSettings.programTableTabdeselected", UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("programTableDeselected", "You have deselected the program table you might miss some programs in the future.\nAre you sure?"), mLocalizer.msg("programTableDeselectedTitle", "Program table deselected"), 3, 0, options, options[1], null) == 1) {
                idList.add(0, MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId());
            }
        }
        if (idList.isEmpty()) {
            idList.add(MainFrame.getInstance().getProgramTableScrollPaneWrapper().getId());
        }
        ArrayList<String> disabledIdList = new ArrayList<String>(this.mAllPanelList.size());
        for (PluginCenterPanel centerPanel : this.mAllPanelList) {
            disabledIdList.add(centerPanel.getId());
        }
        Settings.propCenterPanelArr.setStringArray(idList.toArray(new String[idList.size()]));
        Settings.propAlwaysShowTabBarForCenterPanel.setBoolean(this.mTabBarAlwaysVisible.isSelected());
        Settings.propDisabledCenterPanelArr.setStringArray(disabledIdList.toArray(new String[disabledIdList.size()]));
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Main window");
    }
}

