/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.factories.DefaultComponentFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.SettingsTab;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.icontheme.IconTheme;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.icontheme.ThemeDownloadDlg;
import tvbrowser.core.icontheme.ThemeDownloadItem;
import tvbrowser.ui.mainframe.MainFrame;
import tvbrowser.ui.settings.SettingsDialog;
import tvbrowser.ui.settings.looksSettings.JGoodiesLNFSettings;
import tvbrowser.ui.settings.looksSettings.SkinLNFSettings;
import util.ui.CustomComboBoxRenderer;
import util.ui.LinkButton;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.persona.Persona;
import util.ui.persona.PersonaInfo;

public final class LookAndFeelSettingsTab
implements SettingsTab {
    static final Localizer mLocalizer = Localizer.getLocalizerFor(LookAndFeelSettingsTab.class);
    private JComboBox mLfComboBox;
    private JPanel mSettingsPn;
    private JButton mConfigBtn;
    private JComboBox mIconThemes;
    private JComboBox mPluginViewPosition;
    private JComboBox mDateLayout;
    private JComboBox mPersonaSelection;
    private JComboBox mInfoIconThemes;
    private JTextArea mRestartMessage;
    private JButton mRestartButton;
    private int mStartLookAndIndex;
    private int mStartIconIndex;
    private int mStartPluginViewPositionIndex;
    private int mStartInfoIconThemeIndex;
    private String mJGoodiesStartTheme;
    private boolean mJGoodiesStartShadow;
    private String mSkinLFStartTheme;
    private boolean mSomethingChanged = false;
    private SettingsDialog mSettingsDialog;

    private LookAndFeelObj[] getLookAndFeelObjs() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        LookAndFeelObj[] result = new LookAndFeelObj[info.length];
        for (int i = 0; i < info.length; ++i) {
            result[i] = new LookAndFeelObj(info[i]);
        }
        return result;
    }

    public LookAndFeelSettingsTab(SettingsDialog dialog) {
        this.mSettingsDialog = dialog;
    }

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, fill:default:grow, 3dlu, pref, 5dlu", "");
        this.mSettingsPn = new JPanel(layout);
        this.mSettingsPn.setBorder(Borders.DIALOG);
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)DefaultComponentFactory.getInstance().createSeparator(mLocalizer.msg("lookAndFeel", "Look and Feel")), CC.xyw(1, 1, 7));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("channelPosition", "Channel list position") + ":"), CC.xy(2, 3));
        this.mPluginViewPosition = new JComboBox<String>(new String[]{Localizer.getLocalization("i18n_left"), Localizer.getLocalization("i18n_right")});
        if (Settings.propPluginViewIsLeft.getBoolean()) {
            this.mPluginViewPosition.setSelectedIndex(1);
        } else {
            this.mPluginViewPosition.setSelectedIndex(0);
        }
        this.mPluginViewPosition.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.updateRestartMessage();
            }
        });
        this.mSettingsPn.add((Component)this.mPluginViewPosition, CC.xy(4, 3));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("dateFormat", "Layout of Datelist") + ":"), CC.xy(2, 5));
        this.mDateLayout = new JComboBox<String>(new String[]{mLocalizer.msg("dateFormat.datelist", "List"), mLocalizer.msg("dateFormat.calendarTable", "Calendar (Table)"), mLocalizer.msg("dateFormat.calendarButtons", "Calendar (Buttons)")});
        this.mDateLayout.setSelectedIndex(Settings.propViewDateLayout.getInt());
        this.mDateLayout.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.updateRestartMessage();
            }
        });
        this.mSettingsPn.add((Component)this.mDateLayout, CC.xy(4, 5));
        layout.appendRow(RowSpec.decode("5dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("theme", "Theme") + ":"), CC.xy(2, 7));
        Object[] lfObjects = this.getLookAndFeelObjs();
        Arrays.sort(lfObjects);
        this.mLfComboBox = new JComboBox<Object>(lfObjects);
        String lfName = Settings.propLookAndFeel.getString();
        for (Object lfObject : lfObjects) {
            if (!((LookAndFeelObj)lfObject).getLFClassName().equals(lfName)) continue;
            this.mLfComboBox.setSelectedItem(lfObject);
        }
        this.mLfComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.lookChanged();
            }
        });
        this.mSettingsPn.add((Component)this.mLfComboBox, CC.xy(4, 7));
        this.mConfigBtn = new JButton(mLocalizer.msg("config", "Config"));
        this.mConfigBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.configTheme();
            }
        });
        this.mSettingsPn.add((Component)this.mConfigBtn, CC.xy(6, 7));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("persona", "Persona") + ":"), CC.xy(2, 9));
        PersonaInfo[] installedPersonas = Persona.getInstance().getInstalledPersonas();
        this.mPersonaSelection = new JComboBox<PersonaInfo>(installedPersonas);
        final LinkButton personaDetails = new LinkButton(mLocalizer.msg("personaDetails", "Persona details"), "http://www.tvbrowser.org/");
        for (PersonaInfo info : installedPersonas) {
            if (Settings.propRandomPersona.getBoolean()) {
                if (!PersonaInfo.isRandomPersona(info)) continue;
                this.mPersonaSelection.setSelectedItem(info);
                personaDetails.setUrl(info.getDetailURL());
                break;
            }
            if (!Settings.propSelectedPersona.getString().equals(info.getId())) continue;
            this.mPersonaSelection.setSelectedItem(info);
            personaDetails.setUrl(info.getDetailURL());
            break;
        }
        this.mPersonaSelection.setRenderer(new CustomComboBoxRenderer(this.mPersonaSelection.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText(((PersonaInfo)value).getName());
                    label.setToolTipText(((PersonaInfo)value).getDescription());
                    if (((PersonaInfo)value).isSelectedPersona() && PersonaInfo.isRandomPersona((PersonaInfo)value)) {
                        label.setText(label.getText() + ": " + Persona.getInstance().getPersonaInfo(Persona.getInstance().getId()).getName());
                    }
                }
                return label;
            }
        });
        this.mPersonaSelection.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                personaDetails.setUrl(((PersonaInfo)LookAndFeelSettingsTab.this.mPersonaSelection.getSelectedItem()).getDetailURL());
            }
        });
        this.mSettingsPn.add((Component)this.mPersonaSelection, CC.xy(4, 9));
        this.mSettingsPn.add((Component)personaDetails, CC.xy(6, 9));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("icons", "Icons") + ":"), CC.xy(2, 11));
        this.mIconThemes = new JComboBox();
        this.mIconThemes.setRenderer(new CustomComboBoxRenderer(this.mIconThemes.getRenderer()){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value != null) {
                    label.setText(((IconTheme)value).getName());
                    label.setToolTipText(((IconTheme)value).getComment());
                }
                return label;
            }
        });
        this.fillThemeBox();
        JButton downloadThemes = new JButton(mLocalizer.msg("downloadMore", "Download more"));
        downloadThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.downloadIcons(0);
            }
        });
        this.mSettingsPn.add((Component)this.mIconThemes, CC.xy(4, 11));
        this.mSettingsPn.add((Component)downloadThemes, CC.xy(6, 11));
        layout.appendRow(RowSpec.decode("3dlu"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mSettingsPn.add((Component)new JLabel(mLocalizer.msg("infoIcons", "Program info icons") + ":"), CC.xy(2, 13));
        this.mInfoIconThemes = new JComboBox();
        this.fillInfoThemeBox();
        JButton downloadInfoThemes = new JButton(mLocalizer.msg("downloadMore", "Download more"));
        downloadInfoThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.downloadIcons(1);
            }
        });
        this.mSettingsPn.add((Component)this.mInfoIconThemes, CC.xy(4, 13));
        this.mSettingsPn.add((Component)downloadInfoThemes, CC.xy(6, 13));
        layout.appendRow(RowSpec.decode("fill:3dlu:grow"));
        layout.appendRow(RowSpec.decode("pref"));
        this.mRestartMessage = UiUtilities.createHelpTextArea(mLocalizer.msg("restartNote", "Please Restart"));
        this.mRestartMessage.setForeground(Color.RED);
        this.mRestartMessage.setVisible(this.mSomethingChanged);
        this.mRestartButton = new JButton(mLocalizer.msg("restart", "Restart now"));
        this.mRestartButton.setVisible(this.mSomethingChanged);
        this.mRestartButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.mSettingsDialog.saveSettings();
                TVBrowser.addRestart();
                MainFrame.getInstance().quit();
            }
        });
        this.mSettingsPn.add((Component)this.mRestartMessage, CC.xyw(1, 15, 4));
        if (TVBrowser.restartEnabled()) {
            this.mSettingsPn.add((Component)this.mRestartButton, CC.xy(6, 15));
        }
        if (!this.mSomethingChanged) {
            this.mStartLookAndIndex = this.mLfComboBox.getSelectedIndex();
            this.mStartIconIndex = this.mIconThemes.getSelectedIndex();
            this.mStartPluginViewPositionIndex = this.mPluginViewPosition.getSelectedIndex();
            this.mJGoodiesStartTheme = Settings.propJGoodiesTheme.getString();
            this.mJGoodiesStartShadow = Settings.propJGoodiesShadow.getBoolean();
            this.mSkinLFStartTheme = Settings.propSkinLFThemepack.getString();
            this.mStartInfoIconThemeIndex = this.mInfoIconThemes.getSelectedIndex();
        }
        this.mIconThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.updateRestartMessage();
            }
        });
        this.mInfoIconThemes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LookAndFeelSettingsTab.this.updateRestartMessage();
            }
        });
        this.lookChanged();
        return this.mSettingsPn;
    }

    private void downloadIcons(int type) {
        if (JOptionPane.showConfirmDialog(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), mLocalizer.msg("downloadMessage", "To download more icons an Internet connection is needed.\nDo you want to load the list with the available icons now?"), Localizer.getLocalization("i18n_info"), 0) == 0) {
            ThemeDownloadDlg themeDlg = new ThemeDownloadDlg(UiUtilities.getLastModalChildOf(MainFrame.getInstance()), type);
            themeDlg.setVisible(true);
            if (themeDlg.downloadSuccess()) {
                if (type == 0) {
                    this.fillThemeBox();
                } else {
                    ThemeDownloadItem[] successItems;
                    for (ThemeDownloadItem success : successItems = themeDlg.getSuccessItems()) {
                        File theme = new File(InfoThemeLoader.USER_ICON_DIR, success.toString());
                        System.out.println(" ttt " + theme.getAbsolutePath() + " " + theme.isFile());
                        InfoThemeLoader.getInstance().addIconTheme(theme);
                    }
                    this.fillInfoThemeBox();
                }
            }
        }
    }

    private void fillInfoThemeBox() {
        InfoIconTheme[] infoIconThemes = InfoThemeLoader.getInstance().getAvailableInfoIconThemes();
        String currentInfoIconTheme = Settings.propInfoIconThemeID.getString();
        String startIconID = null;
        if (this.mInfoIconThemes.getSelectedIndex() != -1) {
            startIconID = ((InfoIconTheme)this.mInfoIconThemes.getItemAt(this.mStartInfoIconThemeIndex)).getID();
            currentInfoIconTheme = ((InfoIconTheme)this.mInfoIconThemes.getSelectedItem()).getID();
        }
        this.mInfoIconThemes.removeAllItems();
        for (int i = 0; i < infoIconThemes.length; ++i) {
            this.mInfoIconThemes.addItem(infoIconThemes[i]);
            if (startIconID != null && startIconID.equals(infoIconThemes[i].getID())) {
                this.mStartInfoIconThemeIndex = i;
            }
            if (!infoIconThemes[i].getID().equals(currentInfoIconTheme)) continue;
            this.mInfoIconThemes.setSelectedIndex(i);
        }
    }

    private void fillThemeBox() {
        String startIconName = null;
        String selectedName = Settings.propIcontheme.getString();
        if (this.mIconThemes.getSelectedIndex() != -1) {
            startIconName = "icons/" + ((IconTheme)this.mIconThemes.getItemAt(this.mStartIconIndex)).getBase().getName();
            selectedName = "icons/" + ((IconTheme)this.mIconThemes.getSelectedItem()).getBase().getName();
        }
        this.mIconThemes.removeAllItems();
        Object[] available = IconLoader.getInstance().getAvailableThemes();
        Arrays.sort(available);
        for (int i = 0; i < available.length; ++i) {
            this.mIconThemes.addItem(available[i]);
            if (startIconName == null || !("icons/" + ((IconTheme)available[i]).getBase().getName()).equals(startIconName)) continue;
            this.mStartIconIndex = i;
        }
        if (selectedName != null) {
            IconTheme theme = IconLoader.getInstance().getIconTheme(IconLoader.getInstance().getIconThemeFile(selectedName));
            if (theme.loadTheme()) {
                this.mIconThemes.setSelectedItem(theme);
            } else {
                this.mIconThemes.setSelectedItem(IconLoader.getInstance().getDefaultTheme());
            }
        } else {
            this.mIconThemes.setSelectedItem(IconLoader.getInstance().getDefaultTheme());
        }
    }

    private void updateRestartMessage() {
        this.mRestartMessage.setVisible(this.mLfComboBox.getSelectedIndex() != this.mStartLookAndIndex || this.mIconThemes.getSelectedIndex() != this.mStartIconIndex || this.mJGoodiesStartTheme.compareTo(Settings.propJGoodiesTheme.getString()) != 0 || this.mJGoodiesStartShadow != Settings.propJGoodiesShadow.getBoolean() || this.mSkinLFStartTheme.compareTo(Settings.propSkinLFThemepack.getString()) != 0 || this.mPluginViewPosition.getSelectedIndex() != this.mStartPluginViewPositionIndex || this.mStartInfoIconThemeIndex != this.mInfoIconThemes.getSelectedIndex());
        this.mRestartButton.setVisible(this.mRestartMessage.isVisible());
    }

    void configTheme() {
        String classname = ((LookAndFeelObj)this.mLfComboBox.getSelectedItem()).getLFClassName();
        if (classname.startsWith("com.jgoodies")) {
            JGoodiesLNFSettings settings = new JGoodiesLNFSettings((JDialog)UiUtilities.getBestDialogParent(this.mSettingsPn));
            UiUtilities.centerAndShow(settings);
        } else if (classname.startsWith("com.l2fprod.gui.plaf.skin.SkinLookAndFeel")) {
            SkinLNFSettings settings = new SkinLNFSettings((JDialog)UiUtilities.getBestDialogParent(this.mSettingsPn));
            UiUtilities.centerAndShow(settings);
        }
        this.updateRestartMessage();
    }

    void lookChanged() {
        String classname = ((LookAndFeelObj)this.mLfComboBox.getSelectedItem()).getLFClassName();
        if ((classname.startsWith("com.jgoodies") || classname.startsWith("com.l2fprod")) && !classname.startsWith("com.jgoodies.looks.windows.WindowsLookAndFeel")) {
            this.mConfigBtn.setEnabled(true);
        } else {
            this.mConfigBtn.setEnabled(false);
        }
        this.updateRestartMessage();
    }

    @Override
    public void saveSettings() {
        LookAndFeelObj obj = (LookAndFeelObj)this.mLfComboBox.getSelectedItem();
        Settings.propLookAndFeel.setString(obj.getLFClassName());
        IconTheme theme = (IconTheme)this.mIconThemes.getSelectedItem();
        Settings.propIcontheme.setString("icons/" + theme.getBase().getName());
        this.mSomethingChanged = this.mRestartMessage.isVisible();
        Settings.propPluginViewIsLeft.setBoolean(this.mPluginViewPosition.getSelectedIndex() == 1);
        Settings.propViewDateLayout.setInt(this.mDateLayout.getSelectedIndex());
        if (PersonaInfo.isRandomPersona((PersonaInfo)this.mPersonaSelection.getSelectedItem())) {
            Settings.propRandomPersona.setBoolean(true);
        } else {
            Settings.propRandomPersona.setBoolean(false);
            Settings.propSelectedPersona.setString(((PersonaInfo)this.mPersonaSelection.getSelectedItem()).getId());
        }
        Settings.propInfoIconThemeID.setString(((InfoIconTheme)this.mInfoIconThemes.getSelectedItem()).getID());
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("apps", "preferences-desktop-theme", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("graphical", "Graphical settings");
    }

    private static class LookAndFeelObj
    implements Comparable<LookAndFeelObj> {
        private UIManager.LookAndFeelInfo info;

        public LookAndFeelObj(UIManager.LookAndFeelInfo info) {
            this.info = info;
        }

        public String toString() {
            return this.info.getName();
        }

        public String getLFClassName() {
            return this.info.getClassName();
        }

        @Override
        public int compareTo(LookAndFeelObj other) {
            return this.toString().compareTo(other.toString());
        }
    }
}

