/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.SettingsTab;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import tvbrowser.core.Settings;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.ui.Localizer;
import util.ui.MarkPriorityComboBoxRenderer;
import util.ui.PooledLocalizer;
import util.ui.UiUtilities;

public class MarkingsSettingsTab
implements SettingsTab {
    public static final Localizer mLocalizer = PooledLocalizer.getLocalizerFor(MarkingsSettingsTab.class);
    private ColorLabel mProgramItemMinMarkedColorLb;
    private ColorLabel mProgramItemLowerMediumMarkedColorLb;
    private ColorLabel mProgramItemMediumMarkedColorLb;
    private ColorLabel mProgramItemHigherMediumMarkedColorLb;
    private ColorLabel mProgramItemMaxMarkedColorLb;
    private JCheckBox mProgramItemWithMarkingsIsShowingBorder;
    private JCheckBox mProgramPanelUsesExtraSpaceForMarkIcons;
    private JComboBox mDefaultColor;
    private JEditorPane mHelpLabel;

    @Override
    public JPanel createSettingsPanel() {
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(new FormLayout("5dlu,default:grow", "pref,5dlu,pref,10dlu,pref,5dlu,pref,fill:10dlu:grow,default"));
        pb.border(Borders.DIALOG);
        JPanel defaultMarkings = new JPanel(new FormLayout("default, 5dlu, default", "default,2dlu,default,2dlu,default"));
        String[] colors = new String[]{mLocalizer.msg("color.noPriority", "Don't highlight"), mLocalizer.msg("color.minPriority", "1. Color (minimal priority)"), mLocalizer.msg("color.lowerMediumPriority", "2. Color (lower medium priority)"), mLocalizer.msg("color.mediumPriority", "3. Color (medium priority)"), mLocalizer.msg("color.higherMediumPriority", "4. Color (higher medium priority)"), mLocalizer.msg("color.maxPriority", "5. Color (maximum priority)")};
        this.mProgramPanelUsesExtraSpaceForMarkIcons = new JCheckBox(mLocalizer.msg("panel.extraSpace", "Use additional space for the mark icons"), Settings.propProgramPanelUsesExtraSpaceForMarkIcons.getBoolean());
        defaultMarkings.add((Component)this.mProgramPanelUsesExtraSpaceForMarkIcons, cc.xyw(1, 1, 3));
        this.mProgramItemWithMarkingsIsShowingBorder = new JCheckBox(mLocalizer.msg("color.showBorder", "Show border for highlighted programs"), Settings.propProgramPanelWithMarkingsShowingBoder.getBoolean());
        defaultMarkings.add((Component)this.mProgramItemWithMarkingsIsShowingBorder, cc.xyw(1, 3, 3));
        defaultMarkings.add((Component)new JLabel(mLocalizer.msg("color.showColor", "Highlight with color (default color):")), cc.xy(1, 5));
        this.mDefaultColor = new JComboBox<String>(colors);
        defaultMarkings.add(this.mDefaultColor, cc.xy(3, 5));
        this.mDefaultColor.setSelectedIndex(Settings.propProgramPanelUsedDefaultMarkPriority.getInt() + 1);
        this.mDefaultColor.setRenderer(new MarkPriorityComboBoxRenderer(this.mDefaultColor.getRenderer()));
        JPanel markings = new JPanel(new FormLayout("default, 5dlu, default, 5dlu, default", "default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default, 3dlu, default"));
        Color programItemMinMarkedColor = Settings.propProgramPanelMarkedMinPriorityColor.getColor();
        Color programItemMinDefaultMarkedColor = Settings.propProgramPanelMarkedMinPriorityColor.getDefaultColor();
        markings.add((Component)new JLabel(colors[1]), cc.xy(1, 1));
        this.mProgramItemMinMarkedColorLb = new ColorLabel(programItemMinMarkedColor);
        markings.add((Component)this.mProgramItemMinMarkedColorLb, cc.xy(3, 1));
        this.mProgramItemMinMarkedColorLb.setStandardColor(programItemMinDefaultMarkedColor);
        markings.add((Component)new ColorButton(this.mProgramItemMinMarkedColorLb), cc.xy(5, 1));
        Color programItemLowerMediumMarkedColor = Settings.propProgramPanelMarkedLowerMediumPriorityColor.getColor();
        Color programItemDefaultLowerMediumMarkedColor = Settings.propProgramPanelMarkedLowerMediumPriorityColor.getDefaultColor();
        markings.add((Component)new JLabel(colors[2]), cc.xy(1, 3));
        this.mProgramItemLowerMediumMarkedColorLb = new ColorLabel(programItemLowerMediumMarkedColor);
        markings.add((Component)this.mProgramItemLowerMediumMarkedColorLb, cc.xy(3, 3));
        this.mProgramItemLowerMediumMarkedColorLb.setStandardColor(programItemDefaultLowerMediumMarkedColor);
        markings.add((Component)new ColorButton(this.mProgramItemLowerMediumMarkedColorLb), cc.xy(5, 3));
        Color programItemMediumMarkedColor = Settings.propProgramPanelMarkedMediumPriorityColor.getColor();
        Color programItemMediumDefaultMarkedColor = Settings.propProgramPanelMarkedMediumPriorityColor.getDefaultColor();
        markings.add((Component)new JLabel(colors[3]), cc.xy(1, 5));
        this.mProgramItemMediumMarkedColorLb = new ColorLabel(programItemMediumMarkedColor);
        markings.add((Component)this.mProgramItemMediumMarkedColorLb, cc.xy(3, 5));
        this.mProgramItemMediumMarkedColorLb.setStandardColor(programItemMediumDefaultMarkedColor);
        markings.add((Component)new ColorButton(this.mProgramItemMediumMarkedColorLb), cc.xy(5, 5));
        Color programItemHigherMediumMarkedColor = Settings.propProgramPanelMarkedHigherMediumPriorityColor.getColor();
        Color programItemHigherMediumDefaultMarkedColor = Settings.propProgramPanelMarkedHigherMediumPriorityColor.getDefaultColor();
        markings.add((Component)new JLabel(colors[4]), cc.xy(1, 7));
        this.mProgramItemHigherMediumMarkedColorLb = new ColorLabel(programItemHigherMediumMarkedColor);
        markings.add((Component)this.mProgramItemHigherMediumMarkedColorLb, cc.xy(3, 7));
        this.mProgramItemHigherMediumMarkedColorLb.setStandardColor(programItemHigherMediumDefaultMarkedColor);
        markings.add((Component)new ColorButton(this.mProgramItemHigherMediumMarkedColorLb), cc.xy(5, 7));
        Color programItemMaxMarkedColor = Settings.propProgramPanelMarkedMaxPriorityColor.getColor();
        Color programItemMaxDefaultMarkedColor = Settings.propProgramPanelMarkedMaxPriorityColor.getDefaultColor();
        markings.add((Component)new JLabel(colors[5]), cc.xy(1, 9));
        this.mProgramItemMaxMarkedColorLb = new ColorLabel(programItemMaxMarkedColor);
        markings.add((Component)this.mProgramItemMaxMarkedColorLb, cc.xy(3, 9));
        this.mProgramItemMaxMarkedColorLb.setStandardColor(programItemMaxDefaultMarkedColor);
        markings.add((Component)new ColorButton(this.mProgramItemMaxMarkedColorLb), cc.xy(5, 9));
        this.mHelpLabel = UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("color.help", "The priority that a plugin uses for a program is used to decide which color have to be used for the marking. A higher priority color replaces a lower priority color. The setting for the default color is only for plugins that do not care about the priority. But it works like for plugins that uses the priorities, so if you select the highest priority color there, all marking of plugin which do not care about the priority will replace lower marking colors."), new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
            }
        });
        pb.addSeparator(mLocalizer.msg("color.programMarked", "Highlighting by plugins"), cc.xyw(1, 1, 2));
        pb.add((Component)defaultMarkings, cc.xy(2, 3));
        pb.addSeparator(mLocalizer.msg("color.programMarkedAdditional", "Additional colors (replacing default color)"), cc.xyw(1, 5, 2));
        pb.add((Component)markings, cc.xy(2, 7));
        pb.add((Component)this.mHelpLabel, cc.xy(2, 9));
        return pb.getPanel();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Highlighting");
    }

    @Override
    public void saveSettings() {
        Settings.propProgramPanelUsesExtraSpaceForMarkIcons.setBoolean(this.mProgramPanelUsesExtraSpaceForMarkIcons.isSelected());
        Settings.propProgramPanelWithMarkingsShowingBoder.setBoolean(this.mProgramItemWithMarkingsIsShowingBorder.isSelected());
        Settings.propProgramPanelUsedDefaultMarkPriority.setInt(this.mDefaultColor.getSelectedIndex() - 1);
        Settings.propProgramPanelMarkedMinPriorityColor.setColor(this.mProgramItemMinMarkedColorLb.getColor());
        Settings.propProgramPanelMarkedLowerMediumPriorityColor.setColor(this.mProgramItemLowerMediumMarkedColorLb.getColor());
        Settings.propProgramPanelMarkedMediumPriorityColor.setColor(this.mProgramItemMediumMarkedColorLb.getColor());
        Settings.propProgramPanelMarkedHigherMediumPriorityColor.setColor(this.mProgramItemHigherMediumMarkedColorLb.getColor());
        Settings.propProgramPanelMarkedMaxPriorityColor.setColor(this.mProgramItemMaxMarkedColorLb.getColor());
    }
}

