/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ActionMenu;
import devplugin.ContextMenuIf;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import tvbrowser.core.Settings;
import tvbrowser.core.contextmenu.ConfigMenuItem;
import tvbrowser.core.contextmenu.ContextMenuManager;
import tvbrowser.core.contextmenu.DoNothingContextMenuItem;
import tvbrowser.core.contextmenu.LeaveFullScreenMenuItem;
import tvbrowser.core.contextmenu.SelectProgramContextMenuItem;
import tvbrowser.core.contextmenu.SeparatorMenuItem;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.settings.ContextMenuMouseActionSetting;
import util.ui.CustomComboBoxRenderer;
import util.ui.EnhancedPanelBuilder;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;

public class MouseSettingsTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MouseSettingsTab.class);
    private static final String[] mLeftModifiersName = new String[]{mLocalizer.msg("modifier.none", "None"), mLocalizer.msg("modifier.ctrl", "Ctrl"), mLocalizer.msg("modifier.ctrlShift", "Ctrl+Shift"), mLocalizer.msg("modifier.ctrlAlt", "Ctrl+Alt"), mLocalizer.msg("modifier.altShift", "Alt+Shift"), mLocalizer.msg("modifier.ctrlAltShift", "Ctrl+Alt+Shift")};
    private static final int[] mLeftModifiersEx = new int[]{0, 128, 192, 640, 576, 704};
    private static final String[] mMiddleModifiersName = new String[]{mLocalizer.msg("modifier.none", "None"), mLocalizer.msg("modifier.ctrl", "Ctrl"), mLocalizer.msg("modifier.shift", "Shift"), mLocalizer.msg("modifier.ctrlShift", "Ctrl+Shift"), mLocalizer.msg("modifier.ctrlAlt", "Ctrl+Alt"), mLocalizer.msg("modifier.altShift", "Alt+Shift"), mLocalizer.msg("modifier.ctrlAltShift", "Ctrl+Alt+Shift")};
    private static final int[] mMiddleModifiersEx = new int[]{0, 128, 64, 192, 640, 576, 704};
    private static final String[] MOUSE_BUTTON_TEXT = new String[]{mLocalizer.msg("button.left", "Left"), mLocalizer.msg("button.middle", "Middle")};
    private static final String[] CLICK_COUNT_TEXT = new String[]{mLocalizer.msg("click.single", "Single"), mLocalizer.msg("click.double", "Double")};
    private ArrayList<ContextMenuPanel> mMouseActions = new ArrayList();
    private JPanel mMainPanel;

    @Override
    public JPanel createSettingsPanel() {
        FormLayout layout = new FormLayout("5dlu, pref, 3dlu, pref, fill:pref:grow, 3dlu");
        EnhancedPanelBuilder contentPanel = new EnhancedPanelBuilder(layout);
        contentPanel.border(Borders.DIALOG);
        this.mMouseActions.clear();
        contentPanel.addRow();
        contentPanel.addSeparator(mLocalizer.msg("title", "Title"), CC.xyw(1, contentPanel.getRow(), 6));
        contentPanel.addRow();
        contentPanel.add((Component)new JLabel(mLocalizer.msg("MouseButtons", "Mouse Buttons:")), CC.xyw(2, contentPanel.getRow(), 4));
        this.mMainPanel = new JPanel();
        this.mMainPanel.setLayout(new BoxLayout(this.mMainPanel, 1));
        contentPanel.addRow();
        contentPanel.add((Component)this.mMainPanel, CC.xyw(2, contentPanel.getRow(), 4));
        ContextMenuMouseActionSetting[] leftSingleClick = Settings.propLeftSingleClickIfArray.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] leftDoubleClick = Settings.propLeftDoubleClickIfArray.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] middleSingleClick = Settings.propMiddleSingleClickIfArray.getContextMenuMouseActionArray();
        ContextMenuMouseActionSetting[] middleDoubleClick = Settings.propMiddleDoubleClickIfArray.getContextMenuMouseActionArray();
        this.addListEntries(leftSingleClick, 1, 1);
        this.addListEntries(leftDoubleClick, 1, 2);
        this.addListEntries(middleSingleClick, 2, 1);
        this.addListEntries(middleDoubleClick, 2, 2);
        this.updateList();
        JButton add = new JButton(mLocalizer.msg("add", "Add a new mouse action"), TVBrowserIcons.newIcon(16));
        add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ContextMenuMouseActionSetting setting = new ContextMenuMouseActionSetting(0, DoNothingContextMenuItem.getInstance().getId());
                ContextMenuPanel contextMenuPanel = new ContextMenuPanel(setting, 1, 1);
                MouseSettingsTab.this.mMouseActions.add(contextMenuPanel);
                MouseSettingsTab.this.mMainPanel.add(contextMenuPanel);
                MouseSettingsTab.this.mMainPanel.updateUI();
            }
        });
        contentPanel.addRow();
        contentPanel.add((Component)add, CC.xy(2, contentPanel.getRow()));
        return contentPanel.getPanel();
    }

    private void addListEntries(ContextMenuMouseActionSetting[] actions, int mouseButton, int clickCount) {
        for (ContextMenuMouseActionSetting setting : actions) {
            ContextMenuPanel contextMenuPanel = new ContextMenuPanel(setting, mouseButton, clickCount);
            this.mMouseActions.add(contextMenuPanel);
        }
    }

    private void updateList() {
        this.mMainPanel.removeAll();
        for (ContextMenuPanel panel : this.mMouseActions) {
            this.mMainPanel.add(panel);
        }
        this.mMainPanel.updateUI();
    }

    @Override
    public void saveSettings() {
        ArrayList<ContextMenuMouseActionSetting> singleLeft = new ArrayList<ContextMenuMouseActionSetting>();
        ArrayList<ContextMenuMouseActionSetting> doubleLeft = new ArrayList<ContextMenuMouseActionSetting>();
        ArrayList<ContextMenuMouseActionSetting> singleMiddle = new ArrayList<ContextMenuMouseActionSetting>();
        ArrayList<ContextMenuMouseActionSetting> doubleMiddle = new ArrayList<ContextMenuMouseActionSetting>();
        for (ContextMenuPanel mouseAction : this.mMouseActions) {
            ContextMenuMouseActionSetting setting = mouseAction.getSetting();
            if (mouseAction.isLeftMouseButton()) {
                if (mouseAction.isSingleClick()) {
                    if (this.containsModifier(singleLeft, setting.getModifiersEx())) continue;
                    singleLeft.add(setting);
                    continue;
                }
                if (this.containsModifier(doubleLeft, setting.getModifiersEx())) continue;
                doubleLeft.add(setting);
                continue;
            }
            if (mouseAction.isSingleClick()) {
                if (this.containsModifier(singleMiddle, setting.getModifiersEx())) continue;
                singleMiddle.add(setting);
                continue;
            }
            if (this.containsModifier(doubleMiddle, setting.getModifiersEx())) continue;
            doubleMiddle.add(setting);
        }
        Settings.propLeftSingleClickIfArray.setContextMenuMouseActionArray(singleLeft.toArray(new ContextMenuMouseActionSetting[singleLeft.size()]));
        Settings.propLeftDoubleClickIfArray.setContextMenuMouseActionArray(doubleLeft.toArray(new ContextMenuMouseActionSetting[doubleLeft.size()]));
        Settings.propMiddleSingleClickIfArray.setContextMenuMouseActionArray(singleMiddle.toArray(new ContextMenuMouseActionSetting[singleMiddle.size()]));
        Settings.propMiddleDoubleClickIfArray.setContextMenuMouseActionArray(doubleMiddle.toArray(new ContextMenuMouseActionSetting[doubleMiddle.size()]));
        ContextMenuManager.getInstance().init();
        MainFrame.getInstance().addKeyboardAction();
    }

    private boolean containsModifier(ArrayList<ContextMenuMouseActionSetting> list, int modifier) {
        for (ContextMenuMouseActionSetting setting : list) {
            if (setting.getModifiersEx() != modifier) continue;
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("devices", "input-mouse", 16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "context menu");
    }

    private static class MouseClickSetting {
        private ContextMenuIf mClickInterface;
        private JComboBox mComboBox;

        public MouseClickSetting(ContextMenuIf clickIf) {
            this.mClickInterface = clickIf;
        }

        public ContextMenuIf getSelectedIf() {
            ContextMenuIf selectedIf = (ContextMenuIf)this.mComboBox.getSelectedItem();
            return selectedIf;
        }

        public JComboBox createComboxBox() {
            this.mComboBox = new JComboBox();
            this.mComboBox.setSelectedItem(this.mClickInterface);
            this.mComboBox.setMaximumRowCount(15);
            this.mComboBox.setRenderer(new ContextMenuCellRenderer(this.mComboBox.getRenderer()));
            this.mComboBox.removeAllItems();
            DoNothingContextMenuItem doNothing = DoNothingContextMenuItem.getInstance();
            this.mComboBox.addItem(doNothing);
            this.mComboBox.addItem(SelectProgramContextMenuItem.getInstance());
            this.fillListBox();
            if (this.mClickInterface != null) {
                this.mComboBox.setSelectedItem(this.mClickInterface);
            } else {
                this.mComboBox.setSelectedItem(doNothing);
            }
            return this.mComboBox;
        }

        private void fillListBox() {
            ContextMenuIf[] menuIfList = ContextMenuManager.getInstance().getAvailableContextMenuIfs(true, false);
            Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
            for (ContextMenuIf element : menuIfList) {
                ActionMenu actionMenu;
                if (element instanceof SeparatorMenuItem || element instanceof ConfigMenuItem || element instanceof LeaveFullScreenMenuItem || (actionMenu = element.getContextMenuActions(exampleProgram)) == null) continue;
                this.mComboBox.addItem(element);
            }
        }
    }

    private static class ContextMenuCellRenderer
    extends CustomComboBoxRenderer {
        public ContextMenuCellRenderer(ListCellRenderer backendRenderer) {
            super(backendRenderer);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)this.getBackendRenderer().getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof ContextMenuIf) {
                ContextMenuIf menuIf = (ContextMenuIf)value;
                Program exampleProgram = Plugin.getPluginManager().getExampleProgram();
                StringBuilder text = new StringBuilder();
                Icon icon = null;
                ActionMenu actionMenu = menuIf.getContextMenuActions(exampleProgram);
                if (actionMenu != null) {
                    Action action = actionMenu.getAction();
                    if (action != null) {
                        text.append((String)action.getValue("Name"));
                        icon = (Icon)action.getValue("SmallIcon");
                    } else if (menuIf instanceof PluginProxy) {
                        text.append(((PluginProxy)menuIf).getInfo().getName());
                        icon = ((PluginProxy)menuIf).getMarkIcon();
                    } else {
                        text.append("unknown");
                        icon = null;
                    }
                }
                label.setIcon(icon);
                label.setText(text.toString());
            }
            return label;
        }
    }

    private class ContextMenuPanel
    extends JPanel {
        private JComboBox mMouseButton;
        private JComboBox mModifiersEx;
        private JComboBox mClickCount;
        private MouseClickSetting mMouseClickSetting;

        private ContextMenuPanel(ContextMenuMouseActionSetting setting, int mouseButton, int clickCount) {
            EnhancedPanelBuilder pb = new EnhancedPanelBuilder("default,3dlu,default,3dlu,default,3dlu,default,3dlu,default", (JPanel)this);
            pb.addRow();
            pb.addLabel(mLocalizer.msg("mouseButton", "Mouse button"), CC.xy(1, pb.getRow()));
            pb.addLabel(mLocalizer.msg("clickCount", "Click count"), CC.xy(3, pb.getRow()));
            pb.addLabel(mLocalizer.msg("modifier", "Keyboard"), CC.xy(5, pb.getRow()));
            pb.addLabel(mLocalizer.msg("action", "Action"), CC.xy(7, pb.getRow()));
            pb.addRow();
            this.mMouseButton = new JComboBox<String>(MOUSE_BUTTON_TEXT);
            this.mMouseButton.setSelectedIndex(mouseButton - 1);
            this.mModifiersEx = new JComboBox<String>(mouseButton == 1 ? mLeftModifiersName : mMiddleModifiersName);
            this.mModifiersEx.setSelectedIndex(this.indexOfModifier(mouseButton == 1 ? mLeftModifiersEx : mMiddleModifiersEx, setting.getModifiersEx()));
            this.mMouseClickSetting = new MouseClickSetting(setting.getContextMenuIf());
            this.mClickCount = new JComboBox<String>(CLICK_COUNT_TEXT);
            this.mClickCount.setSelectedIndex(clickCount - 1);
            this.mMouseButton.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    block4: {
                        if (e.getStateChange() != 1) break block4;
                        ((DefaultComboBoxModel)ContextMenuPanel.this.mModifiersEx.getModel()).removeAllElements();
                        if (e.getItem().equals(MOUSE_BUTTON_TEXT[0])) {
                            for (String name : mLeftModifiersName) {
                                ((DefaultComboBoxModel)ContextMenuPanel.this.mModifiersEx.getModel()).addElement(name);
                            }
                        } else {
                            for (String name : mMiddleModifiersName) {
                                ((DefaultComboBoxModel)ContextMenuPanel.this.mModifiersEx.getModel()).addElement(name);
                            }
                        }
                    }
                }
            });
            JButton delete = new JButton(TVBrowserIcons.delete(16));
            delete.setToolTipText(Localizer.getLocalization("i18n_delete"));
            delete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MouseSettingsTab.this.mMouseActions.remove(ContextMenuPanel.this);
                    MouseSettingsTab.this.mMainPanel.remove(ContextMenuPanel.this);
                    MouseSettingsTab.this.mMainPanel.updateUI();
                }
            });
            pb.add((Component)this.mMouseButton, CC.xy(1, pb.getRow()));
            pb.add((Component)this.mClickCount, CC.xy(3, pb.getRow()));
            pb.add((Component)this.mModifiersEx, CC.xy(5, pb.getRow()));
            pb.add((Component)this.mMouseClickSetting.createComboxBox(), CC.xy(7, pb.getRow()));
            pb.add((Component)delete, CC.xy(9, pb.getRow()));
        }

        private int indexOfModifier(int[] modifierExArr, int modifierEx) {
            for (int i = 0; i < modifierExArr.length; ++i) {
                if (modifierExArr[i] != modifierEx) continue;
                return i;
            }
            return 0;
        }

        public ContextMenuMouseActionSetting getSetting() {
            int mouseButton = this.mMouseButton.getSelectedIndex() + 1;
            ContextMenuIf selected = this.mMouseClickSetting.getSelectedIf();
            int modifierEx = mouseButton == 1 ? mLeftModifiersEx[this.mModifiersEx.getSelectedIndex()] : mMiddleModifiersEx[this.mModifiersEx.getSelectedIndex()];
            ContextMenuMouseActionSetting setting = new ContextMenuMouseActionSetting(modifierEx, selected.getId());
            return setting;
        }

        public boolean isLeftMouseButton() {
            return this.mMouseButton.getSelectedIndex() == 0;
        }

        public boolean isSingleClick() {
            return this.mClickCount.getSelectedIndex() == 0;
        }
    }
}

