/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.settings;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import tvbrowser.core.plugin.PluginProxy;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import tvbrowser.extras.common.InternalPluginProxyIf;
import util.ui.FixedSizeIcon;
import util.ui.html.HTMLTextHelper;

public class PluginTableCellRenderer
extends DefaultTableCellRenderer {
    private JPanel mPanel;
    private JLabel mDesc;
    private JLabel mIcon;
    private JLabel mName;
    private CellConstraints mCC = new CellConstraints();
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final Icon DEFAULT_ICON = new ImageIcon("imgs/Jar16.gif");
    private static PluginTableCellRenderer mInstance;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (column == 0) {
            try {
                JPanel checkBoxPanel = new JPanel(new FormLayout("0dlu:grow,default,0dlu:grow", "fill:0dlu:grow,default,fill:0dlu:grow"));
                boolean checked = (Boolean)value;
                JCheckBox checkBox = new JCheckBox("", checked);
                checkBox.setOpaque(false);
                checkBox.setContentAreaFilled(false);
                checkBox.setHorizontalAlignment(0);
                checkBox.setBorderPainted(true);
                if (isSelected) {
                    checkBoxPanel.setForeground(table.getSelectionForeground());
                    checkBoxPanel.setBackground(table.getSelectionBackground());
                } else {
                    checkBoxPanel.setForeground(table.getForeground());
                    checkBoxPanel.setBackground(table.getBackground());
                }
                checkBox.setSelected(checked);
                checkBox.setEnabled(table.getModel().isCellEditable(row, column));
                if (hasFocus) {
                    checkBox.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
                } else {
                    checkBox.setBorder(NO_FOCUS_BORDER);
                }
                checkBoxPanel.add((Component)checkBox, this.mCC.xy(2, 2));
                return checkBoxPanel;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof PluginProxy || value instanceof InternalPluginProxyIf || value instanceof TvDataServiceProxy) {
            Object plugin;
            Icon iconValue = null;
            String nameValue = null;
            String descValue = null;
            boolean isActivated = true;
            if (value instanceof PluginProxy) {
                plugin = (PluginProxy)value;
                iconValue = plugin.getPluginIcon();
                if (iconValue != null) {
                    iconValue = new FixedSizeIcon(16, 16, iconValue);
                }
                descValue = plugin.getInfo().getDescription().replace('\n', ' ');
                isActivated = plugin.isActivated();
                nameValue = plugin.getInfo().getName() + " " + plugin.getInfo().getVersion();
            } else if (value instanceof InternalPluginProxyIf) {
                plugin = (InternalPluginProxyIf)value;
                nameValue = plugin.getName();
                descValue = plugin.getButtonActionDescription().replace('\n', ' ');
                iconValue = plugin.getIcon();
            } else if (value instanceof TvDataServiceProxy) {
                TvDataServiceProxy service = (TvDataServiceProxy)value;
                nameValue = service.getInfo().getName() + " " + service.getInfo().getVersion();
                descValue = HTMLTextHelper.convertHtmlToText(service.getInfo().getDescription()).replace('\n', ' ');
            }
            if (iconValue == null) {
                iconValue = DEFAULT_ICON;
            }
            if (this.mPanel == null) {
                this.mIcon = new JLabel();
                this.mName = new JLabel();
                this.mName.setFont(table.getFont().deriveFont(1, table.getFont().getSize2D() + 2.0f));
                this.mPanel = new JPanel(new FormLayout("default, 2dlu, fill:0dlu:grow", "default, 2dlu, default"));
                this.mPanel.setBorder(Borders.DLU2);
                this.mPanel.add((Component)this.mIcon, this.mCC.xy(1, 1));
                this.mPanel.add((Component)this.mName, this.mCC.xy(3, 1));
            }
            this.mIcon.setOpaque(false);
            this.mIcon.setIcon(iconValue);
            if (this.mDesc != null) {
                this.mPanel.remove(this.mDesc);
            }
            this.mDesc = new JLabel(HTMLTextHelper.convertHtmlToText(descValue));
            this.mDesc.setMinimumSize(new Dimension(100, 10));
            this.mDesc.setOpaque(false);
            this.mPanel.add((Component)this.mDesc, this.mCC.xy(3, 3));
            this.mName.setOpaque(false);
            this.mName.setForeground(table.getForeground());
            this.mName.setText(nameValue);
            this.mPanel.setOpaque(true);
            if (isSelected) {
                this.mName.setEnabled(true);
                this.mDesc.setEnabled(true);
                this.mName.setForeground(table.getSelectionForeground());
                this.mDesc.setForeground(table.getSelectionForeground());
                this.mPanel.setBackground(table.getSelectionBackground());
            } else {
                this.mName.setEnabled(isActivated);
                this.mDesc.setEnabled(isActivated);
                this.mName.setForeground(table.getForeground());
                this.mDesc.setForeground(table.getForeground());
                this.mPanel.setBackground(table.getBackground());
            }
            this.mPanel.setToolTipText(descValue);
            int rowHeight = this.mPanel.getPreferredSize().height + table.getRowMargin();
            if (table.getRowHeight() < rowHeight) {
                table.setRowHeight(rowHeight);
            }
            return this.mPanel;
        }
        return label;
    }

    private PluginTableCellRenderer() {
    }

    public static PluginTableCellRenderer getInstance() {
        if (mInstance == null) {
            mInstance = new PluginTableCellRenderer();
        }
        return mInstance;
    }
}

